/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.gui;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.brainmap.util.LimitedDocument;

public class ScrollText
extends JScrollPane {
    public static int HORIZONTAL = 0;
    public static int VERTICAL = 1;
    private JTextArea text;
    private LimitedDocument doc;

    public ScrollText() {
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(31);
        this.text = new JTextArea();
        this.text.setEditable(false);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.getViewport().add(this.text);
    }

    public ScrollText(boolean editable) {
        this();
        this.text.setEditable(true);
    }

    public ScrollText(int maxChar) {
        this(true);
        this.doc = new LimitedDocument(maxChar);
        this.text.setDocument(this.doc);
    }

    public void setScrollBarsAlways(int dimension) {
        if (dimension == HORIZONTAL) {
            this.setHorizontalScrollBarPolicy(32);
        } else {
            this.setVerticalScrollBarPolicy(22);
        }
    }

    public void setScrollBarsSometimes(int dimension) {
        if (dimension == HORIZONTAL) {
            this.setHorizontalScrollBarPolicy(30);
        } else {
            this.setVerticalScrollBarPolicy(20);
        }
    }

    public void setScrollBarsNever(int dimension) {
        if (dimension == HORIZONTAL) {
            this.setHorizontalScrollBarPolicy(31);
        } else {
            this.setVerticalScrollBarPolicy(21);
        }
    }

    public void setLineWrap(boolean b) {
        this.text.setLineWrap(b);
    }

    public void setEditable(boolean b) {
        this.text.setEditable(b);
    }

    public void setWrapStyleWord(boolean b) {
        this.text.setWrapStyleWord(b);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.text.getDocument().addDocumentListener(listener);
    }

    public Document getDocument() {
        return this.text.getDocument();
    }

    public int getCaretPosition() {
        return this.text.getCaretPosition();
    }

    public String getText(int start, int offset) throws BadLocationException {
        return this.text.getText(start, offset);
    }

    public ScrollText(String s) {
        this();
        this.setText(s);
    }

    public void setText(String s) {
        this.text.setText(s);
        this.text.setCaretPosition(0);
    }

    public void appendText(String s) {
        String original = this.text.getText();
        String total = String.valueOf(String.valueOf(original)).concat(String.valueOf(String.valueOf(s)));
        this.text.setText(total);
        this.text.setCaretPosition(total.length());
    }

    public void scrollUp() {
        this.text.setCaretPosition(0);
    }

    public void scrollDown() {
        this.text.setCaretPosition(this.text.getText().length());
    }

    public String getText() {
        return this.text.getText();
    }

    public void setRows(int i) {
        this.text.setRows(i);
    }

    public void setTextBorder(Border border) {
        this.text.setBorder(border);
    }
}

