/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.talairach;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.brainmap.talairach.TalairachClient;
import org.brainmap.util.ExtensionFilter;

public class CustomFileChooser
extends JDialog
implements ActionListener,
ItemListener,
PropertyChangeListener {
    private TalairachClient father;
    private JFileChooser chooser;
    private JTextArea previewTA;
    private JPanel definePane;
    private JCheckBox doForAllCB;
    private JCheckBox appendDataCB;
    private JLabel coordinatesLbl;
    private JLabel rowLabel;
    private JLabel colLabel;
    private boolean usingTextFields = false;
    private JTextField rowTF;
    private JTextField colTF;
    private File[] files;
    private int count = 0;
    private ExtensionFilter[] filters;

    public CustomFileChooser(TalairachClient parent, File last) {
        super(parent, "Defining File Type", true);
        this.father = parent;
        this.files = this.father.getFileList();
        this.chooser = new JFileChooser(last);
        this.previewTA = new JTextArea();
        this.previewTA.setRows(5);
        this.previewTA.setColumns(10);
        this.previewTA.setEditable(false);
        JScrollPane previewSPane = new JScrollPane(this.previewTA);
        previewSPane.setVerticalScrollBarPolicy(21);
        previewSPane.setHorizontalScrollBarPolicy(32);
        this.coordinatesLbl = new JLabel("Starting   ");
        this.rowLabel = new JLabel("Row: 1");
        this.colLabel = new JLabel("Col: 1");
        this.doForAllCB = new JCheckBox("True for all files.");
        this.doForAllCB.setSelected(true);
        this.appendDataCB = new JCheckBox("<html><font size=-1>Append data after coordinates<br>to result file.</font></html>");
        this.appendDataCB.addItemListener(this);
        this.rowTF = new JTextField();
        this.colTF = new JTextField();
        this.definePane = new JPanel();
        this.definePane.setLayout(new GridBagLayout());
        GridBagConstraints grid = new GridBagConstraints();
        grid.insets = new Insets(5, 5, 5, 5);
        grid.gridy = 1;
        grid.gridwidth = 1;
        this.definePane.add((Component)this.coordinatesLbl, grid);
        grid.gridx = 1;
        this.definePane.add((Component)this.rowLabel, grid);
        grid.gridx = 3;
        this.definePane.add((Component)this.colLabel, grid);
        grid.gridx = 2;
        this.definePane.add((Component)this.rowTF, grid);
        grid.gridx = 4;
        this.definePane.add((Component)this.colTF, grid);
        grid.gridwidth = 5;
        grid.gridx = 0;
        grid.gridy = 6;
        this.definePane.add((Component)this.appendDataCB, grid);
        this.rowTF.setVisible(false);
        this.colTF.setVisible(false);
        this.filters = this.father.getFilters();
        int length = 0;
        if (this.filters != null) {
            length = this.filters.length;
        }
        for (int i = 0; i < length; ++i) {
            this.chooser.setFileFilter(this.filters[i]);
        }
        if (length > 0) {
            this.updateLabels(this.filters[length - 1].getDescription());
        }
        this.chooser.setAccessory(this.definePane);
        this.getContentPane().add((Component)this.chooser, "Center");
        this.chooser.addActionListener(this);
        this.chooser.addPropertyChangeListener(this);
        this.setLocationRelativeTo(this.father);
        this.setSize(650, 300);
        if (this.files == null || this.files.length < 1) {
            return;
        }
        File f = this.files[0];
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(f.getPath()));
            int lineCount = 0;
            do {
                if ((line = in.readLine()) == null) continue;
                this.previewTA.append(String.valueOf(String.valueOf(line)).concat("\n"));
            } while (line != null && ++lineCount < 4);
            in.close();
            this.previewTA.setLocation(0, 0);
        }
        catch (FileNotFoundException ex) {
            this.previewTA.append(String.valueOf(String.valueOf(new StringBuffer("File, ").append(f.getName()).append(", not found.\n\n"))));
        }
        catch (IOException ex) {
            this.previewTA.append(String.valueOf(String.valueOf(new StringBuffer("File, ").append(f.getName()).append(", not readable.\n\n"))));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals("ApproveSelection")) {
            if (this.usingTextFields) {
                int row = Integer.parseInt(this.rowTF.getText());
                int col = Integer.parseInt(this.colTF.getText());
                this.father.setStartRowCol(row, col);
            }
            this.father.addText(String.valueOf(String.valueOf(new StringBuffer("Starting import @ row ").append(this.father.getStartRow()).append(" & col ").append(this.father.getStartCol()))));
        }
        this.setVisible(false);
    }

    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src.equals(this.appendDataCB)) {
            boolean selected = this.appendDataCB.isSelected();
            this.father.setAppend(selected);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object src = e.getSource();
        String pName = e.getPropertyName();
        if (e.equals("fileFilterChanged")) {
            String string = this.chooser.getFileFilter().getDescription();
        }
        if (src.equals(this.chooser) && pName.equals("fileFilterChanged")) {
            String desc = this.chooser.getFileFilter().getDescription();
            if (desc.equals("All Files")) {
                this.usingTextFields = true;
                this.rowTF.setVisible(true);
                this.colTF.setVisible(true);
                this.rowTF.setText("1");
                this.colTF.setText("1");
                this.rowLabel.setText("Row: ");
                this.colLabel.setText("Col: ");
            } else {
                this.usingTextFields = false;
                this.rowTF.setVisible(false);
                this.colTF.setVisible(false);
                this.updateLabels(desc);
            }
        }
    }

    private void updateLabels(String d) {
        for (int i = 0; i < this.filters.length; ++i) {
            if (!d.equals(this.filters[i].getDescription())) continue;
            this.rowLabel.setText("Row: ".concat(String.valueOf(String.valueOf(this.father.getRow(i)))));
            this.colLabel.setText("Col: ".concat(String.valueOf(String.valueOf(this.father.getCol(i)))));
            int row = this.father.getRow(i);
            int col = this.father.getCol(i);
            this.father.setStartRowCol(row, col);
        }
    }

    public void setCurrentDirectory(File f) {
        this.chooser.setCurrentDirectory(f);
    }

    public void setMultiSelectionEnabled(boolean b) {
        this.chooser.setMultiSelectionEnabled(b);
    }

    public File[] getSelectedFiles() {
        return this.chooser.getSelectedFiles();
    }

    public File getSelectedFile() {
        return this.chooser.getSelectedFile();
    }
}

