/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.talairach;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.brainmap.gui.View;
import org.brainmap.image.AnalyzeHeader;
import org.brainmap.image.AnalyzeIO;
import org.brainmap.image.NiftiImage;
import org.brainmap.talairach.TDLabel;
import org.brainmap.util.FileIO;
import org.brainmap.util.StringUtilities;
import org.brainmap.util.XyzCoordinates;

public class Database {
    private String[][] fullLabels;
    private short[] image;
    private NiftiImage nii;
    private boolean addCerebralGray = false;
    private XyzCoordinates brainMin;
    private XyzCoordinates brainMax;
    private XyzCoordinates size;
    public String Error = new String();
    public boolean loaded = false;
    private View view;

    public void setView(View v) {
        this.view = v;
    }

    private void initLength(int i) {
        if (this.view != null) {
            this.view.update("init-".concat(String.valueOf(String.valueOf(i))));
        }
    }

    private void updateUI(int i) {
        if (this.view != null) {
            this.view.update("update-".concat(String.valueOf(String.valueOf(i))));
        }
    }

    private void updateFailed() {
        if (this.view != null) {
            this.view.update("failed");
        }
    }

    public XyzCoordinates getMax() {
        return this.brainMax;
    }

    public XyzCoordinates getMin() {
        return this.brainMin;
    }

    public XyzCoordinates getSize() {
        return this.size;
    }

    public void loadFromShortImage() {
        Class<?> c = this.getClass();
        this.loadFromShortImage(c);
    }

    public void loadFromShortImage(String name) {
        Class<?> c = this.getClass();
        this.loadFromShortImage(c, name);
    }

    public void loadFromShortImage(Class c) {
        this.loadFromShortImage(c, "talairach");
    }

    public void loadFromShortImage(Class c, String name) {
        BufferedReader text = FileIO.openReader(c, String.valueOf(String.valueOf(name)).concat(".txt"));
        BufferedInputStream data = FileIO.openStream(c, String.valueOf(String.valueOf(name)).concat(".img"));
        this.loadFromShortImage(text, data);
    }

    public void loadImage(String name) {
        Class<?> c = this.getClass();
        BufferedReader text = FileIO.openReader(c, String.valueOf(String.valueOf(name)).concat(".txt"));
        BufferedInputStream data = FileIO.openStream(c, String.valueOf(String.valueOf(name)).concat(".img"));
        if (text == null) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("org.brainmap.talairach.Database.loadImage(").append(name).append(") - text null"))));
        }
        if (data == null) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("org.brainmap.talairach.Database.loadImage(").append(name).append(") - data null"))));
        }
        this.loadFromShortImage(text, data);
    }

    public void loadFromShortImage(File labelFile, File header, File image) {
        String path = labelFile.getAbsolutePath();
        int nLines = StringUtilities.CountLinesInFile(path);
        String[] labelArray = StringUtilities.getHeader(path, nLines);
        path = header.getAbsolutePath();
        AnalyzeHeader head = AnalyzeIO.readHeader(path);
        path = image.getAbsolutePath();
        short[] imageArray = AnalyzeIO.readShortImage(path, head);
        this.loadFromShortImage(labelArray, imageArray);
    }

    public void loadFromShortImage(String[] labels, short[] image) {
        this.loaded = false;
        if (labels == null || labels.length < 1) {
            this.Error = "Invalid labels";
            this.updateFailed();
            return;
        }
        if (image == null || image.length < 1) {
            this.Error = "Invalid image";
            this.updateFailed();
            return;
        }
        StringTokenizer st = new StringTokenizer(labels[0]);
        if (st.countTokens() != 7) {
            System.out.println(labels[0]);
            this.Error = "bad first line in talairach.txt";
            this.updateFailed();
            return;
        }
        int nLabels = Integer.parseInt(st.nextToken());
        this.brainMin = new XyzCoordinates();
        this.brainMin.x = Integer.parseInt(st.nextToken());
        this.brainMin.y = Integer.parseInt(st.nextToken());
        this.brainMin.z = Integer.parseInt(st.nextToken());
        this.brainMax = new XyzCoordinates();
        this.brainMax.x = Integer.parseInt(st.nextToken());
        this.brainMax.y = Integer.parseInt(st.nextToken());
        this.brainMax.z = Integer.parseInt(st.nextToken());
        this.size = new XyzCoordinates();
        this.size.x = this.brainMax.x - this.brainMin.x + 1.0f;
        this.size.y = this.brainMax.y - this.brainMin.y + 1.0f;
        this.size.z = this.brainMax.z - this.brainMin.z + 1.0f;
        int increment = 1;
        int sum = 1000;
        if (nLabels + 20 <= 1000) {
            increment = 1;
            sum = nLabels + 1;
        } else {
            float f = (float)(nLabels + 20) / 1000.0f;
            increment = (int)Math.ceil(f);
            f = (float)(nLabels + 20) / (float)increment;
            sum = (int)Math.floor(f);
        }
        this.initLength(sum);
        this.fullLabels = new String[nLabels][5];
        for (int i = 0; i < nLabels; ++i) {
            st = new StringTokenizer(labels[i + 1], ".");
            for (int j = 0; j < 5; ++j) {
                this.fullLabels[i][j] = st.hasMoreTokens() ? st.nextToken() : "*";
            }
            if (i % increment != 0) continue;
            this.updateUI(i / increment);
        }
        int nVoxels = (int)(this.size.x * this.size.y * this.size.z);
        if (image.length != nVoxels) {
            this.Error = "Invalid image";
            this.updateFailed();
            return;
        }
        this.image = image;
        this.loaded = true;
        this.updateUI(sum);
    }

    public void loadFromShortImage(BufferedReader reader, BufferedInputStream stream) {
        int nLabels = 0;
        int increment = 1;
        int sum = 1000;
        try {
            String line = reader.readLine();
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() != 7) {
                System.out.println(line);
                throw new Exception("bad first line in talairach.txt");
            }
            nLabels = Integer.parseInt(st.nextToken());
            this.brainMin = new XyzCoordinates();
            this.brainMin.x = Integer.parseInt(st.nextToken());
            this.brainMin.y = Integer.parseInt(st.nextToken());
            this.brainMin.z = Integer.parseInt(st.nextToken());
            this.brainMax = new XyzCoordinates();
            this.brainMax.x = Integer.parseInt(st.nextToken());
            this.brainMax.y = Integer.parseInt(st.nextToken());
            this.brainMax.z = Integer.parseInt(st.nextToken());
            this.size = new XyzCoordinates();
            this.size.x = this.brainMax.x - this.brainMin.x + 1.0f;
            this.size.y = this.brainMax.y - this.brainMin.y + 1.0f;
            this.size.z = this.brainMax.z - this.brainMin.z + 1.0f;
            if (nLabels + 20 <= 1000) {
                increment = 1;
                sum = nLabels + 1;
            } else {
                float f = (float)(nLabels + 20) / 1000.0f;
                increment = (int)Math.ceil(f);
                f = (float)(nLabels + 20) / (float)increment;
                sum = (int)Math.floor(f);
            }
            this.initLength(sum);
            this.fullLabels = new String[nLabels][5];
            for (int i = 0; i < nLabels; ++i) {
                line = reader.readLine();
                st = new StringTokenizer(line, ".");
                for (int j = 0; j < 5; ++j) {
                    this.fullLabels[i][j] = st.hasMoreTokens() ? st.nextToken() : "*";
                }
                if (i % increment != 0) continue;
                this.updateUI(i / increment);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Error = e.getMessage();
            this.loaded = false;
            this.updateFailed();
            return;
        }
        try {
            int nVoxels = (int)(this.size.x * this.size.y * this.size.z);
            this.image = new short[nVoxels];
            AnalyzeHeader head = AnalyzeIO.newHeader();
            short[] dim = new short[4];
            dim[1] = (short)this.size.x;
            dim[2] = (short)this.size.y;
            dim[3] = (short)this.size.z;
            head.setDimensions(dim);
            head.setMax(nLabels);
            head.setMin(0.0f);
            head.setType(AnalyzeHeader.DT_SHORT);
            this.image = AnalyzeIO.readShortImage(stream, head);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Error = e.getMessage();
            this.loaded = false;
            this.updateFailed();
            return;
        }
        this.loaded = true;
        this.updateUI(sum);
    }

    private TDLabel findLabel_oldShort(int x, int y, int z) {
        if (this.image == null) {
            System.out.println("no image loaded");
            return null;
        }
        if (this.fullLabels == null) {
            System.out.println("no labels loaded");
            return null;
        }
        if ((float)x < this.brainMin.x || (float)x > this.brainMax.x) {
            System.out.print("outside x bounds ".concat(String.valueOf(String.valueOf(x))));
            System.out.print(" ".concat(String.valueOf(String.valueOf(this.brainMin.toString()))));
            System.out.println(" to ".concat(String.valueOf(String.valueOf(this.brainMax.toString()))));
            return null;
        }
        if ((float)y < this.brainMin.y || (float)y > this.brainMax.y) {
            System.out.print("outside y bounds ".concat(String.valueOf(String.valueOf(y))));
            System.out.print(" ".concat(String.valueOf(String.valueOf(this.brainMin.toString()))));
            System.out.println(" to ".concat(String.valueOf(String.valueOf(this.brainMax.toString()))));
            return null;
        }
        if ((float)z < this.brainMin.z || (float)z > this.brainMax.z) {
            System.out.print("outside z bounds ".concat(String.valueOf(String.valueOf(z))));
            System.out.print(" ".concat(String.valueOf(String.valueOf(this.brainMin.toString()))));
            System.out.println(" to ".concat(String.valueOf(String.valueOf(this.brainMax.toString()))));
            return null;
        }
        int cz = z - (int)this.brainMin.z;
        int cy = y - (int)this.brainMin.y;
        int cx = (int)this.brainMax.x - x;
        int voxel = (int)(this.size.x * this.size.y) * cz + (int)this.size.x * cy + cx;
        short value = this.image[voxel];
        if (value < 0 || value >= this.fullLabels.length) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(x))).append(",").append(y).append(",").append(z).append(" is asking for label #").append(value))));
            return null;
        }
        TDLabel result = new TDLabel();
        result.Labels = this.fullLabels[value];
        for (int j = 0; j < 5; ++j) {
            result.pointer[j] = value;
            result.hits[j] = 1;
        }
        return result;
    }

    public NiftiImage getNifti() {
        if (this.nii == null) {
            return this.createNifti();
        }
        return this.nii;
    }

    private NiftiImage createNifti() {
        NiftiImage nii = new NiftiImage();
        nii.setDimensions((int)this.size.x, (int)this.size.y, (int)this.size.z, 1.0f);
        nii.setAffineOffset(this.brainMin.x, this.brainMin.y, this.brainMin.z);
        nii.setRotationalOffset(this.brainMin.x, this.brainMin.y, this.brainMin.z);
        nii.setDataType((short)4);
        int nLabels = this.fullLabels.length;
        nii.setMinMax(0.0f, nLabels);
        nii.setDescription("Talairach Image... ");
        nii.setOneFile(true);
        nii.setImage(this.image);
        nii.setTalairachExtension(this.fullLabels);
        return nii;
    }

    public void load(NiftiImage nii) {
        this.initLength(5);
        this.updateUI(0);
        this.nii = nii;
        this.updateUI(1);
        float[] xyz = nii.getMinXYZ();
        this.brainMin = new XyzCoordinates();
        this.brainMin.x = xyz[0];
        this.brainMin.y = xyz[1];
        this.brainMin.z = xyz[2];
        xyz = nii.getMaxXYZ();
        this.brainMax = new XyzCoordinates();
        this.brainMax.x = xyz[0];
        this.brainMax.y = xyz[1];
        this.brainMax.z = xyz[2];
        short[] dim = nii.getDimensions();
        this.size = new XyzCoordinates();
        this.size.x = dim[1];
        this.size.y = dim[2];
        this.size.z = dim[3];
        if (this.brainMax.x - this.brainMin.x + 1.0f != this.size.x) {
            System.out.println("Database.loadNifti() bad dimensions");
        } else if (this.brainMax.y - this.brainMin.y + 1.0f != this.size.y) {
            System.out.println("Database.loadNifti() bad dimensions");
        } else if (this.brainMax.z - this.brainMin.z + 1.0f != this.size.z) {
            System.out.println("Database.loadNifti() bad dimensions");
        }
        this.updateUI(2);
        this.image = nii.getShortImage();
        int nVoxels = (int)(this.size.x * this.size.y * this.size.z);
        if (this.image.length != nVoxels) {
            System.out.println("Database.loadNifti() bad image size");
        }
        this.updateUI(3);
        String s = nii.getExtensionString();
        String[] lines = s.split("\n");
        int nLabels = lines.length;
        this.fullLabels = new String[nLabels][];
        this.updateUI(4);
        for (int i = 0; i < nLabels; ++i) {
            this.fullLabels[i] = lines[i].split("\\.", 5);
            if (this.fullLabels[i].length == 5) continue;
            StringTokenizer st = new StringTokenizer(lines[i], ".");
            if (st.countTokens() != 5) {
                System.out.println("Database.load(NiftiImage) - bad label - ".concat(String.valueOf(String.valueOf(lines[i]))));
                return;
            }
            this.fullLabels[i] = new String[5];
            for (int j = 0; j < 5; ++j) {
                this.fullLabels[i][j] = st.nextToken();
            }
        }
        this.loaded = true;
        this.updateUI(5);
    }

    private TDLabel findNiftiLabel(int x, int y, int z) {
        if (this.nii.isOutsideBounds(x, y, z)) {
            return null;
        }
        int voxel = this.nii.getIndex(x, y, z);
        short value = this.image[voxel];
        if (value < 0 || value >= this.fullLabels.length) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(x))).append(",").append(y).append(",").append(z).append(" is asking for label #").append(value))));
            return null;
        }
        TDLabel result = new TDLabel();
        result.Labels = this.fullLabels[value];
        for (int j = 0; j < 5; ++j) {
            result.pointer[j] = value;
            result.hits[j] = 1;
        }
        return result;
    }

    public TDLabel nearestGray(int x, int y, int z) {
        return this.nearestGray(x, y, z, 5);
    }

    public TDLabel nearestGraySimple(int x, int y, int z, int range) {
        if (!this.loaded) {
            return null;
        }
        for (int r = 0; r <= range; ++r) {
            TDLabel[] array = this.searchPerimiter(x, y, z, r);
            for (int i = 0; i < array.length; ++i) {
                String matter = array[i].Labels[3];
                if (!"Gray Matter".equals(matter)) continue;
                return array[i];
            }
        }
        return null;
    }

    public TDLabel nearestGray(int x, int y, int z, int range) {
        if (!this.loaded) {
            return null;
        }
        ArrayList<TDLabel> gray = new ArrayList<TDLabel>();
        boolean thereWasATie = false;
        for (int r = 0; r <= range; ++r) {
            TDLabel[] array = this.searchPerimiter(x, y, z, r);
            int tally = 0;
            for (int i = 0; i < array.length; ++i) {
                tally += array[i].hits[0];
            }
            boolean grayFound = false;
            int i = 0;
            while (!grayFound & i < array.length) {
                String matter = array[i].Labels[3];
                if ("Gray Matter".equals(matter)) {
                    boolean foundInList = false;
                    for (int j = 0; j < gray.size(); ++j) {
                        TDLabel label = (TDLabel)gray.get(j);
                        if (!this.equals(label, array[i])) continue;
                        label.hits[0] = (short)(label.hits[0] + array[i].hits[0]);
                        gray.set(j, label);
                        foundInList = true;
                        break;
                    }
                    if (!foundInList) {
                        gray.add(array[i]);
                    }
                    boolean checkForTie = true;
                    short biggestHits = array[i].hits[0];
                    int j = i + 1;
                    while (checkForTie & j < array.length) {
                        if (array[j].hits[0] < biggestHits) {
                            checkForTie = false;
                            grayFound = true;
                            break;
                        }
                        matter = array[j].Labels[3];
                        if ("Gray Matter".equals(matter)) {
                            checkForTie = false;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (gray.size() == 0) continue;
            if (gray.size() == 1) {
                return (TDLabel)gray.get(0);
            }
            short biggest = ((TDLabel)gray.get((int)0)).hits[0];
            int biggestIndex = 0;
            short second = -1;
            int secondIndex = -1;
            for (int i2 = 1; i2 < gray.size(); ++i2) {
                TDLabel label = (TDLabel)gray.get(i2);
                if (label.hits[0] > biggest) {
                    second = biggest;
                    secondIndex = biggestIndex;
                    biggest = label.hits[0];
                    biggestIndex = i2;
                    continue;
                }
                if (label.hits[0] <= second) continue;
                second = label.hits[0];
                secondIndex = i2;
            }
            if (biggest == second) continue;
            return (TDLabel)gray.get(biggestIndex);
        }
        if (gray.size() > 0) {
            TDLabel label = this.nearestGray(x, y, z, range + 1);
            return label;
        }
        return null;
    }

    private boolean equals(TDLabel a, TDLabel b) {
        int tmp = 0;
        for (int i = 0; i < 5; ++i) {
            if (a.pointer[i] != b.pointer[i]) continue;
            tmp = (byte)(tmp + 1);
        }
        return tmp == 5;
    }

    public TDLabel[] search_range(int x, int y, int z, int range) {
        TDLabel temp;
        if (!this.loaded) {
            return null;
        }
        int volume = 2 * range + 1;
        volume = volume * volume * volume;
        ArrayList<TDLabel> labels = new ArrayList<TDLabel>(volume / 10);
        for (int k = z - range; k < z + range + 1; ++k) {
            for (int j = y - range; j < y + range + 1; ++j) {
                for (int i = x - range; i < x + range + 1; ++i) {
                    TDLabel current = this.findLabel(i, j, k);
                    if (current == null) continue;
                    boolean present = false;
                    for (int c = 0; c < labels.size(); ++c) {
                        temp = (TDLabel)labels.get(c);
                        if (!this.equals(temp, current)) continue;
                        present = true;
                        temp.hits[0] = (short)(temp.hits[0] + 1);
                        break;
                    }
                    if (present) continue;
                    current.hits[0] = 1;
                    labels.add(current);
                }
            }
        }
        labels.trimToSize();
        int size = labels.size();
        TDLabel[] out = new TDLabel[size];
        for (int j = 0; j < size; ++j) {
            short maxHits = 0;
            int maxIndex = 0;
            for (int i = 0; i < labels.size(); ++i) {
                temp = (TDLabel)labels.get(i);
                if (temp.hits[0] <= maxHits) continue;
                maxHits = temp.hits[0];
                maxIndex = i;
            }
            out[j] = (TDLabel)labels.get(maxIndex);
            labels.remove(maxIndex);
        }
        return out;
    }

    private TDLabel[] searchPerimiter(int x, int y, int z, int range) {
        TDLabel current;
        int i;
        int j;
        if (range == 0) {
            TDLabel label = this.findLabel(x, y, z);
            if (label != null) {
                return new TDLabel[]{label};
            }
            return new TDLabel[0];
        }
        int big = 2 * range + 1;
        int little = 2 * range - 1;
        int volume = 2 * little * little + 2 * little * big + 2 * big * big;
        ArrayList labels = new ArrayList(volume / 10);
        int k = z + range;
        for (j = y - range; j <= y + range; ++j) {
            for (i = x - range; i <= x + range; ++i) {
                current = this.findLabel(i, j, k);
                if (current == null) continue;
                this.addLabel(labels, current);
            }
        }
        k = z - range;
        for (j = y - range; j <= y + range; ++j) {
            for (i = x - range; i <= x + range; ++i) {
                current = this.findLabel(i, j, k);
                if (current == null) continue;
                this.addLabel(labels, current);
            }
        }
        j = y + range;
        for (k = z - range + 1; k <= z + range - 1; ++k) {
            for (i = x - range; i <= x + range; ++i) {
                current = this.findLabel(i, j, k);
                if (current == null) continue;
                this.addLabel(labels, current);
            }
        }
        j = y - range;
        for (k = z - range + 1; k <= z + range - 1; ++k) {
            for (i = x - range; i <= x + range; ++i) {
                current = this.findLabel(i, j, k);
                if (current == null) continue;
                this.addLabel(labels, current);
            }
        }
        i = x + range;
        for (k = z - range + 1; k <= z + range - 1; ++k) {
            for (j = y - range + 1; j <= y + range - 1; ++j) {
                current = this.findLabel(i, j, k);
                if (current == null) continue;
                this.addLabel(labels, current);
            }
        }
        i = x - range;
        for (k = z - range + 1; k <= z + range - 1; ++k) {
            for (j = y - range + 1; j <= y + range - 1; ++j) {
                current = this.findLabel(i, j, k);
                if (current == null) continue;
                this.addLabel(labels, current);
            }
        }
        labels.trimToSize();
        int size = labels.size();
        TDLabel[] out = new TDLabel[size];
        for (j = 0; j < size; ++j) {
            short maxHits = 0;
            int maxIndex = 0;
            for (i = 0; i < labels.size(); ++i) {
                TDLabel temp = (TDLabel)labels.get(i);
                if (temp.hits[0] <= maxHits) continue;
                maxHits = temp.hits[0];
                maxIndex = i;
            }
            out[j] = (TDLabel)labels.get(maxIndex);
            out[j].hits[1] = out[j].hits[0];
            labels.remove(maxIndex);
        }
        return out;
    }

    private void addLabel(ArrayList list, TDLabel label) {
        block2: {
            boolean present = false;
            for (int c = 0; c < list.size(); ++c) {
                TDLabel temp = (TDLabel)list.get(c);
                if (!this.equals(temp, label)) continue;
                present = true;
                if (label.hits[0] == 0) {
                    System.out.println("hits == 0");
                    label.hits[0] = 1;
                }
                temp.hits[0] = (short)(temp.hits[0] + label.hits[0]);
                break;
            }
            if (present) break block2;
            label.hits[0] = 1;
            list.add(label);
        }
    }

    public TDLabel findLabel(int x, int y, int z) {
        if (!this.loaded) {
            return null;
        }
        if (this.nii != null) {
            return this.findNiftiLabel(x, y, z);
        }
        return this.findLabel_oldShort(x, y, z);
    }

    public void printLabels(PrintStream out) {
        if (!this.loaded) {
            System.out.println("Talairach label database empty");
            return;
        }
        for (int i = 0; i < this.fullLabels.length; ++i) {
            for (int j = 0; j < 5; ++j) {
                out.print(this.fullLabels[i][j]);
                if (j != 4) {
                    out.print(".");
                    continue;
                }
                out.print("\n");
            }
        }
    }
}

