/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.talairach;

import java.util.ArrayList;
import org.brainmap.talairach.TDCoord;
import org.brainmap.talairach.TalairachUtility;
import org.brainmap.util.StringUtilities;

public class ExcelToTD {
    public static void main(String[] args) {
        String[] param;
        ExcelToTD excel = new ExcelToTD();
        try {
            param = excel.parseArgs(args);
        }
        catch (Exception e) {
            param = null;
        }
        if (param == null || param.length < 2 || param.length > 3) {
            excel.usage();
        }
        ArrayList data = excel.getLabels(param);
        String fileName = param[param.length - 1];
        excel.writeResults(fileName, data);
    }

    public void usage() {
        System.err.println();
        System.err.println("usage: ExceltoTD <Code> [:Cubesize], <input file>");
        System.err.println();
        System.err.println("where <Code> must be one of the the following");
        System.err.println("  1 - SPMap data");
        System.err.println("  2 - Talairach Label Data");
        System.err.println("  3 - mm x mm x mm cube search area");
        System.err.println("      use [:Cubesize] for sizes of 3, 5, 7, 9, or 11. Default is 5.");
        System.err.println();
        System.err.println("for example:");
        System.err.println("   ExceltoTD 2, myfile.dat");
        System.err.println("   ExceltoTD 3:9, myfile.dat");
        System.err.println();
        System.err.println("The output tab delimited text file (*.td) format is:");
        System.err.println(" 1-3)  x,y,z coordinates.");
        System.err.println(" 4- )  Data based on <Code> selection.");
        System.err.println();
        System.exit(1);
    }

    public String[] parseArgs(String[] args) throws Exception {
        String[] result;
        String total = "";
        for (int i = 0; i < args.length; ++i) {
            total = String.valueOf(String.valueOf(total)).concat(String.valueOf(String.valueOf(args[i])));
        }
        int index = total.indexOf(",");
        if (index < 0) {
            System.err.println("Additional parameters needed.");
            throw new Exception("Too few arguments");
        }
        String codeS = total.substring(0, index);
        String file = total.substring(index + 1, total.length());
        int code = Integer.parseInt("".concat(String.valueOf(String.valueOf(codeS.charAt(0)))));
        int range = 5;
        if (codeS.length() >= 3 && (range = Integer.parseInt("".concat(String.valueOf(String.valueOf(codeS.charAt(2)))))) != 1 && range != 3 && range != 5 && range != 7 && range != 9 && range != 11) {
            System.err.println("Invalid Cubesize- must be 3, 5, 7, 9 or 11.");
            throw new Exception("Invalid cube range");
        }
        if (code == 3) {
            result = new String[]{String.valueOf(String.valueOf(code)).concat(""), String.valueOf(String.valueOf(range)).concat(""), file};
        } else if (code == 1 || code == 2) {
            result = new String[]{String.valueOf(String.valueOf(code)).concat(""), file};
        } else {
            System.err.println("Invalid Code- must be 1, 2, or 3.");
            throw new Exception("Invalid code");
        }
        return result;
    }

    public ArrayList getLabels(String[] args) {
        ArrayList<TDCoord> data = new ArrayList<TDCoord>();
        String fileName = args[args.length - 1];
        int type = Integer.parseInt(args[0]);
        int nLines = StringUtilities.CountLinesInFile(fileName);
        String[] lines = StringUtilities.getHeader(fileName, nLines);
        if (lines == null) {
            System.err.println("Couldn't open input file: ".concat(String.valueOf(String.valueOf(fileName))));
            System.exit(1);
        }
        for (int i = 0; i < lines.length; ++i) {
            String[] lineData = StringUtilities.scan(lines[i]);
            if (lineData == null || lineData.length < 3) continue;
            TDCoord c = new TDCoord();
            try {
                c.x = Float.parseFloat(lineData[0]);
                c.y = Float.parseFloat(lineData[1]);
                c.z = Float.parseFloat(lineData[2]);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("Unable to parse line ").append(i).append(": ").append(lineData[i]))));
                continue;
            }
            data.add(c);
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Input file ").append(fileName).append(" has ").append(data.size()).append(" records."))));
        TalairachUtility tUtil = new TalairachUtility();
        boolean okay = tUtil.test();
        if (!okay) {
            System.err.println("Error connecting to TD server");
            System.exit(1);
        }
        String base = args[0];
        if (type == 3) {
            base = String.valueOf(String.valueOf(base)).concat(String.valueOf(String.valueOf(":".concat(String.valueOf(String.valueOf(args[1]))))));
        }
        for (int i = 0; i < data.size(); ++i) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Processing record ").append(i + 1))));
            TDCoord c = (TDCoord)data.get(i);
            String query = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(base))).append(",").append(c.x).append(",").append(c.y).append(",").append(c.z)));
            String result = tUtil.sendLine(query);
            c.addResults(result, type);
        }
        System.out.println("done.");
        return data;
    }

    public void writeResults(String fileName, ArrayList data) {
        int tally = 0;
        for (int i = 0; i < data.size(); ++i) {
            TDCoord c = (TDCoord)data.get(i);
            String[] results = c.getResults();
            tally += results.length;
        }
        int index = 0;
        String[] allOfIt = new String[tally];
        for (int i = 0; i < data.size(); ++i) {
            TDCoord c = (TDCoord)data.get(i);
            String[] results = c.getResults();
            for (int j = 0; j < results.length; ++j) {
                allOfIt[index + j] = results[j];
            }
            index += results.length;
        }
        String outFile = String.valueOf(String.valueOf(fileName)).concat(".td");
        StringUtilities.writeStrings(outFile, allOfIt);
    }
}

