/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class ExtensionFilter
extends FileFilter
implements FilenameFilter {
    private boolean allowAll;
    private boolean directories = false;
    private ArrayList bools;
    private ArrayList extensions = new ArrayList();
    private String description = "filters files by extension";

    public ExtensionFilter() {
        this.bools = new ArrayList();
        this.denyAll();
    }

    public ExtensionFilter(String ext, String des) {
        this();
        this.addExtension(ext);
        this.description = des;
    }

    public ExtensionFilter(String suffix) {
        this();
        this.addExtension(suffix);
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDirectories() {
        this.directories = true;
        this.description = "Choose a folder";
    }

    public void allowAll() {
        this.allowAll = true;
    }

    public void denyAll() {
        this.allowAll = false;
    }

    public void addExtension(String suffix) {
        this.addExtension(suffix, true);
    }

    public void addExtension(String suffix, boolean b) {
        this.extensions.add(suffix);
        this.bools.add("".concat(String.valueOf(String.valueOf(b))));
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        if (this.directories) {
            return false;
        }
        return this.accept(f, f.getName());
    }

    public boolean accept(File dir, String name) {
        for (int i = 0; i < this.extensions.size(); ++i) {
            String ext = (String)this.extensions.get(i);
            String b = (String)this.bools.get(i);
            if (!name.endsWith(ext)) continue;
            return b.equals("true");
        }
        return this.allowAll;
    }
}

