/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.util;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class FileIO {
    public static void automount(File f) {
        FileIO.automount(f.getAbsolutePath());
    }

    public static void automount(String path) {
        String script = "ls ".concat(String.valueOf(String.valueOf(path)));
        try {
            Process automount = Runtime.getRuntime().exec(script);
            automount.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static void renameTo(File source, File dest) throws IOException {
        boolean copyOkay = true;
        FileIO.renameTo(source, dest, copyOkay);
    }

    private static void renameTo(File source, File dest, boolean copyOkay) throws IOException {
        if (source == null || dest == null) {
            throw new IOException("Invalid Parameters");
        }
        if (!source.exists()) {
            throw new IOException("Source file does not exist - ".concat(String.valueOf(String.valueOf(source.getAbsolutePath()))));
        }
        File parent = dest.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Unable to write at ".concat(String.valueOf(String.valueOf(parent.getAbsolutePath()))));
        }
        if (dest.exists() && !dest.delete()) {
            String s = "Unable to write at ".concat(String.valueOf(String.valueOf(dest.getAbsolutePath())));
            throw new IOException(s);
        }
        if (source.renameTo(dest)) {
            return;
        }
        try {
            FileIO.wholeCopy(source, dest);
            if (!source.delete()) {
                System.out.println("Copied only - ".concat(String.valueOf(String.valueOf(dest.getAbsolutePath()))));
                if (!copyOkay) {
                    throw new IOException("Copied but didn't move");
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Copy failed: ".concat(String.valueOf(String.valueOf(e.getMessage()))));
        }
    }

    private static void check(File source, File dest, boolean overwrite) throws IOException {
        if (source == null || dest == null) {
            throw new IOException("Invalid Parameters");
        }
        if (!source.exists()) {
            throw new IOException("Source file does not exist - ".concat(String.valueOf(String.valueOf(source.getAbsolutePath()))));
        }
        if (!source.canRead()) {
            throw new IOException("Insufficient permissions - ".concat(String.valueOf(String.valueOf(source.getAbsolutePath()))));
        }
        File parent = dest.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Unable to create directory - ".concat(String.valueOf(String.valueOf(parent.getAbsolutePath()))));
        }
        if (!parent.isDirectory()) {
            throw new IOException("Not a directory - ".concat(String.valueOf(String.valueOf(parent.getAbsolutePath()))));
        }
        if (!parent.canRead() || !parent.canWrite()) {
            throw new IOException("Insufficient permissions - ".concat(String.valueOf(String.valueOf(parent.getAbsolutePath()))));
        }
        if (dest.exists()) {
            if (!overwrite) {
                throw new IOException("Destination file already exists - ".concat(String.valueOf(String.valueOf(dest.getAbsolutePath()))));
            }
            if (!dest.delete()) {
                throw new IOException("Insufficient permissions - ".concat(String.valueOf(String.valueOf(dest.getAbsolutePath()))));
            }
        }
    }

    public static void copy(File source, File dest) throws IOException {
        FileIO.copy(source, dest, true);
    }

    public static void copy(File source, File dest, boolean overwrite) throws IOException {
        FileIO.check(source, dest, overwrite);
        FileIO.scriptCopy(source, dest);
        long sLen = source.length();
        long dLen = dest.length();
        if (sLen != dLen) {
            try {
                dest.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!dest.exists()) {
            throw new IOException("Unable to create destination file - ".concat(String.valueOf(String.valueOf(dest.getAbsolutePath()))));
        }
    }

    public static void copy(String source, String dest) throws IOException {
        FileIO.copy(new File(source), new File(dest));
    }

    public static void move(String source, String dest) throws IOException {
        FileIO.move(new File(source), new File(dest));
    }

    public static void move(File source, File dest) throws IOException {
        FileIO.move(source, dest, true, true);
    }

    public static void move(File source, File dest, boolean overwrite, boolean copyOkay) throws IOException {
        FileIO.check(source, dest, overwrite);
        try {
            if (source.renameTo(dest)) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FileIO.copy(source, dest, overwrite);
        try {
            if (source.delete()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (source.exists() && !copyOkay) {
            throw new IOException("Unable to delete source file - ".concat(String.valueOf(String.valueOf(source.getAbsolutePath()))));
        }
    }

    private static void scriptCopy(File source, File dest) throws IOException {
        Process p;
        String path;
        File f;
        String unique = source.getName();
        long milli = System.currentTimeMillis();
        try {
            f = File.createTempFile(String.valueOf(String.valueOf(new StringBuffer("move_").append(unique).append("_").append(milli))), ".sh");
            path = f.getAbsolutePath();
        }
        catch (Throwable t) {
            throw new IOException("Unable to create temp file");
        }
        String temp = "";
        String sourcePath = source.getAbsolutePath();
        for (int i = 0; i < sourcePath.length(); ++i) {
            char c = sourcePath.charAt(i);
            if (c == ' ') {
                temp = String.valueOf(String.valueOf(temp)).concat("\\");
            }
            temp = String.valueOf(String.valueOf(temp)).concat(String.valueOf(String.valueOf(c)));
        }
        sourcePath = temp;
        temp = "";
        String destPath = dest.getAbsolutePath();
        for (int i = 0; i < destPath.length(); ++i) {
            char c = destPath.charAt(i);
            if (c == ' ') {
                temp = String.valueOf(String.valueOf(temp)).concat("\\");
            }
            temp = String.valueOf(String.valueOf(temp)).concat(String.valueOf(String.valueOf(c)));
        }
        destPath = temp;
        try {
            PrintWriter action = new PrintWriter(new FileOutputStream(f));
            String cp = String.valueOf(String.valueOf(new StringBuffer("cp ").append(sourcePath).append(" ").append(destPath)));
            action.println(cp);
            action.flush();
            action.close();
        }
        catch (Throwable t) {
            throw new IOException("Unable to write temp file");
        }
        try {
            p = Runtime.getRuntime().exec("/bin/bash -f ".concat(String.valueOf(String.valueOf(path))));
        }
        catch (Throwable t) {
            throw new IOException("Unable to run temp file");
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException t) {
            // empty catch block
        }
        int exit = p.exitValue();
        if (exit != 0) {
            throw new IOException("Copy script returned exit value of ".concat(String.valueOf(String.valueOf(exit))));
        }
    }

    private static void slowCopy(File s, File d) throws IOException {
        String source = s.getAbsolutePath();
        String dest = d.getAbsolutePath();
        RandomAccessFile sfile = new RandomAccessFile(source, "r");
        RandomAccessFile dfile = new RandomAccessFile(dest, "rw");
        if (sfile == null || dfile == null) {
            throw new IOException("Unable to open files");
        }
        int size = 1;
        int partialTally = 0;
        int bytes_read = 0;
        byte[] bytes = new byte[size];
        long i = 0L;
        while (true) {
            long offset = i * (long)size;
            sfile.seek(offset);
            bytes_read = sfile.read(bytes);
            if (bytes_read < 0 || bytes == null) break;
            if (bytes.length < size) {
                ++partialTally;
            }
            dfile.seek(offset);
            dfile.write(bytes);
            ++i;
        }
        if (partialTally > 1) {
            throw new IOException("Error reading bytes from source file");
        }
        sfile.close();
        dfile.close();
    }

    private static void wholeCopy(File s, File d) throws IOException {
        DataOutputStream dos;
        ByteArrayOutputStream baos;
        DataInputStream dis;
        String source = s.getAbsolutePath();
        String dest = d.getAbsolutePath();
        long sourceSize = s.length();
        if (sourceSize == (long)0) {
            throw new IOException("Source file is empty");
        }
        System.out.println("FileIO:       sFile  - ".concat(String.valueOf(String.valueOf(sourceSize))));
        try {
            FileInputStream fis = new FileInputStream(source);
            dis = new DataInputStream(fis);
            baos = new ByteArrayOutputStream();
            FileOutputStream fos = new FileOutputStream(dest);
            dos = new DataOutputStream(fos);
        }
        catch (Exception e) {
            System.out.println("FileIO:       Unable to open files");
            throw new IOException("Unable to open files");
        }
        int size = 1;
        int tally = 0;
        long sum = 0L;
        byte[] bytes = new byte[size];
        while (true) {
            int nBytes = size;
            try {
                dis.readFully(bytes);
            }
            catch (EOFException e) {
                break;
            }
            if (nBytes < 0 || bytes == null) break;
            if (bytes.length < size) {
                ++tally;
            }
            baos.write(bytes);
            sum += (long)nBytes;
        }
        try {
            dis.close();
            baos.writeTo(dos);
            dos.flush();
            dos.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        long destSize = d.length();
        if (sum != sourceSize) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("FileIO:       Incomplete copy (").append(sum).append(" of ").append(sourceSize).append(" bytes)"))));
            throw new IOException("Error reading bytes from source file");
        }
        if (destSize != sourceSize) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("FileIO:       Incomplete copy (").append(destSize).append(" of ").append(sourceSize).append(" bytes)"))));
            throw new IOException("Error reading bytes from source file");
        }
        if (tally > 1) {
            System.out.println("FileIO:       Error reading bytes from source file");
            throw new IOException("Error reading bytes from source file");
        }
    }

    private static InputStream getStream(Class c, String path) throws Exception {
        if (new File(path).exists()) {
            return new FileInputStream(path);
        }
        System.out.println(String.valueOf(String.valueOf(new File(path).getAbsolutePath())).concat(" doesn't exist"));
        String sep = System.getProperty("file.separator");
        if (path.indexOf("/") > 0) {
            sep = "/";
        }
        if (path.indexOf(sep) > 0) {
            StringTokenizer st = new StringTokenizer(path, sep);
            while (st.hasMoreTokens()) {
                path = st.nextToken();
            }
        }
        return c.getResourceAsStream(path);
    }

    private static URL getUrl(Class c, String path) {
        URL url;
        if (new File(path).exists()) {
            try {
                URL uRL = new URL(path);
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        String sep = System.getProperty("file.separator");
        if (path.indexOf("/") > 0) {
            sep = "/";
        }
        if (path.indexOf(sep) > 0) {
            StringTokenizer st = new StringTokenizer(path, sep);
            while (st.hasMoreTokens()) {
                path = st.nextToken();
            }
        }
        if ((url = c.getResource(path)) == null) {
            System.err.println("FileIO: can not create a URL for ".concat(String.valueOf(String.valueOf(path))));
        }
        return url;
    }

    public static BufferedReader openReader(Class c, String path) {
        try {
            InputStream in = FileIO.getStream(c, path);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            return bufferedReader;
        }
        catch (Throwable t) {
            System.out.println("org.brainmap.util.FileIO - ".concat(String.valueOf(String.valueOf(t.getMessage()))));
            System.out.println("openReader: can't open ".concat(String.valueOf(String.valueOf(path))));
            t.printStackTrace();
            BufferedReader bufferedReader = null;
            return bufferedReader;
        }
    }

    public static BufferedInputStream openStream(Class c, String path) {
        try {
            InputStream in = FileIO.getStream(c, path);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(in);
            return bufferedInputStream;
        }
        catch (Throwable t) {
            System.out.println("org.brainmap.util.FileIO - ".concat(String.valueOf(String.valueOf(t.getMessage()))));
            System.out.println("openStream: can't open ".concat(String.valueOf(String.valueOf(path))));
            BufferedInputStream bufferedInputStream = null;
            return bufferedInputStream;
        }
    }

    public static ImageIcon openIcon(Class c, String name) {
        return FileIO.openIcon(c, name, name);
    }

    public static ImageIcon openIcon(Class c, String name, String description) {
        URL url = FileIO.getUrl(c, name);
        if (url == null) {
            String s = "org.brainmap.util.FileIO - ";
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(s))).append("loadIcon: can't open ").append(name))));
            return null;
        }
        return new ImageIcon(url, description);
    }

    public static Image openImage(Component observer, String name) throws NullPointerException {
        Class<?> c = observer.getClass();
        try {
            URL url = FileIO.getUrl(c, name);
            if (url == null) {
                Image image = null;
                return image;
            }
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            MediaTracker tracker = new MediaTracker(observer);
            tracker.addImage(image, 0);
            tracker.waitForAll();
            Image image2 = image;
            return image2;
        }
        catch (Throwable e) {
            System.out.println("org.brainmap.util.FileIO - ".concat(String.valueOf(String.valueOf(e.getMessage()))));
            System.out.println("openImage: can't open ".concat(String.valueOf(String.valueOf(name))));
            Image image = null;
            return image;
        }
    }
}

