/*
 * Decompiled with CFR 0.152.
 */
package org.brainmap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StringUtilities {
    public static String relativePath(File f) {
        File pwd = new File(System.getProperty("user.home"));
        String relative = StringUtilities.relativePath(pwd, f);
        if (relative.startsWith("/")) {
            System.out.println("started with /");
            return relative;
        }
        if (relative.startsWith("./")) {
            relative = relative.substring(2);
            System.out.println("started with ./");
        }
        return "~/".concat(String.valueOf(String.valueOf(relative)));
    }

    public static String relativePath(File current, File f) {
        String relative;
        block6: {
            String absolute;
            String sep = System.getProperty("file.separator");
            String base = current.getAbsolutePath();
            String path = f.getAbsolutePath();
            StringTokenizer a = new StringTokenizer(base, sep);
            StringTokenizer b = new StringTokenizer(path, sep);
            relative = "";
            int i = 0;
            while (i < a.countTokens() && i < b.countTokens()) {
                String y;
                String x = a.nextToken();
                if (x.equals(y = b.nextToken())) continue;
                relative = "../".concat(String.valueOf(String.valueOf(y)));
                break;
            }
            for (i = 0; i < a.countTokens(); ++i) {
                relative = "../".concat(String.valueOf(String.valueOf(relative)));
            }
            if (relative.length() == 0 && b.countTokens() > 1) {
                relative = "./";
            }
            i = 0;
            while (i < b.countTokens()) {
                if (relative.length() > 0 && !relative.endsWith("/")) {
                    relative = String.valueOf(String.valueOf(relative)).concat("/");
                }
                relative = String.valueOf(String.valueOf(relative)).concat(String.valueOf(String.valueOf(b.nextToken())));
            }
            if (f.isDirectory()) {
                relative = String.valueOf(String.valueOf(relative)).concat("/");
            }
            if ((absolute = f.getAbsolutePath()).length() >= relative.length()) break block6;
            relative = absolute;
        }
        return relative;
    }

    public static int fromExpString(String exp) {
        try {
            int result;
            int n = result = Integer.parseInt(exp);
            return n;
        }
        catch (NumberFormatException result) {
            int index = exp.indexOf("e");
            if (index == -1) {
                System.out.println("fromExpString: cannot parse string");
                return -1;
            }
            String m = exp.substring(0, index);
            String e = exp.substring(index + 1, exp.length());
            int mult = Integer.parseInt(m);
            int exponent = Integer.parseInt(e);
            int result2 = mult * (int)Math.pow(10.0, exponent);
            return result2;
        }
    }

    public static String toExpString(int i) {
        String trial = "".concat(String.valueOf(String.valueOf(i)));
        if (trial.endsWith("00")) {
            int exp = 0;
            while (trial.endsWith("0")) {
                trial = trial.substring(0, trial.length() - 1);
                ++exp;
            }
            if (exp > 0) {
                trial = String.valueOf(String.valueOf(trial)).concat(String.valueOf(String.valueOf("e".concat(String.valueOf(String.valueOf(exp))))));
            }
        }
        return trial;
    }

    public static String rightAlign(String s, int i) {
        int l = s.length();
        if (l > i) {
            return s;
        }
        for (int j = 0; j < i - l; ++j) {
            s = " ".concat(String.valueOf(String.valueOf(s)));
        }
        return s;
    }

    public static String trim(double f, int max) {
        String s = String.valueOf(String.valueOf(f)).concat("");
        if (s.length() < max) {
            return s;
        }
        if (s.indexOf("E") < 0) {
            s = s.substring(0, max);
            return s;
        }
        StringTokenizer st = new StringTokenizer(s, "E");
        if (st.countTokens() != 2) {
            System.out.print("util.trim() - weird! ");
            System.out.println(String.valueOf(String.valueOf(st.countTokens())).concat(" tokens!"));
        }
        String first = st.nextToken();
        String second = "E".concat(String.valueOf(String.valueOf(st.nextToken())));
        int length = second.length();
        if (second.length() >= max) {
            System.out.print("util.trim() - weird! ");
            System.out.println("second=".concat(String.valueOf(String.valueOf(st.countTokens()))));
        }
        first = first.substring(0, max - length);
        return String.valueOf(String.valueOf(first)).concat(String.valueOf(String.valueOf(second)));
    }

    public static String[] scan(String line) {
        ArrayList<String> list = new ArrayList<String>();
        int l = line.length();
        int last = -1;
        boolean j = false;
        char c = ' ';
        for (int i = 0; i < l; ++i) {
            c = line.charAt(i);
            if (Character.isDigit(c) || c == '.' || c == '-' || c == 'E') {
                if (last >= 0) continue;
                last = i;
                continue;
            }
            if (last < 0) continue;
            String sub = line.substring(last, i);
            last = -1;
            try {
                double d = Double.parseDouble(sub);
            }
            catch (Throwable t) {
                continue;
            }
            list.add(sub);
        }
        if (last > -1) {
            list.add(line.substring(last, l));
        }
        String[] s = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            s[i] = (String)list.get(i);
        }
        return s;
    }

    public static void writeStrings(String path, String[] header) {
        File f = new File(path);
        try {
            FileOutputStream fout = new FileOutputStream(f);
            PrintStream out = new PrintStream(fout);
            for (int i = 0; i < header.length; ++i) {
                out.println(header[i]);
            }
            out.flush();
            out.close();
            fout.close();
        }
        catch (Exception e) {
            System.out.print(String.valueOf(String.valueOf(new StringBuffer("Unable to write file ").append(f.getName()).append("\n"))));
        }
    }

    public static String getFileRoot(String inputString) {
        String fileRoot = inputString.endsWith(".hdr") || inputString.endsWith(".img") ? inputString.substring(0, inputString.length() - 4) : inputString;
        return fileRoot;
    }

    public static String[] getHeader(String path, int size) {
        if (size < 0) {
            return null;
        }
        if (size == 0) {
            return new String[0];
        }
        String[] s = new String[size];
        try {
            File f = new File(path);
            FileInputStream in = new FileInputStream(f);
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader input = new BufferedReader(isr);
            String line = "";
            for (int i = 0; i < size; ++i) {
                s[i] = line = input.readLine();
            }
            input.close();
            isr.close();
            in.close();
        }
        catch (Exception e) {
            System.out.println("getHeader: unable to read ".concat(String.valueOf(String.valueOf(path))));
            String[] stringArray = null;
            return stringArray;
        }
        return s;
    }

    public static int CountLinesInFile(String path) {
        int count = 0;
        try {
            File f = new File(path);
            FileInputStream in = new FileInputStream(f);
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader input = new BufferedReader(isr);
            String line = "";
            while (line != null) {
                line = input.readLine();
                if (line == null) continue;
                ++count;
                if (!StringUtilities.isHeader(line)) continue;
                count = 0;
            }
            input.close();
            isr.close();
            in.close();
        }
        catch (Exception e) {
            System.err.println("CountLinesInFile: unable to open ".concat(String.valueOf(String.valueOf(path))));
            int n = -1;
            return n;
        }
        return count;
    }

    public static boolean isHeader(String line) {
        int len = line.length();
        boolean dash = false;
        for (int i = 0; i < len; ++i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\u0000') continue;
            if (c == '-' || c == '_') {
                dash = true;
                continue;
            }
            return false;
        }
        return dash;
    }
}

