function [DIM,VOX,SCALE,TYPE,OFFSET,ORIGIN,DESCRIP] = wfu_hread(P)
% reads a header
% SPM2 and SPM99 will use the native SPM99 call of spm_hread wich is
%   included in this package as wfu_spm_hread.  This is for ANALYZE files
% SPM5 will use calls to spm_vol.  This should allow reading of ANALYZE
%   or NIFTI files.
% FORMAT [DIM VOX SCALE TYPE OFFSET ORIGIN DESCRIP] = spm_hread(P);
%
% P       - filename 	     (e.g spm or spm.img)
% DIM     - image size       [i j k [l]] (voxels)
% VOX     - voxel size       [x y z [t]] (mm [secs])
% SCALE   - scale factor
% TYPE    - datatype (integer - see spm_type)
% OFFSET  - offset (bytes)
% ORIGIN  - origin [i j k]
% DESCRIP - description string
%___________________________________________________________________________

fileType=wfu_check_nifti(P);
if (fileType == 1) %File is nifti
	v = spm_vol(P);
  DIM = v.dim;
  SCALE = v.pinfo(1,:);
  TYPE = v.dt(1,1);
  OFFSET = v.pinfo(3,:);
  DESCRIP = v.descrip;
  t = inv(v.mat);
  ORIGIN = [t(1,4) t(2,4) t(3,4)];
  if t(1,1) < 0
    t = inv(t * [-1 0 0 0; 0 1 0 0; 0 0 1 0; 0 0 0 1]);
  else
    t = v.mat;
  end
  VOX = [t(1,1) t(2,2) t(3,3)];
elseif (fileType == 0) %File is analyze
  [DIM,VOX,SCALE,TYPE,OFFSET,ORIGIN,DESCRIP] = wfu_spm_hread([spm_str_manip(P,'sd') '.img']);
else %unknown file
	DIM=null(1);
	VOX=null(1);
	SCALE=null(1);
	TYPE=null(1);
	OFFSET=null(1);
	ORIGIN=null(1);
	DESCRIP=null(1);
end



%for variables that are dependent on SPM version:
%spmVersion = wfu_get_ver;
%switch spmVersion
%  case {'SPM2','SPM99'}
%    %% Use our SPM99/2 code to do the header and volume reads
%    %disp('SPM99 or SPM2 detected');
%    [DIM,VOX,SCALE,TYPE,OFFSET,ORIGIN,DESCRIP] = wfu_spm_hread(P);
%  case {'SPM5'}
%    %disp('SPM5 detected');
%    v = spm_vol(P);
%    DIM = v.dim;
%    SCALE = v.pinfo(1,:);
%    TYPE = v.dt(1,1);
%    OFFSET = v.pinfo(3,:);
%    DESCRIP = v.descrip;
%    t = inv(v.mat);
%    ORIGIN = [t(1,4) t(2,4) t(3,4)];
%    if t(1,1) < 0
%        t = inv(t * [-1 0 0 0; 0 1 0 0; 0 0 1 0; 0 0 0 1]);
%    else
%        t = v.mat;
%    end
%    VOX = [t(1,1) t(2,2) t(3,3)];
%  otherwise
%    %Unable to determine SPM version
%    %continue from switch along way above
%    disp('Unable to find SPM version.  Defaulting to internal functions.  NIFTI files will not be able to be read.');
%    [DIM,VOX,SCALE,TYPE,OFFSET,ORIGIN,DESCRIP] = wfu_spm_hread(P)
%end
