function [aheader , volumein] = wfu_read_nifti_header(filename)
    %------------------------------------
    %Check on filename
    %------------------------------------

    if ~exist('filename','var')
      filename = wfu_pickfile({'*.nii';'*.img'}, 'choose an nifti or analyze type file');
    end

    if isempty(filename) | filename(1) == 0
      volumein=[];
      aheader=[];	
      return
    end

    [filePath fileName fileExt junk]=fileparts(filename);
		if strcmpi(fileExt,'.nii')
			headerfile = filename;
	    imagefile = filename;
		else
			headerfile = [filename(1: end-4) '.hdr'];
    	imagefile = [filename(1:end-4) '.img'];
    end

    %----------------------------
    %Construct the analyze header
    %----------------------------
    aheader = wfu_make_analyze_header;			%blank header making call
    vheader = spm_vol(imagefile);           %get header info from file via SPM

    %map SPM_VOL to aheader values
    %%For Flip
      aheader.magnet_transform.value = vheader.mat;
%     tmp = inv(vheader.mat);
%     if tmp(1,1) < 0
%         aheader.magnet_transform.value = inv(tmp * [-1 0 0 0; 0 1 0 0; 0 0 1 0; 0 0 0 1]);
%     else
%         aheader.magnet_transform.value = inv(tmp);
%     end

    %%For Origin
    tmp = inv(aheader.magnet_transform.value);
    tmp = tmp(:,4);
    tmp(4,1) = 0;
    aheader.orig.value=tmp;
    
    %mapping of variables continued...
    iM = inv(vheader.mat);
    if tmp(1,1) < 0
      aheader.orient.value = 0;  
    else
      aheader.orient.value = 1;  
    end
    aheader.x_size.value = aheader.magnet_transform.value(1,1);
    aheader.y_size.value = aheader.magnet_transform.value(2,2);
    aheader.z_size.value = aheader.magnet_transform.value(3,3);
    aheader.x_dim.value = vheader.dim(1,1);
    aheader.y_dim.value = vheader.dim(1,2);
    aheader.z_dim.value = vheader.dim(1,3);
    aheader.t_dim.value = vheader.n(1);
    aheader.scale.value = vheader.pinfo(1,:);
    aheader.descrip.value = vertcat(double(transpose(vheader.descrip)),zeros(80-length(vheader.descrip),1));
    if ischar(aheader.hkey_un0.value)
        aheader.hkey_un0.value = double(aheader.hkey_un0.value);
    end
    aheader.datatype.value = vheader.dt(1);
    aheader.bits.value = spm_type(vheader.dt(1),'bits');
    aheader.vox_units.value = zeros(1, 4); % clear out the default set by wfu_make_analyze_header.

    %%NOT CURRENTLY IN WHAT SPM REPORTS
    %     aheader.db_name.value
    %     aheader.data_type.value
    %     aheader.extents.value
    %     aheader.session_error.value
    %     aheader.glmax.value
    %     aheader.glmin.value
    %     aheader.pad7.value
    %     aheader.vox_units.value
    %     aheader.vox_units.value
    %     aheader.pad8.value

    volumein = spm_read_vols(vheader);

    if aheader.scale.value < 1e-50
        aheader.scale.value = 0;
    end

    %----------------------------------------------------------------------
    %If the image has a scale factor then we must convert the intensities
    %and update the data field types appropriately so idl to matlab conversions
    %are handled properly, and set the scale back to 1.0 since we
    %have converted it to float
    %-----------------------------------------------------------------------
    if aheader.scale.value ~= 1
      scale = aheader.scale.value;
      factor = 1;

       if scale < 1e-5
        scale = double(scale);
        factor = 2;
       end

       volumein = volumein * scale;
      aheader.datatype.value = 16 * factor;
      aheader.bits.value = 32 * factor;
      aheader.scale.value = 1.0;
    end

    %-------------------------------------------------------------------------------
    %Insert the talairach transform 
    %correct the transform for matlab coordinate system if acquired in IDL
    %For now we will not implement this and assume everything was written in matlab
    %--------------------------------------------------------------------------------
    idl_correct = 1;
    idl_correct = 0;
    if sum(findstr(upper(char(aheader.descrip.value)'),'SPM')) > 0
        idl_correct = 0.0;
    end

    mt = zeros(4,4);
    mtb = eye(4);
    mtb(1:3,4) = -1;
    vox_sizes = [aheader.x_size.value aheader.y_size.value aheader.z_size.value];

    for i = 1:3
        mt(i,i) = vox_sizes(i);
    end

    %-------------------------------------------
    %Fill the origin field if not already there
    %Correct for matlab coordinate system
    %-------------------------------------------
    if sum(aheader.orig.value) == 0
        aheader.orig.value = [aheader.x_dim.value aheader.y_dim.value aheader.z_dim.value 0]/2 + 1;
    end

    %-------------------------------------
    %Compute talairach space origin
    %-------------------------------------
    for i = 1:3
        tal_orig(i) = -(aheader.orig.value(i) + idl_correct)*vox_sizes(i);
    end

    %--------------------------------------
    %Generate talairach affine transform
    %--------------------------------------
    mt(1:3,4) = tal_orig';
    mt(4,4) = 1;

    %--------------------------------------------------
    %To get tal coords from matlab coords and mt use
    %talcoords=mt*coord'
    %--------------------------------------------------

    %----------------------------------------
    %Insert transform if not already present
    %----------------------------------------
    if sum(sum(aheader.magnet_transform.value)) == 0
      aheader.magnet_transform.value = mt;
    else 
      %------------------------------------
      %correct for idl coordinate system if there is a magnet_transform
      %------------------------------------
      if aheader.magnet_transform.value(1:3,4) == [-90 -126 -72]' 
        aheader.magnet_transform.value = aheader.magnet_transform.value * mtb;
      end
    end

    %---------------------------------------------------
    %Set the landmark to indicate this is normalized
    %---------------------------------------------------
    if aheader.landmark.value == 0
        aheader.landmark.value = 1;
    end

    if (aheader.orient.value == 0 & aheader.landmark.value == 1)
        aheader.orient.value = 1;
    end
