function varargout = wfu_roi()
% SPM toolbox function to produce a glass brain with an ROI applied.  To
% take the place of spm_getSPM overriden function.
%
% USES assignin to assign hReg, SPM, and xSPM in 'base' workspace

  addpath(fileparts(mfilename));
  wfu_require_tbx_common;
  wfu_require_tbxs('wfu_pickatlas');

  [Finter,Fgraph,CmdLine] = spm('FnUIsetup','Stats: Results');

  [SPM xSPM]=spm_getSPM;
  
  usePA = spm_input('ROI analysis from',[],'b',...
        'Saved File|Pickatlas GUI',['F','P']);

  switch usePA
    case 'F'
      Msk   = spm_select(1,'image','Image defining search volume',[],SPM.swd);
      [fPath fName fExt JUNK] = spm_fileparts(Msk);  %remove pesky ,1 at end of imagename
      Msk=fullfile(fPath,[fName fExt]);
    case 'P'
      atlas_mask_filename=[SPM.swd filesep 'atlas_mask_file.img'];
      [wfu_atlas_region,wfu_atlas_mask,Msk] = wfu_pickatlas(atlas_mask_filename);
    otherwise
      error('Unknown pickatlas usage %s',usePA);
  end

  P = spm_select('List',SPM.swd, '^beta.*\.img$');   %get betas
  if isempty(P)
      P = spm_select('List',SPM.swd,'^spm.*\.img$');   %get spmT, spmF, spmC
  end
  if isempty(P)
      error('WFU_PickAtlas requires beta or spm image for realignment');
  end
  P = {char(fullfile(SPM.swd,P(1,:))),Msk};

  flags.mean=0;
  flags.hold = 0;
  flags.which=1;
  flags.mask=0;

  %   %create temp interactive window to hold progress bar.
  %   Finter = spm_figure('FindWin','Interactive');
  %   set(Finter,'tag','holdFinter');
  %   FinterTemp = spm_figure('GetWin','Interactive');

  spm_reslice(P,flags);

  %   %restore interactive window.
  %   delete(FinterTemp);
  %   set(Finter,'tag','Interactive');

  Msk=prepend(Msk,'r');

  %-Compute Zum's
  %-----------------------------------------------------------------------
  Z         = Inf;

  for i     = xSPM.Ic
    Z = min(Z,spm_get_data(SPM.xCon(i).Vspm,SPM.xVol.XYZ));
  end
  xSPM.Zum=Z;
  xSPM.uum=xSPM.u;

  
  [SPM xSPM] = wfu_VOI(SPM,xSPM,[],Msk);
  
  %
  %
  % MODIFIED FROM spm_results_ui('setup')
  %
  %
  
%     %-Initialise
%     %----------------------------------------------------------------------
%     SPMid      = spm('FnBanner',mfilename,SCCSid);
%     [Finter,Fgraph,CmdLine] = spm('FnUIsetup','Stats: Results');
    FS         = spm('FontSizes');
 
    % clear satfig if it exists
    %----------------------------------------------------------------------
    hSat       = findobj('tag','Satellite');
    spm_figure('clear',hSat);
 
%     %-Get thresholded xSPM data and parameters of design
%     %=======================================================================
%     if (nargin > 1) 
%     [SPM,xSPM] = spm_getSPM(varargin{2});
%     else
%     [SPM,xSPM] = spm_getSPM;
%     end;
 
    if isempty(xSPM) 
    varargout = {[],[],[]};
    return;
    end
 
    M         = SPM.xVol.M;
    DIM       = SPM.xVol.DIM;
    try
        units = SPM.xVol.units;
    catch
        units = {'mm' 'mm' 'mm'};
    end
 
    % ensure pwd = swd so that relative filenames are valid
    %----------------------------------------------------------------------
    cd(SPM.swd)
 
    %-Setup Results User Interface; Display MIP, design matrix & parameters
    %======================================================================
    spm('FigName',['SPM{',xSPM.STAT,'}: Results'],Finter,CmdLine);
 
 
    %-Setup results GUI
    %----------------------------------------------------------------------
    spm_figure('Clear',Finter)
    hReg      = spm_results_ui('SetupGUI',M,DIM,xSPM,Finter);
 
    %-Setup design interrogation menu
    %----------------------------------------------------------------------
    hDesRepUI = spm_DesRep('DesRepUI',SPM);
    figure(Finter)
 
    %-Setup Maximium intensity projection (MIP) & register
    %----------------------------------------------------------------------
    hMIPax = axes('Parent',Fgraph,'Position',[0.05 0.60 0.55 0.36],'Visible','off');
    hMIPax = spm_mip_ui(xSPM.Z,xSPM.XYZmm,M,DIM,hMIPax,units);
 
    spm_XYZreg('XReg',hReg,hMIPax,'spm_mip_ui');
    if xSPM.STAT == 'P'
        str = xSPM.STATstr;
    else
        str = ['SPM\{',xSPM.STATstr,'\}'];
    end
    text(240,260,str,...
        'Interpreter','TeX',...
        'FontSize',FS(14),'Fontweight','Bold',...
        'Parent',hMIPax)
 
 
    %-Print comparison title
    %----------------------------------------------------------------------
    hTitAx = axes('Parent',Fgraph,...
        'Position',[0.02 0.95 0.96 0.02],...
        'Visible','off');
 
    text(0.5,0,xSPM.title,'Parent',hTitAx,...
        'HorizontalAlignment','center',...
        'VerticalAlignment','baseline',...
        'FontWeight','Bold','FontSize',FS(14))
 
 
    %-Print SPMresults: Results directory & thresholding info
    %----------------------------------------------------------------------
    hResAx = axes('Parent',Fgraph,...
        'Position',[0.05 0.55 0.45 0.05],...
        'DefaultTextVerticalAlignment','baseline',...
        'DefaultTextFontSize',FS(9),...
        'DefaultTextColor',[1,1,1]*.7,...
        'Units','points',...
        'Visible','off');
    AxPos = get(hResAx,'Position'); set(hResAx,'YLim',[0,AxPos(4)])
    h     = text(0,24,'SPMresults:','Parent',hResAx,...
        'FontWeight','Bold','FontSize',FS(14));
    text(get(h,'Extent')*[0;0;1;0],24,spm_str_manip(SPM.swd,'a30'),'Parent',hResAx)
    try
        thresDesc = xSPM.thresDesc;
        text(0,12,sprintf('Height threshold %c = %0.6f  {%s}',xSPM.STAT,xSPM.u,thresDesc),'Parent',hResAx)
    catch
        text(0,12,sprintf('Height threshold %c = %0.6f',xSPM.STAT,xSPM.u),'Parent',hResAx)
    end
    text(0,00,sprintf('Extent threshold k = %0.0f voxels',xSPM.k), 'Parent',hResAx)
 
 
    %-Plot design matrix
    %----------------------------------------------------------------------
    hDesMtx   = axes('Parent',Fgraph,'Position',[0.65 0.55 0.25 0.25]);
    hDesMtxIm = image((SPM.xX.nKX + 1)*32);
    xlabel('Design matrix')
    set(hDesMtxIm,'ButtonDownFcn','spm_DesRep(''SurfDesMtx_CB'')',...
        'UserData',struct(...
        'X',        SPM.xX.xKXs.X,...
        'fnames',   {reshape({SPM.xY.VY.fname},size(SPM.xY.VY))},...
        'Xnames',   {SPM.xX.name}))
 
    %-Plot contrasts
    %----------------------------------------------------------------------
    nPar   = size(SPM.xX.X,2);
    xx     = [repmat([0:nPar-1],2,1);repmat([1:nPar],2,1)];
    nCon   = length(xSPM.Ic);
    xCon   = SPM.xCon;
    if nCon
        dy     = 0.15/max(nCon,2);
        hConAx = axes('Position',[0.65 (0.80 + dy*.1) 0.25 dy*(nCon-.1)],...
            'Tag','ConGrphAx','Visible','off');
        title('contrast(s)')
        htxt   = get(hConAx,'title');
        set(htxt,'Visible','on','HandleVisibility','on')
    end
 
    for ii = nCon:-1:1
        axes('Position',[0.65 (0.80 + dy*(nCon - ii +.1)) 0.25 dy*.9])
        if xCon(xSPM.Ic(ii)).STAT == 'T' && size(xCon(xSPM.Ic(ii)).c,2) == 1
 
            %-Single vector contrast for SPM{t} - bar
            %--------------------------------------------------------------
            yy = [zeros(1,nPar);repmat(xCon(xSPM.Ic(ii)).c',2,1);zeros(1,nPar)];
            h  = patch(xx,yy,[1,1,1]*.5);
            set(gca,'Tag','ConGrphAx',...
                'Box','off','TickDir','out',...
                'XTick',spm_DesRep('ScanTick',nPar,10) - 0.5,'XTickLabel','',...
                'XLim', [0,nPar],...
                'YTick',[-1,0,+1],'YTickLabel','',...
                'YLim',[min(xCon(xSPM.Ic(ii)).c),max(xCon(xSPM.Ic(ii)).c)] +...
                [-1 +1] * max(abs(xCon(xSPM.Ic(ii)).c))/10  )
 
        else
 
            %-F-contrast - image
            %--------------------------------------------------------------
            h = image((xCon(xSPM.Ic(ii)).c'/max(abs(xCon(xSPM.Ic(ii)).c(:)))+1)*32);
            set(gca,'Tag','ConGrphAx',...
                'Box','on','TickDir','out',...
                'XTick',spm_DesRep('ScanTick',nPar,10),'XTickLabel','',...
                'XLim', [0,nPar]+0.5,...
                'YTick',[0:size(SPM.xCon(xSPM.Ic(ii)).c,2)]+0.5,....
                'YTickLabel','',...
                'YLim', [0,size(xCon(xSPM.Ic(ii)).c,2)]+0.5 )
 
        end
        ylabel(num2str(xSPM.Ic(ii)))
        set(h,'ButtonDownFcn','spm_DesRep(''SurfCon_CB'')',...
            'UserData', struct( 'i',        xSPM.Ic(ii),...
            'h',        htxt,...
            'xCon',     xCon(xSPM.Ic(ii))))
    end
 
 
    %-Store handles of results section Graphics window objects
    %----------------------------------------------------------------------
    H  = get(Fgraph,'Children');
    H  = findobj(H,'flat','HandleVisibility','on');
    H  = findobj(H);
    Hv = get(H,'Visible');
    set(hResAx,'Tag','PermRes','UserData',struct('H',H,'Hv',{Hv}))
 
 
%     %-Finished results setup
%     %----------------------------------------------------------------------
%     varargout = {hReg,xSPM,SPM};
%     spm('Pointer','Arrow')

  %
  %
  % ALLOW wfu_VOI to modify screen
  %
  %

  %wfu_VOI(SPM,xSPM,hReg,Msk);
  assignin('base','hReg',hReg);
  assignin('base','xSPM',xSPM);
  assignin('base','SPM',SPM);
return


%--------------------------------------------------------------------------
function PO = prepend(PI,pre)
  [pth,nm,xt,vr] = fileparts(deblank(PI));
  PO             = fullfile(pth,[pre nm xt vr]);
  return
%--------------------------------------------------------------------------