function wfu_require_spm_lite(acceptableSPMVersions)
% wfu_require_spm_lite
%
% Function checks the path for spm_vol.m  If not found it
% tries to add the spm_lite direcotry.  Function errors out if 
% wfu_require_spm_lite cannot be sourced.
if nargin < 1
  acceptableSPMVersions={};
end

spmVer=wfu_get_ver();
if ~isempty(spmVer) && ~any(strcmpi(spmVer,acceptableSPMVersions))
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
  disp('!!!!                            !!!!');
  disp('!!!!   POTENTIAL SPM CONFLICT   !!!!');
  disp('!!!!                            !!!!');
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
  disp([]);
  disp([]);
  error('Please remove %s from your path before using this tool.\n',spmVer);
end
if ~any(strcmpi(spmVer,acceptableSPMVersions))
  spmVolFile=which('spm_vol.m');
  if ~isempty(spmVolFile)
    [p f e j]=fileparts(spmVolFile);
    [p spmDir e j]=fileparts(p);
    if strcmp(spmDir,'spm_lite')
      return;
    end
  end
  
  [tbxCommonPath f e j] = fileparts(mfilename('fullpath'));
  spmLitePath=fullfile(tbxCommonPath,'spm_lite');
  fprintf('Adding SPM_lite (%s) to top of path.\n',spmLitePath);
  addpath(spmLitePath,'-begin');
end
