##############################################################################
# @file  Settings.cmake
# @brief Non-default project settings.
#
# This file is included by basis_project_impl() after it looked for the
# required and optional dependencies and the CMake variables related to the
# project directory structure were defined (see BASISDirectories.cmake file
# in @c PROJECT_BINARY_DIR, where BASIS is here the name of the project).
# It is further included before the BasisSettings.cmake file.
#
# In particular, build options should be added in this file using CMake's
# <a href="http://www.cmake.org/cmake/help/cmake-2-8-docs.html#command:option">
# option()</a> command. Further, any common settings related to using a found
# dependency can be set here if the basis_use_package() command was enable
# to import the required configuration of a particular external package.
#
# Copyright (c) 2011--2013 University of Pennsylvania. All rights reserved.<br />
# Copyright (c) 2014--2016 Massachusetts General Hospital, Harvard Medical School. All rights reserved. <br />
# Copyright (c) 2016--     Boston Childrens Hospital, Harvard Medical School. All rights reserved. <br />
#
# See http://www.cbica.upenn.edu/sbia/software/license.html or COPYING file.
#
# Contact: Yangming Ou <yangming.ou@mgh.harvard.edu>; SBIA Group <sbia-software at uphs.upenn.edu>
#
# @ingroup BasisSettings
##############################################################################

# ============================================================================
# packaging
# ============================================================================

list (APPEND CPACK_SOURCE_IGNORE_FILES
  "build/bundle"
  "build/CMakeFiles"
  "build/CMakeCache.txt"
  "build/Makefile"
  "build/cmake_install.cmake"
)
