// This file was automatically generated by:
//  ../../../../bin/GenerateCLP --logoFiles /home/tringo/Projects/Slicer3/Resources/MIT_NAMIC_PNL_Logo.h /home/tringo/Projects/Slicer3/Applications/CLI/DiffusionApplications/StochasticTractographyFilter/GenerateConnectivityMap.xml /home/tringo/Projects/Slicer3-build/Applications/CLI/DiffusionApplications/StochasticTractographyFilter/GenerateConnectivityMapCLP.h
//
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string.h>

#include <itksys/ios/sstream>

#include "tclap/CmdLine.h"
#include "ModuleProcessInformation.h"

#ifdef WIN32
#define Module_EXPORT __declspec(dllexport)
#else
#define Module_EXPORT 
#endif

#if defined(main) && !defined(REGISTER_TEST)
// If main defined as a preprocessor symbol, redefine it to the expected entry point.
#undef main
#define main ModuleEntryPoint

extern "C" {
  Module_EXPORT char *GetXMLModuleDescription();
  Module_EXPORT int ModuleEntryPoint(int, char*[]);
  Module_EXPORT unsigned char *GetModuleLogo(int *width, int *height, int *pixel_size, unsigned long *bufferLength);
}
#endif

extern "C" {
Module_EXPORT char XMLModuleDescription[] = 
"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
"<executable>\n"
"  <category>Tractography.Stochastic</category>\n"
"  <title>Generate Connectivity Map</title>\n"
"  <description>\n"
"  Generates a volume where the value of each voxel is the number of fibers which pass through that voxel divided by the total number of sampled fibers.\n"
"  This value can been interpreted as the probability that a particular voxel is connected to the seed ROI by a fiber tract.\n"
"  </description>\n"
"  <version>1.0</version>\n"
"  <license></license>\n"
"  <contributor>Tri Ngo (tringo@gmail.com)</contributor>\n"
"\n"
"  <parameters>\n"
"    <label>\n"
"    Calculate Statistics Parameters\n"
"    </label>\n"
"    <description>\n"
"    Parameters for the Stochastic Tractography algorithm\n"
"    </description>\n"
"  </parameters>\n"
"\n"
"  <parameters>\n"
"    <label>IO</label>\n"
"    <description>Input/output parameters</description>\n"
"    <file>\n"
"      <name>tractsfilename</name>\n"
"      <label>Input Tracts</label>\n"
"      <channel>input</channel>\n"
"      <index>0</index>\n"
"      <description>Input tracts as VTK XML Polydata file</description>\n"
"    </file>\n"
"    <image type=\"diffusion-weighted\">\n"
"      <name>dwifilename</name>\n"
"      <label>Input Volume</label>\n"
"      <channel>input</channel>\n"
"      <index>1</index>\n"
"      <description>Input DWI volume</description>\n"
"    </image>\n"
"    <image>\n"
"      <name>ncmapfilename</name>\n"
"      <label>Output Volume</label>\n"
"      <channel>output</channel>\n"
"      <index>2</index>\n"
"      <description>Normalized Connectivity Map Output</description>\n"
"    </image>\n"
"  </parameters>\n"
"\n"
"</executable>\n"
"\n"
;

#define static Module_EXPORT
#define const
#define image_MIT_NAMIC_PNL_Logo_width ModuleLogoWidth
#define image_MIT_NAMIC_PNL_Logo_height ModuleLogoHeight
#define image_MIT_NAMIC_PNL_Logo_pixel_size ModuleLogoPixelSize
#define image_MIT_NAMIC_PNL_Logo_length ModuleLogoLength
#define image_MIT_NAMIC_PNL_Logo ModuleLogoImage
#include "MIT_NAMIC_PNL_Logo.h"
#undef static
#undef const
#undef image_MIT_NAMIC_PNL_Logo_width
#undef image_MIT_NAMIC_PNL_Logo_height
#undef image_MIT_NAMIC_PNL_Logo_pixel_size
#undef image_MIT_NAMIC_PNL_Logo_length
#undef image_MIT_NAMIC_PNL_Logo
}

void
splitString (const std::string &text,
             const std::string &separators,
             std::vector<std::string> &words)
{
  int n = text.length();
  int start, stop;
  start = text.find_first_not_of(separators);
  while ((start >= 0) && (start < n))
    {
    stop = text.find_first_of(separators, start);
    if ((stop < 0) || (stop > n)) stop = n;
    words.push_back(text.substr(start, stop - start));
    start = text.find_first_not_of(separators, stop+1);
    }
}

void
splitFilenames (const std::string &text,
                std::vector<std::string> &words)
{
  size_t n = text.length();
  size_t start, stop, startq, stopq;
  bool quoted;
  std::string comma(",");
  std::string quote("\"");
  start = text.find_first_not_of(comma);
  while ((start >= 0) && (start < n))
    {
    quoted = false;
    startq = text.find_first_of(quote, start);
    stopq = text.find_first_of(quote, startq+1);
    stop = text.find_first_of(comma, start);
    if ((stop < 0) || (stop > n)) stop = n;
    if (startq != std::string::npos && stopq != std::string::npos)
      {
      while (startq < stop && stop < stopq && stop != n)
         {
         quoted = true;
         stop = text.find_first_of(comma, stop+1);
         if ((stop < 0) || (stop > n)) stop = n;
         }
      }
    if (!quoted)
      {
      words.push_back(text.substr(start, stop - start));
      }
    else
      {
      words.push_back(text.substr(start+1, stop - start-2));
      }
    start = text.find_first_not_of(comma, stop+1);
    }
}

unsigned char *GetModuleLogo(int *width,
                             int *height,
                             int *pixel_size,
                             unsigned long *length)
{
  *width = ModuleLogoWidth;
  *height = ModuleLogoHeight;
  *pixel_size = ModuleLogoPixelSize;
  *length = ModuleLogoLength;
  return const_cast<unsigned char *>(ModuleLogoImage);
}

char *GetXMLModuleDescription()
{
   return XMLModuleDescription;
}

#define GENERATE_LOGO \
  if (argc >= 2 && (strcmp(argv[1],"--logo") == 0)) \
    { \
    int width, height, pixel_size;     \
    unsigned long length;  \
    unsigned char *logo = GetModuleLogo(&width, &height, &pixel_size, &length);  \
    std::cout << "LOGO" << std::endl;  \
    std::cout << width << std::endl;  \
    std::cout << height << std::endl;  \
    std::cout << pixel_size << std::endl;  \
    std::cout << length << std::endl;  \
    std::cout << logo << std::endl;  \
    return EXIT_SUCCESS;  \
    }
#define GENERATE_XML \
  if (argc >= 2 && (strcmp(argv[1],"--xml") == 0)) \
    { \
    std::cout << GetXMLModuleDescription(); \
    return EXIT_SUCCESS; \
    }
#define GENERATE_TCLAP \
    std::string tractsfilename; \
    std::string dwifilename; \
    std::string ncmapfilename; \
    bool echoSwitch = false; \
    bool xmlSwitch = false; \
    std::string processInformationAddressString = "0"; \
try \
  { \
    std::string fullDescription("Description: "); \
    fullDescription += "Generates a volume where the value of each voxel is the number of fibers which pass through that voxel divided by the total number of sampled fibers.   This value can been interpreted as the probability that a particular voxel is connected to the seed ROI by a fiber tract."; \
    if (!std::string("Tri Ngo (tringo@gmail.com)").empty()) \
      { \
      fullDescription += "\nAuthor(s): Tri Ngo (tringo@gmail.com)"; \
      } \
    if (!std::string("").empty()) \
      { \
      fullDescription += "\nAcknowledgements: "; \
      } \
    TCLAP::CmdLine commandLine (fullDescription, \
       ' ', \
      "1.0" ); \
 \
      itksys_ios::ostringstream msg; \
    msg.str("");msg << "Input tracts as VTK XML Polydata file";    TCLAP::UnlabeledValueArg<std::string> tractsfilenameArg("tractsfilename", msg.str(), 1, tractsfilename, "std::string", commandLine); \
 \
    msg.str("");msg << "Input DWI volume";    TCLAP::UnlabeledValueArg<std::string> dwifilenameArg("dwifilename", msg.str(), 1, dwifilename, "std::string", commandLine); \
 \
    msg.str("");msg << "Normalized Connectivity Map Output";    TCLAP::UnlabeledValueArg<std::string> ncmapfilenameArg("ncmapfilename", msg.str(), 1, ncmapfilename, "std::string", commandLine); \
 \
    msg.str("");msg << "Echo the command line arguments (default: " << echoSwitch << ")"; \
    TCLAP::SwitchArg echoSwitchArg("", "echo", msg.str(), commandLine, echoSwitch); \
 \
    msg.str("");msg << "Produce xml description of command line arguments (default: " << xmlSwitch << ")"; \
    TCLAP::SwitchArg xmlSwitchArg("", "xml", msg.str(), commandLine, xmlSwitch); \
 \
    msg.str("");msg << "Address of a structure to store process information (progress, abort, etc.). (default: " << processInformationAddressString << ")"; \
    TCLAP::ValueArg<std::string > processInformationAddressStringArg("", "processinformationaddress", msg.str(), 0, processInformationAddressString, "std::string", commandLine); \
 \
    commandLine.parse ( argc, (char**) argv ); \
    tractsfilename = tractsfilenameArg.getValue(); \
    dwifilename = dwifilenameArg.getValue(); \
    ncmapfilename = ncmapfilenameArg.getValue(); \
    echoSwitch = echoSwitchArg.getValue(); \
    xmlSwitch = xmlSwitchArg.getValue(); \
    processInformationAddressString = processInformationAddressStringArg.getValue(); \
      } \
catch ( TCLAP::ArgException e ) \
  { \
  std::cerr << "error: " << e.error() << " for arg " << e.argId() << std::endl; \
  return ( EXIT_FAILURE ); \
    }
#define GENERATE_ECHOARGS \
if (echoSwitch) \
{ \
std::cout << "Command Line Arguments" << std::endl; \
std::cout << "    tractsfilename: " << tractsfilename << std::endl; \
std::cout << "    dwifilename: " << dwifilename << std::endl; \
std::cout << "    ncmapfilename: " << ncmapfilename << std::endl; \
std::cout << "    echoSwitch: " << echoSwitch << std::endl; \
std::cout << "    xmlSwitch: " << xmlSwitch << std::endl; \
std::cout << "    processInformationAddressString: " << processInformationAddressString << std::endl; \
}
#define GENERATE_ProcessInformationAddressDecoding \
ModuleProcessInformation *CLPProcessInformation = 0; \
if (processInformationAddressString != "") \
{ \
sscanf(processInformationAddressString.c_str(), "%p", &CLPProcessInformation); \
}
#define PARSE_ARGS GENERATE_LOGO;GENERATE_XML;GENERATE_TCLAP;GENERATE_ECHOARGS;GENERATE_ProcessInformationAddressDecoding;
