// This file was automatically generated by:
//  ../../../../bin/GenerateCLP --logoFiles /home/tringo/Projects/Slicer3/Resources/MIT_NAMIC_PNL_Logo.h /home/tringo/Projects/Slicer3/Applications/CLI/DiffusionApplications/StochasticTractographyFilter/StochasticTractographyFilter.xml /home/tringo/Projects/Slicer3-build/Applications/CLI/DiffusionApplications/StochasticTractographyFilter/StochasticTractographyFilterCLP.h
//
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string.h>

#include <itksys/ios/sstream>

#include "tclap/CmdLine.h"
#include "ModuleProcessInformation.h"

#ifdef WIN32
#define Module_EXPORT __declspec(dllexport)
#else
#define Module_EXPORT 
#endif

#if defined(main) && !defined(REGISTER_TEST)
// If main defined as a preprocessor symbol, redefine it to the expected entry point.
#undef main
#define main ModuleEntryPoint

extern "C" {
  Module_EXPORT char *GetXMLModuleDescription();
  Module_EXPORT int ModuleEntryPoint(int, char*[]);
  Module_EXPORT unsigned char *GetModuleLogo(int *width, int *height, int *pixel_size, unsigned long *bufferLength);
}
#endif

extern "C" {
Module_EXPORT char XMLModuleDescription[] = 
"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
"<executable>\n"
"  <category>Tractography.Stochastic</category>\n"
"  <title>Stochastic Tractography Filter</title>\n"
"  <description>\n"
"  Generates a VTK XML polydata file that contains a collection of sampled fiber tracts.\n"
"  Each fiber tract is a sample from the fiber tract posterior probability distribution.\n"
"  </description>\n"
"  <version>1.0</version>\n"
"  <license></license>\n"
"  <contributor>Tri Ngo (tringo@gmail.com)</contributor>\n"
"\n"
"  <parameters>\n"
"    <label>\n"
"    Stochastic Tractography Parameters\n"
"    </label>\n"
"    <description>\n"
"    Parameters for the Stochastic Tractography algorithm\n"
"    </description>\n"
"\n"
"    <integer>\n"
"      <name>labelnumber</name>\n"
"      <flag>l</flag>\n"
"      <longflag>labelnumber</longflag>\n"
"      <description>Label Number to use as seed points</description>\n"
"      <label>Seed Point(s) Label Number</label>\n"
"      <default>0</default>\n"
"      <constraints>\n"
"        <minimum>0</minimum>\n"
"        <step>1</step>\n"
"      </constraints>\n"
"    </integer>\n"
"       \n"
"    <integer>\n"
"      <name>totaltracts</name>\n"
"      <flag>t</flag>\n"
"      <longflag>totaltracts</longflag>\n"
"      <description>Number of Sample Tracts</description>\n"
"      <label>Total Tracts</label>\n"
"      <default>100</default>\n"
"      <constraints>\n"
"        <minimum>0</minimum>\n"
"        <step>1</step>\n"
"      </constraints>\n"
"    </integer>\n"
"\n"
"    <integer>\n"
"      <name>maxtractlength</name>\n"
"      <flag>m</flag>\n"
"      <longflag>maxtractlength</longflag>\n"
"      <description>Maximum Length of Sample Tract in real dimensions (usually millimeters)</description>\n"
"      <label>Maximum Tract Length (mm)</label>\n"
"      <default>200</default>\n"
"      <constraints>\n"
"        <minimum>0</minimum>\n"
"        <step>1</step>\n"
"      </constraints>\n"
"    </integer>\n"
"    <double>\n"
"      <name>stepsize</name>\n"
"      <flag>s</flag>\n"
"      <longflag>stepsize</longflag>\n"
"      <description>The length of each segment of the tract in real dimensions (usually millimeters)</description>\n"
"      <label>Step Size(mm)</label>\n"
"      <default>0.5</default>\n"
"      <constraints>\n"
"        <minimum>0.1</minimum>\n"
"        <step>0.1</step>\n"
"      </constraints>\n"
"    </double>\n"
"    <double>\n"
"      <name>gamma</name>\n"
"      <flag>g</flag>\n"
"      <longflag>gamma</longflag>\n"
"      <description>A prior parameter controlling the smoothness of the tracts. Larger values reduce probability of sharp turns</description>\n"
"      <label>Gamma</label>\n"
"      <default>1</default>\n"
"    </double>\n"
"    <integer>\n"
"      <name>maxlikelihoodcachesize</name>\n"
"      <flag>c</flag>\n"
"      <longflag>maxlikelihoodcachesize</longflag>\n"
"      <description>Maximum Size of Likelihood Cache</description>\n"
"      <label>Maximum Cache Size</label>\n"
"      <default>100</default>\n"
"      <constraints>\n"
"        <minimum>0</minimum>\n"
"        <step>1</step>\n"
"      </constraints>\n"
"    </integer>\n"
"    <boolean>\n"
"      <name>recenteroriginswitch</name>\n"
"      <flag>r</flag>\n"
"      <default>true</default>\n"
"      <longflag>recenteroriginswitch</longflag>\n"
"      <label>Recenter Image Origins</label>\n"
"      <description>Ignore the origins of the ROI and WM mask and set it to be the same as the DWI image origin</description>\n"
"    </boolean>\n"
"    <boolean>\n"
"      <name>streamlineswitch</name>\n"
"      <flag>z</flag>\n"
"      <default>false</default>\n"
"      <longflag>streamlineswitch</longflag>\n"
"      <label>Streamline Tractography</label>\n"
"      <description>\n"
"        Perform simple major eigenvector streamline tractography instead of stochastic tractography.\n"
"        Enabling this option ignores all options relating to stochastic tractography.\n"
"      </description>\n"
"    </boolean>\n"
"    <boolean>\n"
"      <name>nninterpolationswitch</name>\n"
"      <flag>n</flag>\n"
"      <default>false</default>\n"
"      <longflag>nninterpolationswitch</longflag>\n"
"      <label>Nearest Neighbor Interpolation</label>\n"
"      <description>Use Nearest Neighbor instead of Stochastic Voxel Interpolation</description>\n"
"    </boolean>\n"
"    <integer>\n"
"      <name>totalthreads</name>\n"
"      <flag>j</flag>\n"
"      <longflag>totalthreads</longflag>\n"
"      <description>Total number of threads to use.  Default value of zero sets number of threads to number of CPUs</description>\n"
"      <label>Total Threads</label>\n"
"      <default>0</default>\n"
"      <constraints>\n"
"        <minimum>0</minimum>\n"
"        <step>1</step>\n"
"      </constraints>\n"
"    </integer>\n"
"    <boolean>\n"
"      <name>continuoustractsswitch</name>\n"
"      <flag>d</flag>\n"
"      <longflag>continuous</longflag>\n"
"      <description>Output tracts in continuous instead of discretized IJK space.</description>\n"
"      <label>continuoustractsswitch</label>\n"
"      <default>false</default>\n"
"    </boolean>  \n"
"  </parameters>\n"
"\n"
"  <parameters>\n"
"    <label>IO</label>\n"
"    <description>Input/output parameters</description>\n"
"    <image type=\"diffusion-weighted\">\n"
"      <name>dwifilename</name>\n"
"      <label>Input Volume</label>\n"
"      <channel>input</channel>\n"
"      <index>0</index>\n"
"      <description>Input DWI volume to be filtered</description>\n"
"    </image>\n"
"    <image>\n"
"      <name>wmpfilename</name>\n"
"      <label>Input White Matter Probability Volume</label>\n"
"      <channel>input</channel>\n"
"      <index>1</index>\n"
"      <description>Input Mask volume that provides the probability that the voxel is white matter </description>\n"
"    </image>\n"
"    <image>\n"
"      <name>roifilename</name>\n"
"      <label>Input ROI Volume</label>\n"
"      <channel>input</channel>\n"
"      <index>2</index>\n"
"      <description>Input ROI volume used to seed algorithm</description>\n"
"    </image>\n"
"    <file>\n"
"      <name>tractsfilename</name>\n"
"      <label>Output Tracts</label>\n"
"      <channel>output</channel>\n"
"      <index>3</index>\n"
"      <description>Output tracts as VTK XML Polydata file (.vtp extension)</description>\n"
"    </file>\n"
"  </parameters>\n"
"\n"
"</executable>\n"
"\n"
;

#define static Module_EXPORT
#define const
#define image_MIT_NAMIC_PNL_Logo_width ModuleLogoWidth
#define image_MIT_NAMIC_PNL_Logo_height ModuleLogoHeight
#define image_MIT_NAMIC_PNL_Logo_pixel_size ModuleLogoPixelSize
#define image_MIT_NAMIC_PNL_Logo_length ModuleLogoLength
#define image_MIT_NAMIC_PNL_Logo ModuleLogoImage
#include "MIT_NAMIC_PNL_Logo.h"
#undef static
#undef const
#undef image_MIT_NAMIC_PNL_Logo_width
#undef image_MIT_NAMIC_PNL_Logo_height
#undef image_MIT_NAMIC_PNL_Logo_pixel_size
#undef image_MIT_NAMIC_PNL_Logo_length
#undef image_MIT_NAMIC_PNL_Logo
}

void
splitString (const std::string &text,
             const std::string &separators,
             std::vector<std::string> &words)
{
  int n = text.length();
  int start, stop;
  start = text.find_first_not_of(separators);
  while ((start >= 0) && (start < n))
    {
    stop = text.find_first_of(separators, start);
    if ((stop < 0) || (stop > n)) stop = n;
    words.push_back(text.substr(start, stop - start));
    start = text.find_first_not_of(separators, stop+1);
    }
}

void
splitFilenames (const std::string &text,
                std::vector<std::string> &words)
{
  size_t n = text.length();
  size_t start, stop, startq, stopq;
  bool quoted;
  std::string comma(",");
  std::string quote("\"");
  start = text.find_first_not_of(comma);
  while ((start >= 0) && (start < n))
    {
    quoted = false;
    startq = text.find_first_of(quote, start);
    stopq = text.find_first_of(quote, startq+1);
    stop = text.find_first_of(comma, start);
    if ((stop < 0) || (stop > n)) stop = n;
    if (startq != std::string::npos && stopq != std::string::npos)
      {
      while (startq < stop && stop < stopq && stop != n)
         {
         quoted = true;
         stop = text.find_first_of(comma, stop+1);
         if ((stop < 0) || (stop > n)) stop = n;
         }
      }
    if (!quoted)
      {
      words.push_back(text.substr(start, stop - start));
      }
    else
      {
      words.push_back(text.substr(start+1, stop - start-2));
      }
    start = text.find_first_not_of(comma, stop+1);
    }
}

unsigned char *GetModuleLogo(int *width,
                             int *height,
                             int *pixel_size,
                             unsigned long *length)
{
  *width = ModuleLogoWidth;
  *height = ModuleLogoHeight;
  *pixel_size = ModuleLogoPixelSize;
  *length = ModuleLogoLength;
  return const_cast<unsigned char *>(ModuleLogoImage);
}

char *GetXMLModuleDescription()
{
   return XMLModuleDescription;
}

#define GENERATE_LOGO \
  if (argc >= 2 && (strcmp(argv[1],"--logo") == 0)) \
    { \
    int width, height, pixel_size;     \
    unsigned long length;  \
    unsigned char *logo = GetModuleLogo(&width, &height, &pixel_size, &length);  \
    std::cout << "LOGO" << std::endl;  \
    std::cout << width << std::endl;  \
    std::cout << height << std::endl;  \
    std::cout << pixel_size << std::endl;  \
    std::cout << length << std::endl;  \
    std::cout << logo << std::endl;  \
    return EXIT_SUCCESS;  \
    }
#define GENERATE_XML \
  if (argc >= 2 && (strcmp(argv[1],"--xml") == 0)) \
    { \
    std::cout << GetXMLModuleDescription(); \
    return EXIT_SUCCESS; \
    }
#define GENERATE_TCLAP \
    int labelnumber = 0; \
    int totaltracts = 100; \
    int maxtractlength = 200; \
    double stepsize = 0.5; \
    double gamma = 1; \
    int maxlikelihoodcachesize = 100; \
    bool recenteroriginswitch = false; \
    bool streamlineswitch = false; \
    bool nninterpolationswitch = false; \
    int totalthreads = 0; \
    bool continuoustractsswitch = false; \
    std::string dwifilename; \
    std::string wmpfilename; \
    std::string roifilename; \
    std::string tractsfilename; \
    bool echoSwitch = false; \
    bool xmlSwitch = false; \
    std::string processInformationAddressString = "0"; \
try \
  { \
    std::string fullDescription("Description: "); \
    fullDescription += "Generates a VTK XML polydata file that contains a collection of sampled fiber tracts.   Each fiber tract is a sample from the fiber tract posterior probability distribution."; \
    if (!std::string("Tri Ngo (tringo@gmail.com)").empty()) \
      { \
      fullDescription += "\nAuthor(s): Tri Ngo (tringo@gmail.com)"; \
      } \
    if (!std::string("").empty()) \
      { \
      fullDescription += "\nAcknowledgements: "; \
      } \
    TCLAP::CmdLine commandLine (fullDescription, \
       ' ', \
      "1.0" ); \
 \
      itksys_ios::ostringstream msg; \
    msg.str("");msg << "Label Number to use as seed points (default: " << labelnumber << ")"; \
    TCLAP::ValueArg<int > labelnumberArg("l", "labelnumber", msg.str(), 0, labelnumber, "int", commandLine); \
 \
    msg.str("");msg << "Number of Sample Tracts (default: " << totaltracts << ")"; \
    TCLAP::ValueArg<int > totaltractsArg("t", "totaltracts", msg.str(), 0, totaltracts, "int", commandLine); \
 \
    msg.str("");msg << "Maximum Length of Sample Tract in real dimensions (usually millimeters) (default: " << maxtractlength << ")"; \
    TCLAP::ValueArg<int > maxtractlengthArg("m", "maxtractlength", msg.str(), 0, maxtractlength, "int", commandLine); \
 \
    msg.str("");msg << "The length of each segment of the tract in real dimensions (usually millimeters) (default: " << stepsize << ")"; \
    TCLAP::ValueArg<double > stepsizeArg("s", "stepsize", msg.str(), 0, stepsize, "double", commandLine); \
 \
    msg.str("");msg << "A prior parameter controlling the smoothness of the tracts. Larger values reduce probability of sharp turns (default: " << gamma << ")"; \
    TCLAP::ValueArg<double > gammaArg("g", "gamma", msg.str(), 0, gamma, "double", commandLine); \
 \
    msg.str("");msg << "Maximum Size of Likelihood Cache (default: " << maxlikelihoodcachesize << ")"; \
    TCLAP::ValueArg<int > maxlikelihoodcachesizeArg("c", "maxlikelihoodcachesize", msg.str(), 0, maxlikelihoodcachesize, "int", commandLine); \
 \
    msg.str("");msg << "Ignore the origins of the ROI and WM mask and set it to be the same as the DWI image origin (default: " << recenteroriginswitch << ")"; \
    TCLAP::SwitchArg recenteroriginswitchArg("r", "recenteroriginswitch", msg.str(), commandLine, recenteroriginswitch); \
 \
    msg.str("");msg << "Perform simple major eigenvector streamline tractography instead of stochastic tractography.         Enabling this option ignores all options relating to stochastic tractography. (default: " << streamlineswitch << ")"; \
    TCLAP::SwitchArg streamlineswitchArg("z", "streamlineswitch", msg.str(), commandLine, streamlineswitch); \
 \
    msg.str("");msg << "Use Nearest Neighbor instead of Stochastic Voxel Interpolation (default: " << nninterpolationswitch << ")"; \
    TCLAP::SwitchArg nninterpolationswitchArg("n", "nninterpolationswitch", msg.str(), commandLine, nninterpolationswitch); \
 \
    msg.str("");msg << "Total number of threads to use.  Default value of zero sets number of threads to number of CPUs (default: " << totalthreads << ")"; \
    TCLAP::ValueArg<int > totalthreadsArg("j", "totalthreads", msg.str(), 0, totalthreads, "int", commandLine); \
 \
    msg.str("");msg << "Output tracts in continuous instead of discretized IJK space. (default: " << continuoustractsswitch << ")"; \
    TCLAP::SwitchArg continuoustractsswitchArg("d", "continuous", msg.str(), commandLine, continuoustractsswitch); \
 \
    msg.str("");msg << "Input DWI volume to be filtered";    TCLAP::UnlabeledValueArg<std::string> dwifilenameArg("dwifilename", msg.str(), 1, dwifilename, "std::string", commandLine); \
 \
    msg.str("");msg << "Input Mask volume that provides the probability that the voxel is white matter";    TCLAP::UnlabeledValueArg<std::string> wmpfilenameArg("wmpfilename", msg.str(), 1, wmpfilename, "std::string", commandLine); \
 \
    msg.str("");msg << "Input ROI volume used to seed algorithm";    TCLAP::UnlabeledValueArg<std::string> roifilenameArg("roifilename", msg.str(), 1, roifilename, "std::string", commandLine); \
 \
    msg.str("");msg << "Output tracts as VTK XML Polydata file (.vtp extension)";    TCLAP::UnlabeledValueArg<std::string> tractsfilenameArg("tractsfilename", msg.str(), 1, tractsfilename, "std::string", commandLine); \
 \
    msg.str("");msg << "Echo the command line arguments (default: " << echoSwitch << ")"; \
    TCLAP::SwitchArg echoSwitchArg("", "echo", msg.str(), commandLine, echoSwitch); \
 \
    msg.str("");msg << "Produce xml description of command line arguments (default: " << xmlSwitch << ")"; \
    TCLAP::SwitchArg xmlSwitchArg("", "xml", msg.str(), commandLine, xmlSwitch); \
 \
    msg.str("");msg << "Address of a structure to store process information (progress, abort, etc.). (default: " << processInformationAddressString << ")"; \
    TCLAP::ValueArg<std::string > processInformationAddressStringArg("", "processinformationaddress", msg.str(), 0, processInformationAddressString, "std::string", commandLine); \
 \
    commandLine.parse ( argc, (char**) argv ); \
    labelnumber = labelnumberArg.getValue(); \
    totaltracts = totaltractsArg.getValue(); \
    maxtractlength = maxtractlengthArg.getValue(); \
    stepsize = stepsizeArg.getValue(); \
    gamma = gammaArg.getValue(); \
    maxlikelihoodcachesize = maxlikelihoodcachesizeArg.getValue(); \
    recenteroriginswitch = recenteroriginswitchArg.getValue(); \
    streamlineswitch = streamlineswitchArg.getValue(); \
    nninterpolationswitch = nninterpolationswitchArg.getValue(); \
    totalthreads = totalthreadsArg.getValue(); \
    continuoustractsswitch = continuoustractsswitchArg.getValue(); \
    dwifilename = dwifilenameArg.getValue(); \
    wmpfilename = wmpfilenameArg.getValue(); \
    roifilename = roifilenameArg.getValue(); \
    tractsfilename = tractsfilenameArg.getValue(); \
    echoSwitch = echoSwitchArg.getValue(); \
    xmlSwitch = xmlSwitchArg.getValue(); \
    processInformationAddressString = processInformationAddressStringArg.getValue(); \
      } \
catch ( TCLAP::ArgException e ) \
  { \
  std::cerr << "error: " << e.error() << " for arg " << e.argId() << std::endl; \
  return ( EXIT_FAILURE ); \
    }
#define GENERATE_ECHOARGS \
if (echoSwitch) \
{ \
std::cout << "Command Line Arguments" << std::endl; \
std::cout << "    labelnumber: " << labelnumber << std::endl; \
std::cout << "    totaltracts: " << totaltracts << std::endl; \
std::cout << "    maxtractlength: " << maxtractlength << std::endl; \
std::cout << "    stepsize: " << stepsize << std::endl; \
std::cout << "    gamma: " << gamma << std::endl; \
std::cout << "    maxlikelihoodcachesize: " << maxlikelihoodcachesize << std::endl; \
std::cout << "    recenteroriginswitch: " << recenteroriginswitch << std::endl; \
std::cout << "    streamlineswitch: " << streamlineswitch << std::endl; \
std::cout << "    nninterpolationswitch: " << nninterpolationswitch << std::endl; \
std::cout << "    totalthreads: " << totalthreads << std::endl; \
std::cout << "    continuoustractsswitch: " << continuoustractsswitch << std::endl; \
std::cout << "    dwifilename: " << dwifilename << std::endl; \
std::cout << "    wmpfilename: " << wmpfilename << std::endl; \
std::cout << "    roifilename: " << roifilename << std::endl; \
std::cout << "    tractsfilename: " << tractsfilename << std::endl; \
std::cout << "    echoSwitch: " << echoSwitch << std::endl; \
std::cout << "    xmlSwitch: " << xmlSwitch << std::endl; \
std::cout << "    processInformationAddressString: " << processInformationAddressString << std::endl; \
}
#define GENERATE_ProcessInformationAddressDecoding \
ModuleProcessInformation *CLPProcessInformation = 0; \
if (processInformationAddressString != "") \
{ \
sscanf(processInformationAddressString.c_str(), "%p", &CLPProcessInformation); \
}
#define PARSE_ARGS GENERATE_LOGO;GENERATE_XML;GENERATE_TCLAP;GENERATE_ECHOARGS;GENERATE_ProcessInformationAddressDecoding;
