/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class GeneralFileSystem
implements Cloneable {
    public static String PATH_SEPARATOR = GeneralFile.pathSeparator;
    protected static String[] roots;
    public static final int DEFAULT_RECORDS_WANTED = 300;
    protected static int DEBUG;
    protected GeneralAccount account;

    protected void finalize() throws Throwable {
        this.account = null;
    }

    protected abstract void setAccount(GeneralAccount var1) throws FileNotFoundException, IOException;

    public GeneralAccount getAccount() throws NullPointerException {
        if (this.account != null) {
            return (GeneralAccount)this.account.clone();
        }
        throw new NullPointerException();
    }

    public String getHomeDirectory() {
        return this.account.getHomeDirectory();
    }

    public abstract String[] getRootDirectories();

    public MetaDataRecordList[] query(String string) throws IOException {
        return this.query(new MetaDataSelect[]{MetaDataSet.newSelection(string)}, 300);
    }

    public MetaDataRecordList[] query(String[] stringArray) throws IOException {
        return this.query(MetaDataSet.newSelection(stringArray), 300);
    }

    public MetaDataRecordList[] query(MetaDataSelect metaDataSelect) throws IOException {
        return this.query(new MetaDataSelect[]{metaDataSelect}, 300);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray) throws IOException {
        return this.query(metaDataSelectArray, 300);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        return this.query(null, metaDataSelectArray, n);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        return this.query(metaDataConditionArray, metaDataSelectArray, 300);
    }

    public abstract MetaDataRecordList[] query(MetaDataCondition[] var1, MetaDataSelect[] var2, int var3) throws IOException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract boolean equals(Object var1);

    public String toString() {
        return new String("GeneralFileSystem, " + this.getHomeDirectory());
    }

    static {
        DEBUG = 0;
        try {
            DEBUG = new Integer(System.getProperty("jargon.debug", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            DEBUG = 0;
        }
    }
}

