/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.Protocol;

public final class MetaDataField
implements Comparable {
    public static final int INT = 0;
    public static final int LONG = 1;
    public static final int FLOAT = 2;
    public static final int STRING = 3;
    public static final int DATE = 4;
    public static final int TABLE = 14;
    private String fieldName;
    private String description;
    private int type;
    private String[] extensible;
    private Protocol[] protocols = new Protocol[1];

    public MetaDataField(String string, String string2, int n, Protocol protocol) {
        this.fieldName = string;
        this.description = string2;
        this.type = n;
        this.addProtocol(protocol);
    }

    public MetaDataField(String string, String string2, int n, Protocol protocol, String string3) {
        this.fieldName = string;
        this.description = string2;
        this.type = n;
        if (string3 != null) {
            this.addProtocol(protocol, string3);
        } else {
            this.addProtocol(protocol);
        }
    }

    public String getName() {
        return this.fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    Protocol[] getProtocols() {
        return this.protocols;
    }

    Protocol getProtocol(int n) {
        return this.protocols[n];
    }

    public String getExtensibleName(Protocol protocol) {
        if (protocol != null && this.extensible != null) {
            for (int i = 0; i < this.protocols.length; ++i) {
                if (!protocol.equals(this.protocols[i])) continue;
                return this.extensible[i];
            }
        }
        return null;
    }

    public boolean isExtensible(Protocol protocol) {
        if (this.extensible == null) {
            return false;
        }
        for (int i = 0; i < this.protocols.length; ++i) {
            if (!this.protocols[i].equals(protocol) || this.extensible[i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean usesProtocol(Protocol protocol) {
        for (int i = 0; i < this.protocols.length; ++i) {
            if (!this.protocols[i].equals(protocol)) continue;
            return true;
        }
        return false;
    }

    public void addProtocol(Protocol protocol) {
        if (this.protocols[0] == null) {
            this.protocols[0] = protocol;
            return;
        }
        for (int i = 0; i < this.protocols.length; ++i) {
            if (!this.protocols[i].equals(protocol)) continue;
            return;
        }
        Protocol[] protocolArray = this.protocols;
        this.protocols = new Protocol[protocolArray.length + 1];
        System.arraycopy(protocolArray, 0, this.protocols, 0, protocolArray.length);
        this.protocols[protocolArray.length] = protocol;
    }

    public void addProtocol(Protocol protocol, String string) {
        this.addProtocol(protocol);
        if (this.extensible == null) {
            this.extensible = new String[1];
            this.extensible[0] = string;
        } else {
            for (int i = 0; i < this.protocols.length; ++i) {
                if (!this.protocols[i].equals(protocol)) continue;
                this.extensible[i] = string;
                return;
            }
        }
    }

    public boolean equals(Object object) {
        MetaDataField metaDataField = null;
        if (object == null) {
            return false;
        }
        try {
            metaDataField = (MetaDataField)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        Protocol[] protocolArray = metaDataField.getProtocols();
        String string = null;
        String string2 = null;
        if (this.fieldName == metaDataField.getName() && this.description == metaDataField.getDescription() && this.type == metaDataField.getType()) {
            if (this.extensible != null) {
                for (int i = 0; i < protocolArray.length; ++i) {
                    string = this.getExtensibleName(protocolArray[i]);
                    string2 = metaDataField.getExtensibleName(protocolArray[i]);
                    if (!(string != null ? !string.equals(string2) : string2 != null && string == null)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.fieldName + ": " + this.description;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }
}

