/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonIdentification;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.StringAttributeAffectedBySpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class ClinicalTrialsAttributes {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ClinicalTrialsAttributes.java,v 1.27 2008/05/23 16:51:00 dclunie Exp $";
    protected static final String defaultValueForMissingNonZeroLengthStrings = "NONE";
    protected static final String defaultValueForMissingPossiblyZeroLengthStrings = "";
    protected static Map mapOfOriginalToReplacementUIDs = null;
    protected static UIDGenerator uidGenerator = null;

    private ClinicalTrialsAttributes() {
    }

    protected static void addType1LongStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string == null || string.length() == 0) {
            string = defaultValueForMissingNonZeroLengthStrings;
        }
        LongStringAttribute longStringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        ((Attribute)longStringAttribute).addValue(string);
        attributeList.put(attributeTag, longStringAttribute);
    }

    protected static void addType2LongStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string == null) {
            string = defaultValueForMissingPossiblyZeroLengthStrings;
        }
        LongStringAttribute longStringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        ((Attribute)longStringAttribute).addValue(string);
        attributeList.put(attributeTag, longStringAttribute);
    }

    protected static void addType3ShortTextAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string != null) {
            ShortTextAttribute shortTextAttribute = new ShortTextAttribute(attributeTag, specificCharacterSet);
            ((Attribute)shortTextAttribute).addValue(string);
            attributeList.put(attributeTag, shortTextAttribute);
        }
    }

    protected static void addType3ShortStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string != null) {
            ShortStringAttribute shortStringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
            ((Attribute)shortStringAttribute).addValue(string);
            attributeList.put(attributeTag, shortStringAttribute);
        }
    }

    protected static void addType3LongStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string != null) {
            LongStringAttribute longStringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
            ((Attribute)longStringAttribute).addValue(string);
            attributeList.put(attributeTag, longStringAttribute);
        }
    }

    protected static void addType3DateTimeAttribute(AttributeList attributeList, AttributeTag attributeTag, String string) throws DicomException {
        if (string != null) {
            DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(attributeTag);
            ((Attribute)dateTimeAttribute).addValue(string);
            attributeList.put(attributeTag, dateTimeAttribute);
        }
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws DicomException {
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), string, string2, string3, string4, string5, string6, string7, string8, "Deidentified", DateTimeAttribute.getFormattedString(new Date()));
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, boolean bl, CodedSequenceItem codedSequenceItem, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws DicomException {
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), string, string2, string3, string4, string5, string6, string7, string8, string9, string10, null, null);
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, boolean bl, CodedSequenceItem codedSequenceItem, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String[] stringArray, PersonIdentification[] personIdentificationArray) throws DicomException {
        int n;
        Attribute attribute;
        Attribute attribute2 = attributeList.get(TagFromName.SpecificCharacterSet);
        SpecificCharacterSet specificCharacterSet = attribute2 == null ? null : new SpecificCharacterSet(attribute2.getStringValues());
        AttributeList attributeList2 = new AttributeList();
        if (codedSequenceItem != null) {
            attribute = new SequenceAttribute(TagFromName.PurposeOfReferenceCodeSequence);
            ((SequenceAttribute)attribute).addItem(codedSequenceItem.getAttributeList());
            attributeList2.put(attribute);
        }
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.Manufacturer, string, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.InstitutionName, string2, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.InstitutionalDepartmentName, string3, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortTextAttribute(attributeList2, TagFromName.InstitutionAddress, string4, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortStringAttribute(attributeList2, TagFromName.StationName, string5, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.ManufacturerModelName, string6, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.DeviceSerialNumber, string7, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, TagFromName.SoftwareVersion, string8, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortTextAttribute(attributeList2, TagFromName.ContributionDescription, string9, specificCharacterSet);
        ClinicalTrialsAttributes.addType3DateTimeAttribute(attributeList2, TagFromName.ContributionDateTime, string10);
        if (stringArray != null && stringArray.length > 0) {
            attribute = new PersonNameAttribute(TagFromName.OperatorName);
            for (n = 0; n < stringArray.length; ++n) {
                attribute.addValue(stringArray[n]);
            }
            attributeList2.put(attribute);
        }
        if (personIdentificationArray != null && personIdentificationArray.length > 0) {
            attribute = new SequenceAttribute(TagFromName.OperatorIdentificationSequence);
            for (n = 0; n < personIdentificationArray.length; ++n) {
                PersonIdentification personIdentification = personIdentificationArray[n];
                if (personIdentification == null) continue;
                ((SequenceAttribute)attribute).addItem(new SequenceItem(personIdentification.getAttributeList()));
            }
            attributeList2.put(attribute);
        }
        attribute = null;
        if (bl) {
            attribute = (SequenceAttribute)attributeList.get(TagFromName.ContributingEquipmentSequence);
        }
        if (attribute == null) {
            attribute = new SequenceAttribute(TagFromName.ContributingEquipmentSequence);
        }
        ((SequenceAttribute)attribute).addItem(attributeList2);
        attributeList.remove(TagFromName.ContributingEquipmentSequence);
        attributeList.put(attribute);
    }

    public static void addClinicalTrialsAttributes(AttributeList attributeList, boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws DicomException {
        Attribute attribute = attributeList.get(TagFromName.SpecificCharacterSet);
        SpecificCharacterSet specificCharacterSet = attribute == null ? null : new SpecificCharacterSet(attribute.getStringValues());
        ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, TagFromName.ClinicalTrialSponsorName, string, specificCharacterSet);
        ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, TagFromName.ClinicalTrialProtocolID, string2, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, TagFromName.ClinicalTrialProtocolName, string3, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, TagFromName.ClinicalTrialSiteID, string4, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, TagFromName.ClinicalTrialSiteName, string5, specificCharacterSet);
        if (string6 != null || string7 == null) {
            ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, TagFromName.ClinicalTrialSubjectID, string6, specificCharacterSet);
        }
        if (string7 != null) {
            ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, TagFromName.ClinicalTrialSubjectReadingID, string7, specificCharacterSet);
        }
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, TagFromName.ClinicalTrialTimePointID, string8, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortTextAttribute(attributeList, TagFromName.ClinicalTrialTimePointDescription, string9, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, TagFromName.ClinicalTrialCoordinatingCenterName, string10, specificCharacterSet);
        if (bl) {
            String string11 = string6;
            if (string11 == null) {
                string11 = defaultValueForMissingNonZeroLengthStrings;
            }
            StringAttributeAffectedBySpecificCharacterSet stringAttributeAffectedBySpecificCharacterSet = new PersonNameAttribute(TagFromName.PatientName, specificCharacterSet);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string11);
            attributeList.put(TagFromName.PatientName, stringAttributeAffectedBySpecificCharacterSet);
            stringAttributeAffectedBySpecificCharacterSet = new LongStringAttribute(TagFromName.PatientID, specificCharacterSet);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string11);
            attributeList.put(TagFromName.PatientID, stringAttributeAffectedBySpecificCharacterSet);
            string11 = string8;
            if (string11 == null) {
                string11 = defaultValueForMissingNonZeroLengthStrings;
            }
            stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.StudyID, specificCharacterSet);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string11);
            attributeList.put(TagFromName.StudyID, stringAttributeAffectedBySpecificCharacterSet);
        }
    }

    public static void flushMapOfUIDs() {
        mapOfOriginalToReplacementUIDs = null;
    }

    public static void remapUIDAttributes(AttributeList attributeList) throws DicomException {
        ClinicalTrialsAttributes.removeOrRemapUIDAttributes(attributeList, 2);
    }

    public static void removeUIDAttributes(AttributeList attributeList) throws DicomException {
        ClinicalTrialsAttributes.removeOrRemapUIDAttributes(attributeList, 1);
    }

    protected static void removeOrRemapUIDAttributes(AttributeList attributeList, int n) throws DicomException {
        Object object;
        Object object2;
        Object object3;
        LinkedList<Object> linkedList = null;
        for (Object object4 : attributeList.values()) {
            Object object5;
            if (object4 instanceof SequenceAttribute) {
                object5 = (SequenceAttribute)object4;
                object3 = ((SequenceAttribute)object5).iterator();
                if (object3 == null) continue;
                while (object3.hasNext()) {
                    object2 = (SequenceItem)object3.next();
                    if (object2 == null || (object = ((SequenceItem)object2).getAttributeList()) == null) continue;
                    ClinicalTrialsAttributes.removeOrRemapUIDAttributes((AttributeList)object, n);
                }
                continue;
            }
            if (n == 0 || !(object4 instanceof UniqueIdentifierAttribute) || !UniqueIdentifierAttribute.isTransient((AttributeTag)(object3 = ((Attribute)(object5 = (UniqueIdentifierAttribute)object4)).getTag()))) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<Object>();
            }
            linkedList.add(object3);
        }
        if (linkedList != null) {
            for (Object object5 : linkedList) {
                if (n == 1) {
                    attributeList.remove((AttributeTag)object5);
                    continue;
                }
                if (n != 2) continue;
                object3 = Attribute.getSingleStringValueOrNull(attributeList, (AttributeTag)object5);
                if (object3 != null) {
                    object2 = null;
                    if (mapOfOriginalToReplacementUIDs == null) {
                        mapOfOriginalToReplacementUIDs = new HashMap();
                    }
                    if ((object2 = (String)mapOfOriginalToReplacementUIDs.get(object3)) == null) {
                        if (uidGenerator == null) {
                            uidGenerator = new UIDGenerator();
                        }
                        object2 = uidGenerator.getAnotherNewUID();
                        mapOfOriginalToReplacementUIDs.put(object3, object2);
                    }
                    assert (object2 != null);
                    attributeList.remove((AttributeTag)object5);
                    object = new UniqueIdentifierAttribute((AttributeTag)object5);
                    ((Attribute)object).addValue((String)object2);
                    attributeList.put((AttributeTag)object5, (Attribute)object);
                    continue;
                }
                attributeList.remove((AttributeTag)object5);
            }
        }
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, boolean bl, boolean bl2) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, bl ? 0 : 1, bl2);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, int n, boolean bl) throws DicomException {
        if (!bl) {
            attributeList.remove(TagFromName.StudyDescription);
            attributeList.remove(TagFromName.SeriesDescription);
        }
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.AccessionNumber);
        attributeList.remove(TagFromName.InstitutionName);
        attributeList.remove(TagFromName.InstitutionAddress);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.ReferringPhysicianName);
        attributeList.remove(TagFromName.ReferringPhysicianAddress);
        attributeList.remove(TagFromName.ReferringPhysicianTelephoneNumber);
        attributeList.remove(TagFromName.StationName);
        attributeList.remove(TagFromName.InstitutionalDepartmentName);
        attributeList.remove(TagFromName.PhysicianOfRecord);
        attributeList.remove(TagFromName.PerformingPhysicianName);
        attributeList.remove(TagFromName.PhysicianReadingStudy);
        attributeList.remove(TagFromName.RequestingPhysician);
        attributeList.remove(TagFromName.OperatorName);
        attributeList.remove(TagFromName.AdmittingDiagnosesDescription);
        attributeList.remove(TagFromName.DerivationDescription);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.PatientName);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.PatientID);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.PatientBirthDate);
        attributeList.remove(TagFromName.PatientBirthTime);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.PatientSex);
        attributeList.remove(TagFromName.OtherPatientID);
        attributeList.remove(TagFromName.OtherPatientName);
        attributeList.remove(TagFromName.PatientAge);
        attributeList.remove(TagFromName.PatientSize);
        attributeList.remove(TagFromName.PatientWeight);
        attributeList.remove(TagFromName.MedicalRecordLocator);
        attributeList.remove(TagFromName.EthnicGroup);
        attributeList.remove(TagFromName.Occupation);
        attributeList.remove(TagFromName.AdditionalPatientHistory);
        attributeList.remove(TagFromName.PatientComments);
        attributeList.remove(TagFromName.DeviceSerialNumber);
        attributeList.remove(TagFromName.PlateID);
        attributeList.remove(TagFromName.GantryID);
        attributeList.remove(TagFromName.CassetteID);
        attributeList.remove(TagFromName.GeneratorID);
        attributeList.remove(TagFromName.DetectorID);
        attributeList.remove(TagFromName.ProtocolName);
        attributeList.replaceWithZeroLengthIfPresent(TagFromName.StudyID);
        attributeList.remove(TagFromName.RequestAttributesSequence);
        attributeList.remove(TagFromName.StudyStatusID);
        attributeList.remove(TagFromName.StudyPriorityID);
        attributeList.remove(TagFromName.CurrentPatientLocation);
        attributeList.remove(TagFromName.PatientAddress);
        attributeList.remove(TagFromName.MilitaryRank);
        attributeList.remove(TagFromName.BranchOfService);
        attributeList.remove(TagFromName.IssuerOfPatientID);
        attributeList.remove(TagFromName.PatientBirthName);
        attributeList.remove(TagFromName.PatientMotherBirthName);
        attributeList.remove(TagFromName.ConfidentialityConstraintOnPatientDataDescription);
        attributeList.remove(TagFromName.PatientInsurancePlanCodeSequence);
        attributeList.remove(TagFromName.PatientPrimaryLanguageCodeSequence);
        attributeList.remove(TagFromName.PatientAddress);
        attributeList.remove(TagFromName.MilitaryRank);
        attributeList.remove(TagFromName.BranchOfService);
        attributeList.remove(TagFromName.CountryOfResidence);
        attributeList.remove(TagFromName.RegionOfResidence);
        attributeList.remove(TagFromName.PatientTelephoneNumber);
        attributeList.remove(TagFromName.PatientReligiousPreference);
        attributeList.remove(TagFromName.MedicalAlerts);
        attributeList.remove(TagFromName.Allergies);
        attributeList.remove(TagFromName.SmokingStatus);
        attributeList.remove(TagFromName.PregnancyStatus);
        attributeList.remove(TagFromName.LastMenstrualDate);
        attributeList.remove(TagFromName.SpecialNeeds);
        attributeList.remove(TagFromName.PatientState);
        if (!bl) {
            attributeList.remove(TagFromName.ImageComments);
        }
        attributeList.remove(TagFromName.ReferencedPatientSequence);
        attributeList.remove(TagFromName.ReferringPhysicianIdentificationSequence);
        attributeList.remove(TagFromName.PhysicianOfRecordIdentificationSequence);
        attributeList.remove(TagFromName.PhysicianReadingStudyIdentificationSequence);
        attributeList.remove(TagFromName.ReferencedStudySequence);
        attributeList.remove(TagFromName.AdmittingDiagnosesCodeSequence);
        attributeList.remove(TagFromName.PerformingPhysicianIdentificationSequence);
        attributeList.remove(TagFromName.OperatorIdentificationSequence);
        attributeList.remove(TagFromName.ReferencedPerformedProcedureStepSequence);
        attributeList.remove(TagFromName.PerformedProcedureStepID);
        attributeList.remove(TagFromName.DataSetTrailingPadding);
        if (n == 1) {
            attributeList.remove(TagFromName.ReferencedImageSequence);
            attributeList.remove(TagFromName.SourceImageSequence);
        }
        if (!bl) {
            attributeList.remove(TagFromName.PerformedProcedureStepDescription);
            attributeList.remove(TagFromName.CommentsOnPerformedProcedureStep);
            attributeList.remove(TagFromName.AcquisitionComments);
            attributeList.remove(TagFromName.ReasonForStudy);
            attributeList.remove(TagFromName.RequestedProcedureDescription);
            attributeList.remove(TagFromName.StudyComments);
        }
        if (n != 0) {
            ClinicalTrialsAttributes.removeOrRemapUIDAttributes(attributeList, n);
        }
        AttributeTag attributeTag = TagFromName.PatientIdentityRemoved;
        attributeList.remove(attributeTag);
        StringAttribute stringAttribute = new CodeStringAttribute(attributeTag);
        ((Attribute)stringAttribute).addValue("YES");
        attributeList.put(attributeTag, stringAttribute);
        attributeTag = TagFromName.DeidentificationMethod;
        attributeList.remove(attributeTag);
        stringAttribute = new LongStringAttribute(attributeTag);
        ((Attribute)stringAttribute).addValue("Known undesirable attributes cleaned");
        attributeList.put(attributeTag, stringAttribute);
    }

    public static void main(String[] stringArray) {
        System.err.println("do it buffered, looking for metaheader, no uid specified");
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(stringArray[0], null, true, true);
            System.err.println("As read ...");
            System.err.print(attributeList.toString());
            attributeList.removePrivateAttributes();
            System.err.println("After remove private ...");
            System.err.print(attributeList.toString());
            attributeList.removeGroupLengthAttributes();
            System.err.println("After remove group lengths ...");
            System.err.print(attributeList.toString());
            attributeList.removeMetaInformationHeaderAttributes();
            System.err.println("After remove meta information header ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, true, true);
            System.err.println("After deidentify, keeping descriptions and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, true, false);
            System.err.println("After deidentify, keeping only UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 2, false);
            System.err.println("After deidentify, remapping UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, false, false);
            System.err.println("After deidentify, removing everything ...");
            System.err.print(attributeList.toString());
            String[] stringArray2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID);
            CodedSequenceItem[] codedSequenceItemArray = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber);
            CodedSequenceItem[] codedSequenceItemArray2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber);
            String[] stringArray3 = new UIDGenerator();
            PersonIdentification[] personIdentificationArray = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
            personIdentificationArray.addValue(stringArray3.getNewSOPInstanceUID((String)stringArray2, (String)codedSequenceItemArray, (String)codedSequenceItemArray2));
            attributeList.put((Attribute)personIdentificationArray);
            personIdentificationArray = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            personIdentificationArray.addValue(stringArray3.getNewSeriesInstanceUID((String)stringArray2, (String)codedSequenceItemArray));
            attributeList.put((Attribute)personIdentificationArray);
            personIdentificationArray = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            personIdentificationArray.addValue(stringArray3.getNewStudyInstanceUID((String)stringArray2));
            attributeList.put((Attribute)personIdentificationArray);
            ClinicalTrialsAttributes.addClinicalTrialsAttributes(attributeList, true, "ourSponsorName", "ourProtocolID", "ourProtocolName", "ourSiteID", "ourSiteName", "ourSubjectID", "ourSubjectReadingID", "ourTimePointID", "ourTimePointDescription", "ourCoordinatingCenterName");
            System.err.println("After addClinicalTrialsAttributes ...");
            System.err.print(attributeList.toString());
            stringArray2 = new String[]{"smithj", "doej"};
            codedSequenceItemArray = new CodedSequenceItem[]{new CodedSequenceItem("634872364", "99MYH", "Smith^John")};
            codedSequenceItemArray2 = new CodedSequenceItem[]{new CodedSequenceItem("346234622", "99MYH", "Doe^Jane")};
            stringArray3 = new String[]{"555-1212"};
            personIdentificationArray = new PersonIdentification[]{new PersonIdentification(codedSequenceItemArray, "John address", stringArray3, null, "My hospital address", new CodedSequenceItem("47327864", "99MYH", "My Hospital")), new PersonIdentification(codedSequenceItemArray2, "Jane address", stringArray3, "My hospital", "My hospital address", null)};
            ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.dicom.ClinicalTrialsAttributes.main()", null, "Vers. 20080410", "Deidentified", DateTimeAttribute.getFormattedString(new Date()), stringArray2, personIdentificationArray);
            System.err.println("After addContributingEquipmentSequence ...");
            System.err.print(attributeList.toString());
            FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
            attributeList.write(stringArray[1], "1.2.840.10008.1.2.1", true, true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public class HandleUIDs {
        public static final int keep = 0;
        public static final int remove = 1;
        public static final int remap = 2;
    }
}

