/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import javax.jws.soap.SOAPBinding;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaAnnotation;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaType;

public class WebParamAnnotator
implements Annotator {
    public void annotate(JavaAnnotatable ja) {
        JavaParameter paramInList;
        JavaParameter parameter = null;
        if (!(ja instanceof JavaParameter)) {
            throw new RuntimeException("WebParamAnnotator only annotate the JavaParameter");
        }
        parameter = (JavaParameter)ja;
        JavaMethod method = parameter.getMethod();
        if (method.hasParameter(parameter.getName()) && (paramInList = method.getParameter(parameter.getName())).isIN() && parameter.isOUT()) {
            parameter.setStyle(JavaType.Style.INOUT);
        }
        JavaAnnotation webParamAnnotation = new JavaAnnotation("WebParam");
        String name = parameter.getName();
        String targetNamespace = method.getInterface().getNamespace();
        String partName = null;
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT || parameter.isHeader()) {
            targetNamespace = parameter.getTargetNamespace();
            if (parameter.getQName() != null) {
                name = parameter.getQName().getLocalPart();
            }
            if (!method.isWrapperStyle()) {
                partName = parameter.getPartName();
            }
        }
        if (method.getSoapStyle() == SOAPBinding.Style.RPC) {
            name = parameter.getPartName();
            partName = parameter.getPartName();
        }
        if (partName != null) {
            webParamAnnotation.addArgument("partName", partName);
        }
        if (parameter.getStyle() == JavaType.Style.OUT || parameter.getStyle() == JavaType.Style.INOUT) {
            webParamAnnotation.addArgument("mode", "Mode." + parameter.getStyle().toString(), "");
        }
        webParamAnnotation.addArgument("name", name);
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT || parameter.isHeader()) {
            webParamAnnotation.addArgIgnoreEmpty("targetNamespace", targetNamespace, "\"");
        }
        parameter.setAnnotation(webParamAnnotation);
    }
}

