/*
 * Decompiled with CFR 0.152.
 */
package imagelib.io;

import imagelib.io.ImageSeries;
import imagelib.io.ImageSeriesInfo;
import imagelib.io.ImageSeriesReader;
import imagelib.util.SuffixFilenameFilter;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class RawImageSeriesReader
extends ImageSeriesReader {
    @Override
    public boolean canRead(ImageSeriesInfo isInfo) {
        if (isInfo.getIsMultipleFiles()) {
            File location = new File(isInfo.getLocation());
            if (!location.isDirectory()) {
                return false;
            }
            String[] files = location.list(new SuffixFilenameFilter(".raw"));
            if (files != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ImageSeries load(ImageSeriesInfo isInfo) throws IOException {
        if (isInfo.getIsMultipleFiles()) {
            File location = new File(isInfo.getLocation());
            File[] slices = location.listFiles(new SuffixFilenameFilter(".raw"));
            int byteSize = (int)slices[0].length();
            int rows = (int)Math.sqrt(byteSize / 2);
            int[] seriesData = new int[slices.length * byteSize];
            FilterInputStream in = null;
            int offset = 0;
            int max = Integer.MIN_VALUE;
            int min = Integer.MAX_VALUE;
            int i = 0;
            while (i < slices.length) {
                try {
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream(slices[i]), 4096));
                    int noVoxels = rows * rows;
                    int j = 0;
                    while (j < noVoxels) {
                        seriesData[offset + j] = ((DataInputStream)in).readUnsignedShort();
                        if (seriesData[offset + j] > max) {
                            max = seriesData[offset + j];
                        }
                        if (seriesData[offset + j] < min) {
                            min = seriesData[offset + j];
                        }
                        ++j;
                    }
                    offset += noVoxels;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                ++i;
            }
            System.out.println("min=" + min + ", max=" + max);
            ImageSeries is = new ImageSeries("", seriesData, slices.length, rows, rows);
            return is;
        }
        return null;
    }
}

