/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Assessmentdata;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.sql.CLOB;

public class AssessmentdataDAO
implements clinical.server.dao.AssessmentdataDAO {
    @Override
    public void insert(Connection con, Assessmentdata bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_ASSESSMENTDATA ");
            buf.append(" (TABLEID,UNIQUEID,SCOREORDER,OWNER,MODTIME,MODUSER,ASSESSMENTID,SCORENAME,SCORETYPE,TEXTVALUE,TEXTNORMVALUE,ENCRYPTED,COMMENTS,NC_STOREDASSESSMENT_UNIQUEID,ISVALIDATED,ISRANKED,SUBJECTID,ENTRYID,KEYERID,RATERID,CLASSIFICATION) ");
            buf.append("VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 21) {
                buf.append('?');
                if (i < 20) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getTableid(), 2);
            ps.setObject(2, bean.getUniqueid(), 2);
            ps.setObject(3, bean.getScoreorder(), 2);
            ps.setObject(4, bean.getOwner(), 2);
            ps.setTimestamp(5, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(6, bean.getModuser(), 2);
            ps.setObject(7, bean.getAssessmentid(), 2);
            ps.setObject(8, bean.getScorename(), 12);
            ps.setObject(9, bean.getScoretype(), 12);
            ps.setObject(10, bean.getTextvalue(), 12);
            ps.setObject(11, bean.getTextnormvalue(), 12);
            ps.setObject(12, this.boolean2Number(bean.getEncrypted()), 2);
            ps.setObject(13, OracleUtils.getCLOB(con, bean.getComments()), 2005);
            ps.setObject(14, bean.getNcStoredassessmentUniqueid(), 2);
            ps.setObject(15, this.boolean2Number(bean.getIsvalidated()), 2);
            ps.setObject(16, this.boolean2Number(bean.getIsranked()), 2);
            ps.setObject(17, bean.getSubjectid(), 12);
            ps.setObject(18, bean.getEntryid(), 2);
            ps.setObject(19, bean.getKeyerid(), 2);
            ps.setObject(20, bean.getRaterid(), 2);
            ps.setObject(21, bean.getClassification(), 2);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String prepareColList(Assessmentdata bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("TABLEID");
        buf.append(',');
        buf.append("UNIQUEID");
        buf.append(',');
        buf.append("SCOREORDER");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MODTIME");
        buf.append(',');
        buf.append("MODUSER");
        buf.append(',');
        buf.append("ASSESSMENTID");
        buf.append(',');
        buf.append("SCORENAME");
        buf.append(',');
        buf.append("SCORETYPE");
        buf.append(',');
        buf.append("TEXTVALUE");
        buf.append(',');
        buf.append("TEXTNORMVALUE");
        buf.append(',');
        buf.append("ENCRYPTED");
        buf.append(',');
        buf.append("COMMENTS");
        buf.append(',');
        buf.append("NC_STOREDASSESSMENT_UNIQUEID");
        buf.append(',');
        buf.append("ISVALIDATED");
        buf.append(',');
        buf.append("ISRANKED");
        buf.append(',');
        buf.append("SUBJECTID");
        buf.append(',');
        buf.append("ENTRYID");
        buf.append(',');
        buf.append("KEYERID");
        buf.append(',');
        buf.append("RATERID");
        buf.append(',');
        buf.append("CLASSIFICATION");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Assessmentdata bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TABLEID=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIQUEID=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getScoreorder() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("SCOREORDER=?");
            qi.values.add(bean.getScoreorder());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODTIME=?");
            qi.values.add(new Timestamp(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODUSER=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getAssessmentid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ASSESSMENTID=?");
            qi.values.add(bean.getAssessmentid());
            valueSet = true;
        }
        if (bean.getScorename() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("SCORENAME=?");
            qi.values.add(bean.getScorename());
            valueSet = true;
        }
        if (bean.getScoretype() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("SCORETYPE=?");
            qi.values.add(bean.getScoretype());
            valueSet = true;
        }
        if (bean.getTextvalue() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TEXTVALUE=?");
            qi.values.add(bean.getTextvalue());
            valueSet = true;
        }
        if (bean.getTextnormvalue() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TEXTNORMVALUE=?");
            qi.values.add(bean.getTextnormvalue());
            valueSet = true;
        }
        if (bean.getEncrypted() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ENCRYPTED=?");
            qi.values.add(this.boolean2Number(bean.getEncrypted()));
            valueSet = true;
        }
        if (bean.getComments() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("COMMENTS=?");
            qi.values.add(bean.getComments());
            valueSet = true;
        }
        if (bean.getNcStoredassessmentUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("NC_STOREDASSESSMENT_UNIQUEID=?");
            qi.values.add(bean.getNcStoredassessmentUniqueid());
            valueSet = true;
        }
        if (bean.getIsvalidated() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ISVALIDATED=?");
            qi.values.add(this.boolean2Number(bean.getIsvalidated()));
            valueSet = true;
        }
        if (bean.getIsranked() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ISRANKED=?");
            qi.values.add(this.boolean2Number(bean.getIsranked()));
            valueSet = true;
        }
        if (bean.getSubjectid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("SUBJECTID=?");
            qi.values.add(bean.getSubjectid());
            valueSet = true;
        }
        if (bean.getEntryid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ENTRYID=?");
            qi.values.add(bean.getEntryid());
            valueSet = true;
        }
        if (bean.getKeyerid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("KEYERID=?");
            qi.values.add(bean.getKeyerid());
            valueSet = true;
        }
        if (bean.getRaterid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("RATERID=?");
            qi.values.add(bean.getRaterid());
            valueSet = true;
        }
        if (bean.getClassification() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("CLASSIFICATION=?");
            qi.values.add(bean.getClassification());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Assessmentdata bean, Assessmentdata criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_ASSESSMENTDATA SET ");
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TABLEID=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIQUEID=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getScoreorder() != null || bean.isNull("scoreorder")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("SCOREORDER=? ");
            uqi.setValues.add(bean.getScoreorder());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("scoreorder"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODTIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODUSER=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getAssessmentid() != null || bean.isNull("assessmentid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ASSESSMENTID=? ");
            uqi.setValues.add(bean.getAssessmentid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("assessmentid"), uqi);
            valueSet = true;
        }
        if (bean.getScorename() != null || bean.isNull("scorename")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("SCORENAME=? ");
            uqi.setValues.add(bean.getScorename());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("scorename"), uqi);
            valueSet = true;
        }
        if (bean.getScoretype() != null || bean.isNull("scoretype")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("SCORETYPE=? ");
            uqi.setValues.add(bean.getScoretype());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("scoretype"), uqi);
            valueSet = true;
        }
        if (bean.getTextvalue() != null || bean.isNull("textvalue")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TEXTVALUE=? ");
            uqi.setValues.add(bean.getTextvalue());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("textvalue"), uqi);
            valueSet = true;
        }
        if (bean.getTextnormvalue() != null || bean.isNull("textnormvalue")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TEXTNORMVALUE=? ");
            uqi.setValues.add(bean.getTextnormvalue());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("textnormvalue"), uqi);
            valueSet = true;
        }
        if (bean.getEncrypted() != null || bean.isNull("encrypted")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ENCRYPTED=? ");
            uqi.setValues.add(this.boolean2Number(bean.getEncrypted()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("encrypted"), uqi);
            valueSet = true;
        }
        if (bean.getComments() != null || bean.isNull("comments")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("COMMENTS=? ");
            uqi.setValues.add(bean.getComments());
            uqi.sqlTypes.add(new Integer(2005));
            this.prepareNullSetListValue(bean.isNull("comments"), uqi);
            valueSet = true;
        }
        if (bean.getNcStoredassessmentUniqueid() != null || bean.isNull("ncStoredassessmentUniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("NC_STOREDASSESSMENT_UNIQUEID=? ");
            uqi.setValues.add(bean.getNcStoredassessmentUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("ncStoredassessmentUniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getIsvalidated() != null || bean.isNull("isvalidated")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ISVALIDATED=? ");
            uqi.setValues.add(this.boolean2Number(bean.getIsvalidated()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("isvalidated"), uqi);
            valueSet = true;
        }
        if (bean.getIsranked() != null || bean.isNull("isranked")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ISRANKED=? ");
            uqi.setValues.add(this.boolean2Number(bean.getIsranked()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("isranked"), uqi);
            valueSet = true;
        }
        if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("SUBJECTID=? ");
            uqi.setValues.add(bean.getSubjectid());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("subjectid"), uqi);
            valueSet = true;
        }
        if (bean.getEntryid() != null || bean.isNull("entryid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ENTRYID=? ");
            uqi.setValues.add(bean.getEntryid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("entryid"), uqi);
            valueSet = true;
        }
        if (bean.getKeyerid() != null || bean.isNull("keyerid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("KEYERID=? ");
            uqi.setValues.add(bean.getKeyerid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("keyerid"), uqi);
            valueSet = true;
        }
        if (bean.getRaterid() != null || bean.isNull("raterid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("RATERID=? ");
            uqi.setValues.add(bean.getRaterid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("raterid"), uqi);
            valueSet = true;
        }
        if (bean.getClassification() != null || bean.isNull("classification")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("CLASSIFICATION=? ");
            uqi.setValues.add(bean.getClassification());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("classification"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    protected Boolean convert2Boolean(Object columnValue) {
        if (columnValue == null) {
            return null;
        }
        return ((BigDecimal)columnValue).intValue() > 0 ? new Boolean(true) : new Boolean(false);
    }

    protected BigDecimal boolean2Number(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? new BigDecimal("1") : new BigDecimal("0");
    }

    protected String boolean2YN(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "Y" : "N";
    }

    public Assessmentdata createObject(ResultSet rs) throws SQLException {
        Assessmentdata obj = new Assessmentdata();
        obj.setTableid((BigDecimal)rs.getObject(1));
        obj.setUniqueid((BigDecimal)rs.getObject(2));
        obj.setScoreorder((BigDecimal)rs.getObject(3));
        obj.setOwner((BigDecimal)rs.getObject(4));
        if (rs.getTimestamp(5) != null) {
            obj.setModtime(new Date(rs.getTimestamp(5).getTime()));
        }
        obj.setModuser((BigDecimal)rs.getObject(6));
        obj.setAssessmentid((BigDecimal)rs.getObject(7));
        obj.setScorename((String)rs.getObject(8));
        obj.setScoretype((String)rs.getObject(9));
        obj.setTextvalue((String)rs.getObject(10));
        obj.setTextnormvalue((String)rs.getObject(11));
        obj.setEncrypted(this.convert2Boolean(rs.getObject(12)));
        obj.setComments(OracleUtils.readCLOB((CLOB)rs.getObject(13)));
        obj.setNcStoredassessmentUniqueid((BigDecimal)rs.getObject(14));
        obj.setIsvalidated(this.convert2Boolean(rs.getObject(15)));
        obj.setIsranked(this.convert2Boolean(rs.getObject(16)));
        obj.setSubjectid((String)rs.getObject(17));
        obj.setEntryid((BigDecimal)rs.getObject(18));
        obj.setKeyerid((BigDecimal)rs.getObject(19));
        obj.setRaterid((BigDecimal)rs.getObject(20));
        obj.setClassification((BigDecimal)rs.getObject(21));
        return obj;
    }

    @Override
    public List<Assessmentdata> find(Connection con, Assessmentdata criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Assessmentdata> results = new LinkedList<Assessmentdata>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_ASSESSMENTDATA ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Assessmentdata item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, Assessmentdata bean, Assessmentdata criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, Assessmentdata criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_ASSESSMENTDATA ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public List<Assessmentdata> find(Connection con, List<BigDecimal> storedAssessmentIDs) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Assessmentdata> results = new LinkedList<Assessmentdata>();
        StringBuffer buf = new StringBuffer(200);
        buf.append("SELECT ");
        buf.append(this.prepareColList(null));
        buf.append(" FROM NC_ASSESSMENTDATA ");
        if (!storedAssessmentIDs.isEmpty()) {
            buf.append(" WHERE NC_STOREDASSESSMENT_UNIQUEID IN (");
        }
        Iterator<BigDecimal> iter = storedAssessmentIDs.iterator();
        while (iter.hasNext()) {
            BigDecimal sasID = iter.next();
            buf.append(sasID);
            if (!iter.hasNext()) continue;
            buf.append(',');
        }
        if (!storedAssessmentIDs.isEmpty()) {
            buf.append(")");
        }
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            rs = ps.executeQuery();
            while (rs.next()) {
                Assessmentdata item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

