/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Expstudy;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.sql.CLOB;

public class ExpstudyDAO
implements clinical.server.dao.ExpstudyDAO {
    @Override
    public void insert(Connection con, Expstudy bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_EXPSTUDY ");
            buf.append(" (STUDYID,COMPONENTID,EXPERIMENTID,SUBJECTID,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,TIME_STAMP,DESCRIPTION,NAME,ISTIMEINTERVAL,TIMEINTERVAL) ");
            buf.append("VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 14) {
                buf.append('?');
                if (i < 13) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getStudyid(), 2);
            ps.setObject(2, bean.getComponentid(), 2);
            ps.setObject(3, bean.getExperimentid(), 2);
            ps.setObject(4, bean.getSubjectid(), 12);
            ps.setObject(5, bean.getUniqueid(), 2);
            ps.setObject(6, bean.getTableid(), 2);
            ps.setObject(7, bean.getOwner(), 2);
            ps.setTimestamp(8, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(9, bean.getModuser(), 2);
            ps.setObject(10, bean.getTimeStamp(), 93);
            ps.setObject(11, OracleUtils.getCLOB(con, bean.getDescription()), 2005);
            ps.setObject(12, bean.getName(), 12);
            ps.setObject(13, this.boolean2Number(bean.getIstimeinterval()), 2);
            ps.setObject(14, bean.getTimeinterval(), 6);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String prepareColList(Expstudy bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("STUDYID");
        buf.append(',');
        buf.append("COMPONENTID");
        buf.append(',');
        buf.append("EXPERIMENTID");
        buf.append(',');
        buf.append("SUBJECTID");
        buf.append(',');
        buf.append("UNIQUEID");
        buf.append(',');
        buf.append("TABLEID");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MODTIME");
        buf.append(',');
        buf.append("MODUSER");
        buf.append(',');
        buf.append("TIME_STAMP");
        buf.append(',');
        buf.append("DESCRIPTION");
        buf.append(',');
        buf.append("NAME");
        buf.append(',');
        buf.append("ISTIMEINTERVAL");
        buf.append(',');
        buf.append("TIMEINTERVAL");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Expstudy bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getStudyid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("STUDYID=?");
            qi.values.add(bean.getStudyid());
            valueSet = true;
        }
        if (bean.getComponentid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("COMPONENTID=?");
            qi.values.add(bean.getComponentid());
            valueSet = true;
        }
        if (bean.getExperimentid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("EXPERIMENTID=?");
            qi.values.add(bean.getExperimentid());
            valueSet = true;
        }
        if (bean.getSubjectid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("SUBJECTID=?");
            qi.values.add(bean.getSubjectid());
            valueSet = true;
        }
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIQUEID=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TABLEID=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODTIME=?");
            qi.values.add(new Timestamp(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODUSER=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getTimeStamp() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TIME_STAMP=?");
            qi.values.add(bean.getTimeStamp());
            valueSet = true;
        }
        if (bean.getDescription() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DESCRIPTION=?");
            qi.values.add(bean.getDescription());
            valueSet = true;
        }
        if (bean.getName() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("NAME=?");
            qi.values.add(bean.getName());
            valueSet = true;
        }
        if (bean.getIstimeinterval() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ISTIMEINTERVAL=?");
            qi.values.add(this.boolean2Number(bean.getIstimeinterval()));
            valueSet = true;
        }
        if (bean.getTimeinterval() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TIMEINTERVAL=?");
            qi.values.add(bean.getTimeinterval());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Expstudy bean, Expstudy criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_EXPSTUDY SET ");
        if (bean.getStudyid() != null || bean.isNull("studyid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("STUDYID=? ");
            uqi.setValues.add(bean.getStudyid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("studyid"), uqi);
            valueSet = true;
        }
        if (bean.getComponentid() != null || bean.isNull("componentid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("COMPONENTID=? ");
            uqi.setValues.add(bean.getComponentid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("componentid"), uqi);
            valueSet = true;
        }
        if (bean.getExperimentid() != null || bean.isNull("experimentid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("EXPERIMENTID=? ");
            uqi.setValues.add(bean.getExperimentid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("experimentid"), uqi);
            valueSet = true;
        }
        if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("SUBJECTID=? ");
            uqi.setValues.add(bean.getSubjectid());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("subjectid"), uqi);
            valueSet = true;
        }
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIQUEID=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TABLEID=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODTIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODUSER=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getTimeStamp() != null || bean.isNull("timeStamp")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TIME_STAMP=? ");
            uqi.setValues.add(bean.getTimeStamp());
            uqi.sqlTypes.add(new Integer(93));
            this.prepareNullSetListValue(bean.isNull("timeStamp"), uqi);
            valueSet = true;
        }
        if (bean.getDescription() != null || bean.isNull("description")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DESCRIPTION=? ");
            uqi.setValues.add(bean.getDescription());
            uqi.sqlTypes.add(new Integer(2005));
            this.prepareNullSetListValue(bean.isNull("description"), uqi);
            valueSet = true;
        }
        if (bean.getName() != null || bean.isNull("name")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("NAME=? ");
            uqi.setValues.add(bean.getName());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("name"), uqi);
            valueSet = true;
        }
        if (bean.getIstimeinterval() != null || bean.isNull("istimeinterval")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ISTIMEINTERVAL=? ");
            uqi.setValues.add(this.boolean2Number(bean.getIstimeinterval()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("istimeinterval"), uqi);
            valueSet = true;
        }
        if (bean.getTimeinterval() != null || bean.isNull("timeinterval")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TIMEINTERVAL=? ");
            uqi.setValues.add(bean.getTimeinterval());
            uqi.sqlTypes.add(new Integer(6));
            this.prepareNullSetListValue(bean.isNull("timeinterval"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    protected Boolean convert2Boolean(Object columnValue) {
        if (columnValue == null) {
            return null;
        }
        return ((BigDecimal)columnValue).intValue() > 0 ? new Boolean(true) : new Boolean(false);
    }

    protected BigDecimal boolean2Number(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? new BigDecimal("1") : new BigDecimal("0");
    }

    protected String boolean2YN(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "Y" : "N";
    }

    public Expstudy createObject(ResultSet rs) throws SQLException {
        Expstudy obj = new Expstudy();
        obj.setStudyid((BigDecimal)rs.getObject(1));
        obj.setComponentid((BigDecimal)rs.getObject(2));
        obj.setExperimentid((BigDecimal)rs.getObject(3));
        obj.setSubjectid((String)rs.getObject(4));
        obj.setUniqueid((BigDecimal)rs.getObject(5));
        obj.setTableid((BigDecimal)rs.getObject(6));
        obj.setOwner((BigDecimal)rs.getObject(7));
        if (rs.getTimestamp(8) != null) {
            obj.setModtime(new Date(rs.getTimestamp(8).getTime()));
        }
        obj.setModuser((BigDecimal)rs.getObject(9));
        obj.setTimeStamp(OracleUtils.getTimestamp(rs.getObject(10)));
        obj.setDescription(OracleUtils.readCLOB((CLOB)rs.getObject(11)));
        obj.setName((String)rs.getObject(12));
        obj.setIstimeinterval(this.convert2Boolean(rs.getObject(13)));
        obj.setTimeinterval((Float)rs.getObject(14));
        return obj;
    }

    @Override
    public List<Expstudy> find(Connection con, Expstudy criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Expstudy> results = new LinkedList<Expstudy>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_EXPSTUDY ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Expstudy item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, Expstudy bean, Expstudy criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, Expstudy criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_EXPSTUDY ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

