/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.postgres;

import clinical.server.vo.Dataobject;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataobjectDAO
implements clinical.server.dao.DataobjectDAO {
    @Override
    public void insert(Connection con, Dataobject bean) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO nc_dataobject VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 11) {
                buf.append('?');
                if (i < 10) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, (Object)bean.getUniqueid(), 2);
            ps.setObject(2, (Object)bean.getTableid(), 2);
            ps.setObject(3, (Object)bean.getOwner(), 2);
            ps.setObject(4, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(5, (Object)bean.getModuser(), 2);
            ps.setObject(6, (Object)bean.getExtensionname(), 12);
            ps.setObject(7, (Object)bean.getDataid(), 2);
            ps.setObject(8, (Object)bean.getObjecttypeid(), 2);
            ps.setObject(9, (Object)bean.getObjectname(), 12);
            ps.setObject(10, (Object)bean.getObjectsize(), 2);
            ps.setObject(11, (Object)bean.getDescription(), 12);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    protected String prepareColList(Dataobject bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("uniqueid");
        buf.append(',');
        buf.append("tableid");
        buf.append(',');
        buf.append("owner");
        buf.append(',');
        buf.append("modtime");
        buf.append(',');
        buf.append("moduser");
        buf.append(',');
        buf.append("extensionname");
        buf.append(',');
        buf.append("dataid");
        buf.append(',');
        buf.append("objecttypeid");
        buf.append(',');
        buf.append("objectname");
        buf.append(',');
        buf.append("objectsize");
        buf.append(',');
        buf.append("description");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Dataobject bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("uniqueid=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("tableid=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("owner=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("modtime=?");
            qi.values.add(new Date(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("moduser=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getExtensionname() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("extensionname=?");
            qi.values.add(bean.getExtensionname());
            valueSet = true;
        }
        if (bean.getDataid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("dataid=?");
            qi.values.add(bean.getDataid());
            valueSet = true;
        }
        if (bean.getObjecttypeid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("objecttypeid=?");
            qi.values.add(bean.getObjecttypeid());
            valueSet = true;
        }
        if (bean.getObjectname() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("objectname=?");
            qi.values.add(bean.getObjectname());
            valueSet = true;
        }
        if (bean.getObjectsize() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("objectsize=?");
            qi.values.add(bean.getObjectsize());
            valueSet = true;
        }
        if (bean.getDescription() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("description=?");
            qi.values.add(bean.getDescription());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Dataobject bean, Dataobject criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE nc_dataobject SET ");
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("uniqueid=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("tableid=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("owner=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("modtime=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(93));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("moduser=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getExtensionname() != null || bean.isNull("extensionname")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("extensionname=? ");
            uqi.setValues.add(bean.getExtensionname());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("extensionname"), uqi);
            valueSet = true;
        }
        if (bean.getDataid() != null || bean.isNull("dataid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("dataid=? ");
            uqi.setValues.add(bean.getDataid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("dataid"), uqi);
            valueSet = true;
        }
        if (bean.getObjecttypeid() != null || bean.isNull("objecttypeid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("objecttypeid=? ");
            uqi.setValues.add(bean.getObjecttypeid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("objecttypeid"), uqi);
            valueSet = true;
        }
        if (bean.getObjectname() != null || bean.isNull("objectname")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("objectname=? ");
            uqi.setValues.add(bean.getObjectname());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("objectname"), uqi);
            valueSet = true;
        }
        if (bean.getObjectsize() != null || bean.isNull("objectsize")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("objectsize=? ");
            uqi.setValues.add(bean.getObjectsize());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("objectsize"), uqi);
            valueSet = true;
        }
        if (bean.getDescription() != null || bean.isNull("description")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("description=? ");
            uqi.setValues.add(bean.getDescription());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("description"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    public Dataobject createObject(ResultSet rs) throws SQLException {
        Dataobject obj = new Dataobject();
        obj.setUniqueid(rs.getObject(1) != null ? new BigDecimal(rs.getObject(1).toString()) : null);
        obj.setTableid(rs.getObject(2) != null ? new BigDecimal(rs.getObject(2).toString()) : null);
        obj.setOwner(rs.getObject(3) != null ? new BigDecimal(rs.getObject(3).toString()) : null);
        obj.setModtime(rs.getObject(4) != null ? new java.util.Date(((Timestamp)rs.getObject(4)).getTime()) : null);
        obj.setModuser(rs.getObject(5) != null ? new BigDecimal(rs.getObject(5).toString()) : null);
        obj.setExtensionname((String)rs.getObject(6));
        obj.setDataid(rs.getObject(7) != null ? new BigDecimal(rs.getObject(7).toString()) : null);
        obj.setObjecttypeid(rs.getObject(8) != null ? new BigDecimal(rs.getObject(8).toString()) : null);
        obj.setObjectname((String)rs.getObject(9));
        obj.setObjectsize(rs.getObject(10) != null ? new BigDecimal(rs.getObject(10).toString()) : null);
        obj.setDescription((String)rs.getObject(11));
        return obj;
    }

    @Override
    public List<Dataobject> find(Connection con, Dataobject criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Dataobject> results = new LinkedList<Dataobject>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM nc_dataobject ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Dataobject item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, Dataobject bean, Dataobject criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, Dataobject criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM nc_dataobject ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

