/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.postgres;

import clinical.server.utils.PostgresUtils;
import clinical.server.vo.Rangevalidator;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RangevalidatorDAO
implements clinical.server.dao.RangevalidatorDAO {
    @Override
    public void insert(Connection con, Rangevalidator bean) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO nc_rangevalidator VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 9) {
                buf.append('?');
                if (i < 8) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, (Object)bean.getUniqueid(), 2);
            ps.setObject(2, (Object)bean.getTableid(), 2);
            ps.setObject(3, (Object)bean.getOwner(), 2);
            ps.setObject(4, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(5, (Object)bean.getModuser(), 2);
            ps.setObject(6, (Object)PostgresUtils.toDouble((BigDecimal)bean.getLowlimit()), 2);
            ps.setObject(7, (Object)PostgresUtils.toDouble((BigDecimal)bean.getUpperlimit()), 2);
            ps.setObject(8, bean.getInclowlimit());
            ps.setObject(9, bean.getIncupperlimit());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    protected String prepareColList(Rangevalidator bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("uniqueid");
        buf.append(',');
        buf.append("tableid");
        buf.append(',');
        buf.append("owner");
        buf.append(',');
        buf.append("modtime");
        buf.append(',');
        buf.append("moduser");
        buf.append(',');
        buf.append("lowlimit");
        buf.append(',');
        buf.append("upperlimit");
        buf.append(',');
        buf.append("inclowlimit");
        buf.append(',');
        buf.append("incupperlimit");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Rangevalidator bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("uniqueid=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("tableid=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("owner=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("modtime=?");
            qi.values.add(new Date(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("moduser=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getLowlimit() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("lowlimit=?");
            qi.values.add(PostgresUtils.toDouble((BigDecimal)bean.getLowlimit()));
            valueSet = true;
        }
        if (bean.getUpperlimit() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("upperlimit=?");
            qi.values.add(PostgresUtils.toDouble((BigDecimal)bean.getUpperlimit()));
            valueSet = true;
        }
        if (bean.getInclowlimit() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("inclowlimit=?");
            qi.values.add(bean.getInclowlimit());
            valueSet = true;
        }
        if (bean.getIncupperlimit() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("incupperlimit=?");
            qi.values.add(bean.getIncupperlimit());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Rangevalidator bean, Rangevalidator criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE nc_rangevalidator SET ");
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("uniqueid=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("tableid=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("owner=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("modtime=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(93));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("moduser=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getLowlimit() != null || bean.isNull("lowlimit")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("lowlimit=? ");
            uqi.setValues.add(PostgresUtils.toDouble((BigDecimal)bean.getLowlimit()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("lowlimit"), uqi);
            valueSet = true;
        }
        if (bean.getUpperlimit() != null || bean.isNull("upperlimit")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("upperlimit=? ");
            uqi.setValues.add(PostgresUtils.toDouble((BigDecimal)bean.getUpperlimit()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("upperlimit"), uqi);
            valueSet = true;
        }
        if (bean.getInclowlimit() != null || bean.isNull("inclowlimit")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("inclowlimit=? ");
            uqi.setValues.add(bean.getInclowlimit());
            uqi.sqlTypes.add(new Integer(1));
            this.prepareNullSetListValue(bean.isNull("inclowlimit"), uqi);
            valueSet = true;
        }
        if (bean.getIncupperlimit() != null || bean.isNull("incupperlimit")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("incupperlimit=? ");
            uqi.setValues.add(bean.getIncupperlimit());
            uqi.sqlTypes.add(new Integer(1));
            this.prepareNullSetListValue(bean.isNull("incupperlimit"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    protected Boolean convert2Boolean(Object columnValue) {
        if (columnValue == null) {
            return null;
        }
        return ((BigDecimal)columnValue).intValue() > 0 ? new Boolean(true) : new Boolean(false);
    }

    protected BigDecimal boolean2Number(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? new BigDecimal("1") : new BigDecimal("0");
    }

    protected String boolean2YN(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "Y" : "N";
    }

    public Rangevalidator createObject(ResultSet rs) throws SQLException {
        Rangevalidator obj = new Rangevalidator();
        obj.setUniqueid(rs.getObject(1) != null ? new BigDecimal(rs.getObject(1).toString()) : null);
        obj.setTableid(rs.getObject(2) != null ? new BigDecimal(rs.getObject(2).toString()) : null);
        obj.setOwner(rs.getObject(3) != null ? new BigDecimal(rs.getObject(3).toString()) : null);
        obj.setModtime(rs.getObject(4) != null ? new java.util.Date(((Timestamp)rs.getObject(4)).getTime()) : null);
        obj.setModuser(rs.getObject(5) != null ? new BigDecimal(rs.getObject(5).toString()) : null);
        obj.setLowlimit(PostgresUtils.toBigDecimal((Object)rs.getObject(6)));
        obj.setUpperlimit(PostgresUtils.toBigDecimal((Object)rs.getObject(7)));
        obj.setInclowlimit((Boolean)rs.getObject(8));
        obj.setIncupperlimit((Boolean)rs.getObject(9));
        return obj;
    }

    @Override
    public List<Rangevalidator> find(Connection con, Rangevalidator criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Rangevalidator> results = new LinkedList<Rangevalidator>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM nc_rangevalidator ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Rangevalidator item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, Rangevalidator bean, Rangevalidator criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, Rangevalidator criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM nc_rangevalidator ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

