/*
 * Decompiled with CFR 0.152.
 */
package clinical.tools.install;

import clinical.tools.install.DBUserInfo;
import clinical.tools.install.DatabaseInfo;
import clinical.tools.install.IUserInput;
import clinical.tools.install.PrivilegeInfo;
import clinical.tools.install.RoleInfo;
import clinical.tools.install.UsersFileInfo;
import clinical.tools.install.Utils;
import clinical.tools.install.WebUserInfo;
import clinical.utils.GenUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.input.InputRequest;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class MinimalUserFileCreator
implements IUserInput {
    protected BufferedReader in;
    protected Project project;

    public MinimalUserFileCreator() {
        this.in = new BufferedReader(new InputStreamReader(System.in));
    }

    public MinimalUserFileCreator(Project project) {
        this.project = project;
    }

    @Override
    public String getInput(String prompt) throws IOException {
        if (this.in != null) {
            System.out.print(prompt);
            return this.in.readLine().trim();
        }
        InputRequest request = new InputRequest(prompt);
        this.project.getInputHandler().handleInput(request);
        String value = request.getInput();
        return value.trim();
    }

    public void prepareUsersFile(String xmlFilename) throws IOException, SQLException {
        UsersFileInfo ui;
        block17: {
            SiteInfo[] siArr;
            String ans;
            int idx;
            ui = new UsersFileInfo();
            System.out.println("Preparing mimimal users.xml file...");
            DatabaseInfo dbi = new DatabaseInfo();
            DBUserInfo dbui = new DBUserInfo();
            while (true) {
                System.out.println("------------------ Database Section -----------------");
                dbi.dbType = Utils.getUserInput("Please enter the database type", new String[]{"postgres", "oracle"}, this);
                dbi.hostName = Utils.getUserInput("In most cases, the fully qualified hostname of your gpop is the host name\nPlease enter the database server host name", null, this);
                dbi.dbID = Utils.getUserInput("The database id is expected to be unique and made up from characters and '_' only\nA valid database ID is, for example, ucsd_fbirn .\nThe database id is, usually, representative of the corresponding HID database \nand is used to identify different data sources by the web app.\n\nPlease enter the database id", null, this);
                dbi.defaultDB = true;
                if (dbi.dbType.equalsIgnoreCase("oracle")) {
                    dbi.port = GenUtils.toInt(Utils.getUserInput("In most cases, the Oracle database connection port is 1521.\n\nPlease enter the database server connection port", null, this), 1521);
                    dbi.SID = Utils.getUserInput("For most default BIRN rack Oracle installation the SID is orcl1\n\nPlease enter the SID of your database", null, this);
                } else if (dbi.dbType.equalsIgnoreCase("postgres")) {
                    dbi.SID = Utils.getUserInput("Please enter the name of your Postgres database", null, this);
                    String s = Utils.getUserInput("The default port for Postgres is 5432.\n\nPlease enter the database server connection port", null, this);
                    dbi.port = GenUtils.toInt(s, 5432);
                }
                ui.addDatabase(dbi);
                PrivilegeInfo pi = new PrivilegeInfo("admin", "", false);
                ui.addPrivilege(pi);
                pi = new PrivilegeInfo("create-project", "", false);
                ui.addPrivilege(pi);
                ui.addPrivilege(new PrivilegeInfo("create-user", "Privilege to add/invite new web users to the system.", false));
                ui.addPrivilege(new PrivilegeInfo("create-subject", "", true));
                ui.addPrivilege(new PrivilegeInfo("read", "", true));
                ui.addPrivilege(new PrivilegeInfo("update", "", true));
                ui.addPrivilege(new PrivilegeInfo("delete", "", true));
                ui.addRole(new RoleInfo("principal investigator", null));
                ui.addRole(new RoleInfo("researcher", null));
                dbui.name = Utils.getUserInput("Please enter the named database connection user name", null, this);
                dbui.password = Utils.getUserInput("Please enter the named database connection password", null, this);
                dbui.dbID = dbi.dbID;
                if (MinimalUserFileCreator.testJDBCConnection(ui.findDatabase(dbui.dbID), dbui)) break;
                dbi = new DatabaseInfo();
                dbui = new DBUserInfo();
                ui = new UsersFileInfo();
            }
            System.out.println("Database connection test is successful for user " + dbui.name + ".");
            System.out.println("==============================================================");
            System.out.println();
            ui.addDBUser(dbui);
            WebUserInfo wui = new WebUserInfo();
            wui.name = "admin";
            wui.dbID = dbi.dbID;
            wui.dbUser = dbui.name;
            wui.password = Utils.getUserInput("Please enter the admin web user password for database user '" + wui.dbUser + "' for database '" + wui.dbID + "' ", null, this);
            for (PrivilegeInfo pri : ui.privileges) {
                wui.addPrivilege(new PrivilegeInfo(pri.name, null, pri.projectSpecific));
            }
            if (ui.findWebUser(wui.name, wui.dbID, wui.dbUser) == null) {
                ui.addWebUser(wui);
            }
            Map<String, SiteInfo> siMap = MinimalUserFileCreator.getSites(dbi, dbui);
            int maxSiteUniqueId = -1;
            do {
                idx = 0;
                siArr = new SiteInfo[siMap.size()];
                for (SiteInfo si : siMap.values()) {
                    System.out.println(String.valueOf(idx) + ") " + si.siteName + " (" + si.siteID + ")");
                    siArr[idx] = si;
                    ++idx;
                    if (si.uniqueId <= maxSiteUniqueId) continue;
                    maxSiteUniqueId = si.uniqueId;
                }
                ans = Utils.getUserInput("Please select a site from the menu or enter the keyword 'new' for a new site", null, this);
                if (!ans.equalsIgnoreCase("new")) continue;
                String siteId = null;
                String siteName = null;
                while (!MinimalUserFileCreator.isValidSiteId(siteId = Utils.getUserInput("Please enter four digit zero padded Site ID (e.g. 0008)", null, this))) {
                }
                siteName = Utils.getUserInput("Please enter a site name (e.g. UCSD)", null, this);
                SiteInfo si = new SiteInfo(siteId, siteName, true);
                si.uniqueId = maxSiteUniqueId + 1;
                dbi.siteId = siteId;
                dbi.siteName = siteName;
                MinimalUserFileCreator.addSite(dbi, dbui, si);
                break block17;
            } while ((idx = GenUtils.toInt(ans, -1)) == -1);
            dbi.siteId = siArr[idx].siteID;
            dbi.siteName = siArr[idx].siteName;
        }
        FilterOutputStream bout = null;
        try {
            bout = new BufferedOutputStream(new FileOutputStream(xmlFilename));
            this.saveAsXML(bout, ui.toXML());
            System.out.println("Saved bootstrapping information to " + xmlFilename);
        }
        finally {
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean isValidSiteId(String siteId) {
        if (siteId == null || siteId.length() != 4) {
            return false;
        }
        return GenUtils.toInt(siteId, -1) != -1;
    }

    protected void saveAsXML(OutputStream out, Element parent) throws IOException {
        Format format = Format.getPrettyFormat();
        format.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter xmlOut = new XMLOutputter(format);
        xmlOut.output(parent, out);
    }

    protected static Map<String, SiteInfo> getSites(DatabaseInfo dbi, DBUserInfo dbUserInfo) throws SQLException {
        LinkedHashMap<String, SiteInfo> linkedHashMap;
        LinkedHashMap<String, SiteInfo> siteNameIDMap = new LinkedHashMap<String, SiteInfo>();
        Connection con = null;
        Statement st = null;
        try {
            con = DriverManager.getConnection(dbi.getDBURL(), dbUserInfo.name, dbUserInfo.password);
            st = con.createStatement();
            ResultSet rs = st.executeQuery("select siteid,sitename, isprimary, uniqueid from nc_site");
            while (rs.next()) {
                String siteID = rs.getString(1);
                String siteName = rs.getString(2);
                String isPrimaryStr = rs.getString(3);
                int uniqueId = rs.getInt(4);
                boolean isPrimary = isPrimaryStr.equalsIgnoreCase("true") || isPrimaryStr.equals("1");
                SiteInfo si = new SiteInfo(siteID, siteName, isPrimary);
                si.uniqueId = uniqueId;
                siteNameIDMap.put(siteID, si);
            }
            rs.close();
            linkedHashMap = siteNameIDMap;
        }
        catch (Throwable throwable) {
            MinimalUserFileCreator.close(con, st);
            throw throwable;
        }
        MinimalUserFileCreator.close(con, st);
        return linkedHashMap;
    }

    protected static void addSite(DatabaseInfo dbi, DBUserInfo dbUserInfo, SiteInfo si) throws SQLException {
        Connection con = null;
        PreparedStatement pst = null;
        Statement st = null;
        try {
            try {
                con = DriverManager.getConnection(dbi.getDBURL(), dbUserInfo.name, dbUserInfo.password);
                con.setAutoCommit(false);
                int tableId = MinimalUserFileCreator.getTableId(con, "nc_site");
                if (dbi.dbType.equalsIgnoreCase("oracle")) {
                    st = con.createStatement();
                    ResultSet rs = st.executeQuery("select u.uniqueid from nc_databaseuser u, nc_userclass c where u.isgroup=0 and u.userclass = c.uniqueid and c.name='admin'");
                    if (rs.next()) {
                        String userId = rs.getString(1);
                        if (si.primary) {
                            MinimalUserFileCreator.resetPrimaryDatabase(con, dbi.dbType);
                        }
                        pst = con.prepareStatement("insert into nc_site values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                        pst.clearParameters();
                        pst.setBigDecimal(1, new BigDecimal(si.uniqueId));
                        pst.setBigDecimal(2, new BigDecimal(tableId));
                        pst.setBigDecimal(3, new BigDecimal(userId));
                        pst.setDate(4, new Date(System.currentTimeMillis()));
                        pst.setBigDecimal(5, new BigDecimal(userId));
                        pst.setString(6, si.siteID);
                        pst.setString(7, si.siteName);
                        pst.setBigDecimal(8, new BigDecimal(si.primary ? 1 : 0));
                        pst.setString(9, "databaseAddress");
                        pst.setString(10, dbi.SID);
                        pst.setString(11, "Oracle");
                        pst.setString(12, "databaseVersion");
                        pst.setBigDecimal(13, new BigDecimal(dbi.port));
                        pst.setString(14, "contactFirstName");
                        pst.setString(15, "contactLastName");
                        pst.setString(16, "contactEmail");
                        pst.setString(17, "contactPhone");
                        pst.execute();
                    }
                    rs.close();
                    con.commit();
                } else {
                    st = con.createStatement();
                    ResultSet rs = st.executeQuery("select u.uniqueid from nc_databaseuser u, nc_userclass c where u.isgroup=false and u.userclass = c.uniqueid and c.name='admin'");
                    if (rs.next()) {
                        String userId = rs.getString(1);
                        if (si.primary) {
                            MinimalUserFileCreator.resetPrimaryDatabase(con, dbi.dbType);
                        }
                        pst = con.prepareStatement("insert into nc_site values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                        pst.clearParameters();
                        pst.setLong(1, new Long(si.uniqueId));
                        pst.setLong(2, new Long(tableId));
                        pst.setLong(3, new Long(userId));
                        pst.setDate(4, new Date(System.currentTimeMillis()));
                        pst.setLong(5, new Long(userId));
                        pst.setString(6, si.siteID);
                        pst.setString(7, si.siteName);
                        pst.setLong(8, new Long(si.primary ? 1 : 0));
                        pst.setString(9, "databaseAddress");
                        pst.setString(10, dbi.SID);
                        pst.setString(11, "Postgres");
                        pst.setString(12, "databaseVersion");
                        pst.setLong(13, new Long(5432L));
                        pst.setString(14, "contactFirstName");
                        pst.setString(15, "contactLastName");
                        pst.setString(16, "contactEmail");
                        pst.setString(17, "contactPhone");
                        pst.execute();
                    }
                    rs.close();
                    con.commit();
                }
            }
            catch (SQLException x) {
                if (con != null) {
                    con.rollback();
                }
                throw x;
            }
        }
        catch (Throwable throwable) {
            MinimalUserFileCreator.close(st);
            MinimalUserFileCreator.close(con, pst);
            throw throwable;
        }
        MinimalUserFileCreator.close(st);
        MinimalUserFileCreator.close(con, pst);
    }

    public static int getTableId(Connection con, String tableName) throws SQLException {
        PreparedStatement pst = null;
        try {
            pst = con.prepareStatement("select tableid from nc_tableid where tablename = ?");
            pst.setString(1, tableName.toUpperCase());
            ResultSet rs = pst.executeQuery();
            int tableID = -1;
            if (rs.next()) {
                tableID = rs.getInt(1);
            }
            rs.close();
            int n = tableID;
            return n;
        }
        finally {
            MinimalUserFileCreator.close(pst);
        }
    }

    public static void resetPrimaryDatabase(Connection con, String dbType) throws SQLException {
        PreparedStatement pst = null;
        try {
            pst = con.prepareStatement("update nc_site set isprimary = 0");
            pst.execute();
        }
        finally {
            MinimalUserFileCreator.close(pst);
        }
    }

    public static boolean testJDBCConnection(DatabaseInfo dbi, DBUserInfo dbUserInfo) {
        Connection con = null;
        Statement st = null;
        String testQuery = "select 2 from dual";
        try {
            try {
                if (dbi.dbType.equalsIgnoreCase("oracle")) {
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                } else if (dbi.dbType.equalsIgnoreCase("postgres")) {
                    Class.forName("org.postgresql.Driver");
                    testQuery = "select 2";
                }
                con = DriverManager.getConnection(dbi.getDBURL(), dbUserInfo.name, dbUserInfo.password);
                st = con.createStatement();
                ResultSet rs = st.executeQuery(testQuery);
                rs.close();
            }
            catch (Exception x) {
                x.printStackTrace();
                MinimalUserFileCreator.close(con, st);
                return false;
            }
        }
        catch (Throwable throwable) {
            MinimalUserFileCreator.close(con, st);
            throw throwable;
        }
        MinimalUserFileCreator.close(con, st);
        return true;
    }

    protected static void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static void close(Connection con, Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String[] getPrivilegeNames(List<PrivilegeInfo> privileges) {
        String[] privNames = new String[privileges.size()];
        int i = 0;
        for (PrivilegeInfo pi : privileges) {
            privNames[i++] = pi.name;
        }
        return privNames;
    }

    public static void main(String[] args) throws Exception {
        DatabaseInfo dbi = new DatabaseInfo();
        dbi.hostName = "fmri-gpop.nbirn.net";
        DBUserInfo dbui = new DBUserInfo();
        dbui.name = "fbirn_test2";
        dbui.password = "testit";
        MinimalUserFileCreator.testJDBCConnection(dbi, dbui);
        Map<String, SiteInfo> map = MinimalUserFileCreator.getSites(dbi, dbui);
        System.out.println(map);
        SiteInfo si = new SiteInfo("1111", "test_site", false);
        si.uniqueId = 357280;
        MinimalUserFileCreator muc = new MinimalUserFileCreator();
        String homeDir = System.getProperty("user.home");
        String xmlFilename = String.valueOf(homeDir) + "/users.xml";
        muc.prepareUsersFile(xmlFilename);
    }

    public static class SiteInfo {
        String siteID;
        String siteName;
        boolean primary;
        int uniqueId;

        public SiteInfo(String siteID, String siteName, boolean primary) {
            this.siteID = siteID;
            this.siteName = siteName;
            this.primary = primary;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("SiteInfo::[");
            buf.append("siteID=").append(this.siteID);
            buf.append(",siteName=").append(this.siteName);
            buf.append(",primary=").append(this.primary);
            buf.append(",uniqueId=").append(this.uniqueId);
            buf.append(']');
            return buf.toString();
        }
    }
}

