/*
 * Decompiled with CFR 0.152.
 */
package clinical.tools.install;

import clinical.tools.install.DBUserInfo;
import clinical.tools.install.DatabaseInfo;
import clinical.tools.install.PrivilegeInfo;
import clinical.tools.install.UsersFileInfo;
import clinical.tools.install.WebUserInfo;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.input.InputRequest;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class UsersFileCreator {
    protected BufferedReader in;
    protected Project project;

    public UsersFileCreator() {
        this.in = new BufferedReader(new InputStreamReader(System.in));
    }

    public UsersFileCreator(Project project) {
        this.project = project;
    }

    public String getInput(String prompt) throws IOException {
        if (this.in != null) {
            System.out.print(prompt);
            return this.in.readLine().trim();
        }
        InputRequest request = new InputRequest(prompt);
        this.project.getInputHandler().handleInput(request);
        String value = request.getInput();
        return value.trim();
    }

    public String getUserInput(String prompt, String[] posValues) throws IOException {
        StringBuffer buf = new StringBuffer(128);
        buf.append(prompt);
        if (posValues != null) {
            buf.append(" (");
            int i = 0;
            while (i < posValues.length) {
                if (i == 0) {
                    buf.append('[');
                }
                buf.append(posValues[i]);
                if (i == 0) {
                    buf.append(']');
                }
                if (i + 1 < posValues.length) {
                    buf.append(",");
                }
                ++i;
            }
            buf.append(" ) ");
        }
        buf.append(" >> ");
        String answer = this.getInput(buf.toString());
        boolean ok = true;
        do {
            if (answer.length() > 0) {
                if (posValues != null && UsersFileCreator.validAnswer(answer, posValues) || posValues == null) {
                    break;
                }
            } else if (posValues != null) {
                return posValues[0];
            }
            answer = this.getInput(buf.toString());
        } while (!ok);
        return answer;
    }

    public static boolean validAnswer(String answer, String[] posValues) {
        int i = 0;
        while (i < posValues.length) {
            if (answer.equals(posValues[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getDbUsers(List<DBUserInfo> dbUsers, String dbID) {
        LinkedList<String> l = new LinkedList<String>();
        for (DBUserInfo dbui : dbUsers) {
            if (!dbui.dbID.equals(dbID)) continue;
            l.add(dbui.name);
        }
        String[] dbUsersArr = new String[l.size()];
        return l.toArray(dbUsersArr);
    }

    public static String[] getPrivilegeNames(List<PrivilegeInfo> privileges) {
        String[] privNames = new String[privileges.size()];
        int i = 0;
        for (PrivilegeInfo pi : privileges) {
            privNames[i++] = pi.name;
        }
        return privNames;
    }

    public static String[] updatePrivilegeNames(String[] privNames, String usedPriv) {
        if (privNames.length == 1) {
            return null;
        }
        String[] npnArr = new String[privNames.length - 1];
        int idx = 0;
        int i = 0;
        while (i < privNames.length) {
            if (!privNames[i].equals(usedPriv)) {
                npnArr[idx++] = privNames[i];
            }
            ++i;
        }
        return npnArr;
    }

    public static boolean testJDBCConnection(DatabaseInfo dbi, DBUserInfo dbUserInfo) {
        Connection con = null;
        Statement st = null;
        String testQuery = "select 2 from dual";
        try {
            try {
                if (dbi.dbType.equalsIgnoreCase("oracle")) {
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                } else if (dbi.dbType.equalsIgnoreCase("postgres")) {
                    Class.forName("org.postgresql.Driver");
                    testQuery = "select 2";
                }
                con = DriverManager.getConnection(dbi.getDBURL(), dbUserInfo.name, dbUserInfo.password);
                st = con.createStatement();
                ResultSet rs = st.executeQuery(testQuery);
                rs.close();
            }
            catch (Exception x) {
                x.printStackTrace();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public void prepareUsersFile(String xmlFilename) throws IOException {
        UsersFileInfo ui = new UsersFileInfo();
        String ans = "";
        System.out.println("Preparing users.xml file...");
        System.out.println("------------------ Database Section -----------------");
        String[] yesNo = new String[]{"y", "n"};
        do {
            DatabaseInfo dbi = new DatabaseInfo();
            dbi.dbType = this.getUserInput("Please enter the database type", new String[]{"oracle", "postgres"});
            dbi.hostName = this.getUserInput("In most cases, the fully qualified hostname of your gpop is the host name\n Please enter the database server host name", null);
            dbi.dbID = this.getUserInput("The database id is expected of this format <site-name>_[mbirn|fbirn]\nA valid database ID is, for example, ucsd_fbirn or mgh_mbirn.\n The database id is used to identify different data sources by the web app.\n\n Please enter the database id", null);
            dbi.defaultDB = this.getUserInput("The default database flag determines to which database the web app will be connected by default.\n\n Please enter if this database is the default database", yesNo).equals("y");
            if (dbi.dbType.equalsIgnoreCase("oracle")) {
                dbi.port = Integer.parseInt(this.getUserInput("In most cases, the Oracle database connection port is 1521.\n\n Please enter the database server connection port", null));
                dbi.SID = this.getUserInput("For most default BIRN rack Oracle installation the SID is orcl1\n\nPlease enter the SID of your database", null);
            } else if (dbi.dbType.equalsIgnoreCase("postgres")) {
                dbi.SID = this.getUserInput("Please enter the name of your Postgres database", null);
            }
            ui.addDatabase(dbi);
        } while ((ans = this.getUserInput("\nDo you want to enter another database", yesNo)).equals("y"));
        PrivilegeInfo pi = new PrivilegeInfo("manageExperiment", "Any user with this privilege can add/or update\nexperiment(s), enroll subjects to an experiment and/or changetheir study group", false);
        ui.addPrivilege(pi);
        pi = new PrivilegeInfo("manageSubject", "", false);
        ui.addPrivilege(pi);
        String[] dbIDs = new String[ui.databases.size()];
        int i = 0;
        for (DatabaseInfo dbi : ui.databases) {
            dbIDs[i++] = dbi.dbID;
        }
        System.out.println("------------------ Database Users Section -----------------");
        do {
            DBUserInfo dbui = new DBUserInfo();
            dbui.name = this.getUserInput("Please enter the named database connection user name", null);
            dbui.password = this.getUserInput("Please enter the named database connection password", null);
            dbui.dbID = this.getUserInput("Please enter the database id this database user belongs", dbIDs);
            ans = this.getUserInput("\nDo you want to test the database connection for this user", yesNo);
            if (ans.equals("y")) {
                if (!UsersFileCreator.testJDBCConnection(ui.findDatabase(dbui.dbID), dbui)) continue;
                System.out.println("Database connection test is successful for user " + dbui.name + ".");
                System.out.println("==============================================================");
                System.out.println();
            }
            ui.addDBUser(dbui);
            ans = this.getUserInput("\nDo you want to enter another database user ", yesNo);
        } while (ans.equals("y"));
        System.out.println("------------------ Web App Mandatory Users Section -----------------\n");
        System.out.println("IMPORTANT: A mandatory 'admin' user with all privileges (including admin privilege for web based'");
        System.out.println("database/user/app configuration) will be created first with minimal user input\n");
        this.addAdminUsers(ui, dbIDs);
        System.out.println("------------------ Web App Users Section -----------------\n");
        do {
            WebUserInfo wui = new WebUserInfo();
            wui.name = this.getUserInput("Please enter the web user name", null);
            wui.password = this.getUserInput("Please enter the web user password", null);
            wui.dbID = this.getUserInput("Please enter the database id for the database this web user uses", dbIDs);
            String[] dbUsers = UsersFileCreator.getDbUsers(ui.dbUsers, wui.dbID);
            wui.dbUser = this.getUserInput("Please enter the database user, this web user will be associated", dbUsers);
            if (ui.findWebUser(wui.name, wui.dbID, wui.dbUser) != null) {
                System.out.println("DUPLICATE webUser:" + wui.name + "! Please enter a unique web user name for the corresponding database!");
                continue;
            }
            ui.addWebUser(wui);
            String[] privNames = UsersFileCreator.getPrivilegeNames(ui.privileges);
            do {
                if (!(ans = this.getUserInput("\nDo you want to enter a privilege for this web user ", yesNo)).equals("y")) continue;
                String privName = this.getUserInput("Please enter a privilege for this user", privNames);
                wui.addPrivilege(new PrivilegeInfo(privName, null, false));
                privNames = UsersFileCreator.updatePrivilegeNames(privNames, privName);
            } while (privNames != null && ans.equals("y"));
            ans = this.getUserInput("\nDo you want to enter another web user ", yesNo);
        } while (ans.equals("y"));
        FilterOutputStream bout = null;
        try {
            bout = new BufferedOutputStream(new FileOutputStream(xmlFilename));
            this.saveAsXML(bout, ui.toXML());
        }
        finally {
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void addAdminUsers(UsersFileInfo ui, String[] dbIDs) throws IOException {
        int i = 0;
        while (i < dbIDs.length) {
            WebUserInfo wui = new WebUserInfo();
            wui.name = "admin";
            wui.dbID = dbIDs[i];
            String[] dbUsers = UsersFileCreator.getDbUsers(ui.dbUsers, wui.dbID);
            wui.dbUser = dbUsers.length == 0 ? dbUsers[0] : this.getUserInput("Please enter the database user, the admin web user for database '" + wui.dbID + "' will be associated", dbUsers);
            wui.password = this.getUserInput("Please enter the admin web user password for database user '" + wui.dbUser + "' for database '" + wui.dbID + "' ", null);
            String[] privNames = UsersFileCreator.getPrivilegeNames(ui.privileges);
            int j = 0;
            while (j < privNames.length) {
                wui.addPrivilege(new PrivilegeInfo(privNames[j], null, false));
                ++j;
            }
            if (ui.findWebUser(wui.name, wui.dbID, wui.dbUser) == null) {
                ui.addWebUser(wui);
            }
            ++i;
        }
    }

    protected void saveAsXML(OutputStream out, Element parent) throws IOException {
        Format format = Format.getPrettyFormat();
        format.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter xmlOut = new XMLOutputter(format);
        xmlOut.output(parent, out);
    }

    public static void main(String[] args) {
        try {
            UsersFileCreator inst = new UsersFileCreator();
            inst.prepareUsersFile("/home/bozyurt/users.xml");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

