/*
 * Decompiled with CFR 0.152.
 */
package clinical.utils;

import clinical.utils.DateTimeUtils;
import clinical.utils.GenUtils;
import clinical.utils.MaxConnectionsExceededException;
import clinical.utils.NamedUserPoolException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NamedUserPool {
    protected Map<String, NamedUser> namedUserMap = Collections.synchronizedMap(new HashMap());
    protected String dbURL;
    protected String testQuery = "SELECT 1 FROM DUAL";
    protected int maxConnections;
    protected int subPoolSize = 2;
    protected long maxIdleTime = 1800000L;
    protected long checkInterval = 300000L;
    protected boolean showStats = false;
    protected Thread cleanupThread;
    protected static Map<String, NamedUserPool> instanceMap = new LinkedHashMap<String, NamedUserPool>(7);
    protected static NamedUserPool instance = null;
    protected static final int MAX_CONNECTIONS = 30;
    protected static Logger log = Logger.getLogger(NamedUserPool.class);
    protected static Map<String, String> testQueryMap = new HashMap<String, String>();

    static {
        testQueryMap.put("oracle.jdbc.driver.OracleDriver", "SELECT 1 FROM DUAL");
        testQueryMap.put("org.postgresql.Driver", "SELECT 1");
    }

    protected NamedUserPool(String driverClass, String dbURL, int maxConnections, String testQuery) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class.forName(driverClass).newInstance();
        this.dbURL = dbURL;
        this.maxConnections = maxConnections;
        this.testQuery = testQuery;
        this.cleanupThread = new Thread(new PoolCleanup(this, this.maxIdleTime, this.checkInterval));
        this.cleanupThread.setDaemon(true);
        this.cleanupThread.setPriority(4);
        this.cleanupThread.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("registered driver " + driverClass + " and started cleanupThread."));
        }
    }

    protected NamedUserPool(String driverClass, String dbURL) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this(driverClass, dbURL, 30, NamedUserPool.selectTestQuery(driverClass));
    }

    protected static String selectTestQuery(String driverClass) {
        String aTestQuery = testQueryMap.get(driverClass);
        if (aTestQuery == null) {
            throw new RuntimeException("JDBC Driver is not supported!:" + driverClass);
        }
        return aTestQuery;
    }

    public static synchronized NamedUserPool getInstance(String driverClass, String dbURL) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        NamedUserPool nup = instanceMap.get(dbURL);
        if (nup == null) {
            log.debug((Object)"*** creating a new NamedUserPool object");
            nup = new NamedUserPool(driverClass, dbURL);
            instanceMap.put(dbURL, nup);
        }
        return nup;
    }

    public static synchronized NamedUserPool getInstance(String dbURL) throws NamedUserPoolException {
        NamedUserPool nup = instanceMap.get(dbURL);
        if (nup == null) {
            throw new NamedUserPoolException("NamedUserPool is not initialized");
        }
        return nup;
    }

    public synchronized int getTotPoolSize() {
        int count = 0;
        for (NamedUser nu : this.namedUserMap.values()) {
            count += nu.getPoolSize();
        }
        return count;
    }

    public synchronized Connection getConnection(String user) throws SQLException, MaxConnectionsExceededException, NamedUserPoolException {
        return this.getConnection(user, null);
    }

    public synchronized Connection getConnection(String user, String pwd) throws MaxConnectionsExceededException, NamedUserPoolException {
        NamedUser nu = this.namedUserMap.get(user);
        if (nu == null) {
            if (pwd == null) {
                throw new NamedUserPoolException("Cannot resize subpool without password!");
            }
            int totPoolSize = this.getTotPoolSize();
            if (totPoolSize >= this.maxConnections) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("number of database connections pooled has reached:" + this.maxConnections));
                }
                Iterator<NamedUser> it = this.namedUserMap.values().iterator();
                while (it.hasNext()) {
                    NamedUser n = it.next();
                    n.cleanupIdleConnections(-1L);
                    if (n.getPoolSize() != 0) continue;
                    it.remove();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("removed subpool for " + n.user));
                }
                if (this.getTotPoolSize() <= this.maxConnections) {
                    throw new MaxConnectionsExceededException();
                }
            }
            nu = new NamedUser(user, pwd, this.dbURL, this.testQuery, this.subPoolSize);
            this.namedUserMap.put(user, nu);
            if (log.isDebugEnabled()) {
                log.debug((Object)("added a new named user <" + user + "> subpool!"));
            }
        }
        return nu.getConnection(pwd);
    }

    public synchronized void releaseConnection(String user, Connection con) throws NamedUserPoolException {
        if (con == null) {
            return;
        }
        NamedUser nu = this.namedUserMap.get(user);
        if (nu != null) {
            nu.releaseConnection(con);
            if (log.isDebugEnabled()) {
                log.debug((Object)("released connection " + con));
            }
        }
    }

    public synchronized void shutdown() {
        for (NamedUser nu : this.namedUserMap.values()) {
            nu.shutdown();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Shutdown all subpools.");
        }
        instance = null;
    }

    public synchronized void setShowStats(boolean newShowStats) {
        this.showStats = newShowStats;
        for (NamedUser nu : this.namedUserMap.values()) {
            nu.setDumpStats(this.showStats);
        }
    }

    public synchronized boolean getShowStats() {
        return this.showStats;
    }

    public static class ConnectionInfo {
        private boolean inUse;
        private long lastAccessed;
        private Connection con;

        public ConnectionInfo(Connection con, boolean inUse) {
            this.con = con;
            this.inUse = inUse;
        }

        public ConnectionInfo(Connection con) {
            this(con, true);
        }

        public Connection getConnection() {
            return this.con;
        }

        void setInUse(boolean value) {
            this.inUse = value;
        }

        void setLastAccessed(long lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(128);
            sb.append("ConnectionInfo::[");
            sb.append("con=").append(this.con).append(" lastAccessed=").append(this.lastAccessed).append(" inUse=");
            sb.append(this.inUse);
            sb.append(']');
            return sb.toString();
        }
    }

    public static class NamedUser {
        private String user;
        private String dbURL;
        private boolean dumpStats = false;
        private int minPoolSize = 1;
        private int maxPoolSize = 25;
        private String testQuery;
        private Map<Connection, ConnectionInfo> pool = Collections.synchronizedMap(new HashMap(7));
        private List<ConnectionInfo> availList = new LinkedList<ConnectionInfo>();

        public NamedUser(String user, String pwd, String dbURL, String testQuery, int poolSize) throws NamedUserPoolException {
            this.user = user;
            this.testQuery = testQuery;
            this.dbURL = dbURL;
            DriverManager.setLoginTimeout(5);
            System.out.println("DB connection timeout (secs):" + DriverManager.getLoginTimeout());
            int i = 0;
            while (i < poolSize) {
                try {
                    System.out.println("trying to get a connection:" + dbURL);
                    Connection con = DriverManager.getConnection(dbURL, user, pwd);
                    System.out.println("got connection:" + dbURL);
                    ConnectionInfo ci = new ConnectionInfo(con, false);
                    this.pool.put(con, ci);
                    this.availList.add(ci);
                }
                catch (SQLException se) {
                    log.error((Object)"NamedUser", (Throwable)se);
                }
                if (i > 1 && this.pool.isEmpty()) break;
                ++i;
            }
            if (this.pool.size() == 0) {
                throw new NamedUserPoolException("Error in named user subpool creation!");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created a subpool for user " + user + " of size " + this.pool.size()));
            }
        }

        public int getPoolSize() {
            return this.pool.size();
        }

        public synchronized Connection getConnection() throws NamedUserPoolException {
            return this.getConnection(null);
        }

        public void setDumpStats(boolean newDumpStats) {
            this.dumpStats = newDumpStats;
        }

        public boolean getDumpStats() {
            return this.dumpStats;
        }

        public synchronized Connection getConnection(String pwd) throws NamedUserPoolException {
            if (this.availList.isEmpty()) {
                if (pwd != null && this.pool.size() < this.minPoolSize) {
                    this.addConnections(this.user, pwd, this.dbURL, this.minPoolSize - this.pool.size());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Subpool " + this.user + " was below minPoolSize. New #pooled connections:" + this.pool.size()));
                    }
                } else if (pwd != null && this.pool.size() < this.maxPoolSize) {
                    int numNewConnections = Math.min(Math.max((int)((double)this.pool.size() * 0.25), 1), this.maxPoolSize - this.pool.size());
                    this.addConnections(this.user, pwd, this.dbURL, numNewConnections);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Subpool " + this.user + " was not large enough. New #pooled connections:" + this.pool.size()));
                    }
                } else {
                    if (pwd == null) {
                        throw new NamedUserPoolException("Cannot grow subpool for user " + this.user + " without proper password!");
                    }
                    throw new NamedUserPoolException("Cannot grow subpool for user " + this.user + " beyond the maximum subpool size :" + this.pool.size());
                }
            }
            ConnectionInfo ci = (ConnectionInfo)((LinkedList)this.availList).removeFirst();
            try {
                ci.setInUse(true);
                ci.setLastAccessed(System.currentTimeMillis());
                ci.getConnection().setAutoCommit(true);
                this.testConnection(ci.getConnection());
                return ci.getConnection();
            }
            catch (SQLException se) {
                this.pool.remove(ci.getConnection());
                log.debug((Object)"Connection was reset by the database server");
                return this.getConnection(pwd);
            }
        }

        /*
         * Unable to fully structure code
         */
        private void logConnectionRequester() {
            NamedUserPool.log.info((Object)("user=" + this.user + " time=" + DateTimeUtils.formatDate((long)System.currentTimeMillis())));
            try {
                throw new Exception();
            }
            catch (Exception x) {
                stElems = GenUtils.prepareStackTrace(x, "clinical");
                i = 0;
                ** while (i < stElems.length)
            }
lbl-1000:
            // 1 sources

            {
                NamedUserPool.log.info((Object)stElems[i].toString());
                ++i;
                continue;
            }
lbl11:
            // 1 sources

            NamedUserPool.log.info((Object)"--- end of logConnectionRequester");
        }

        public synchronized void releaseConnection(Connection con) throws NamedUserPoolException {
            block17: {
                if (con == null) {
                    throw new NamedUserPoolException("Connection passed is null!");
                }
                ConnectionInfo ci = this.pool.get(con);
                if (ci == null) {
                    log.error((Object)("connection passed was not in the pool: con=" + con));
                    return;
                }
                Statement st = null;
                try {
                    try {
                        Connection c = ci.getConnection();
                        if (c == null) {
                            throw new SQLException();
                        }
                        st = c.createStatement();
                        st.executeQuery(this.testQuery);
                        ci.setInUse(false);
                        this.availList.add(ci);
                        ci.setLastAccessed(System.currentTimeMillis());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Connection released back to subpool <" + this.user + "," + ci.getConnection() + ">."));
                        }
                    }
                    catch (SQLException se) {
                        this.pool.remove(ci.getConnection());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Bad connection (removed) :" + ci.getConnection()));
                        }
                        log.info((Object)("Bad connection (removed) :" + ci.toString()));
                        if (st == null) break block17;
                        try {
                            st.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }

        private void testConnection(Connection con) throws SQLException {
            if (con == null) {
                throw new SQLException();
            }
            Statement st = null;
            try {
                st = con.createStatement();
                st.executeQuery(this.testQuery);
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        protected synchronized void addConnections(String user, String pwd, String dbURL, int count) throws NamedUserPoolException {
            int i = 0;
            while (i < count) {
                this.addConnection(user, pwd, dbURL);
                ++i;
            }
        }

        protected void addConnection(String user, String pwd, String dbURL) throws NamedUserPoolException {
            boolean success = false;
            String errMsg = null;
            int count = 0;
            while (!success && count < 1) {
                long start = 0L;
                try {
                    DriverManager.setLoginTimeout(5);
                    System.out.println("connection timeout:" + DriverManager.getLoginTimeout());
                    start = System.currentTimeMillis();
                    Connection con = DriverManager.getConnection(dbURL, user, pwd);
                    System.out.println("Elapsed time:" + (System.currentTimeMillis() - start));
                    ConnectionInfo ci = new ConnectionInfo(con, false);
                    this.pool.put(con, ci);
                    this.availList.add(ci);
                    success = true;
                    break;
                }
                catch (SQLException se) {
                    System.out.println("Elapsed time:" + (System.currentTimeMillis() - start));
                    errMsg = se.getMessage();
                    if (++count >= 1) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!success) {
                throw new NamedUserPoolException("Cannot create new database connection:" + errMsg);
            }
        }

        public synchronized void dumpPoolStatus() {
            log.info((Object)("pool status at " + DateTimeUtils.formatDate((long)System.currentTimeMillis())));
            for (ConnectionInfo ci : this.pool.values()) {
                log.info((Object)("connection " + ci.getConnection().toString() + " inUse=" + ci.inUse + " last accessed=" + DateTimeUtils.formatDate((long)ci.lastAccessed)));
            }
            log.info((Object)"---- end of dump ---");
        }

        protected synchronized void cleanupIdleConnections(long maxIdleTime) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"cleaning up idle database connections");
            }
            Iterator<ConnectionInfo> it = this.pool.values().iterator();
            while (it.hasNext()) {
                ConnectionInfo ci = it.next();
                if (ci.inUse || maxIdleTime <= 0L || System.currentTimeMillis() - ci.lastAccessed < maxIdleTime) continue;
                try {
                    ci.getConnection().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                it.remove();
                log.info((Object)("removing idle DB connection " + ci));
            }
            if (this.dumpStats) {
                this.dumpPoolStatus();
            }
        }

        public synchronized void shutdown() {
            for (ConnectionInfo ci : this.pool.values()) {
                try {
                    ci.getConnection().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class PoolCleanup
    implements Runnable {
        protected NamedUserPool pool;
        protected long maxIdleTime;
        protected long checkInterval;

        public PoolCleanup(NamedUserPool pool, long maxIdleTime, long checkInterval) {
            this.maxIdleTime = maxIdleTime;
            this.checkInterval = checkInterval;
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = this;
                synchronized (object) {
                    try {
                        this.wait(this.checkInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                object = this.pool;
                synchronized (object) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Doing scheduled named user pool cleanup!");
                    }
                    for (NamedUser nu : this.pool.namedUserMap.values()) {
                        nu.cleanupIdleConnections(this.maxIdleTime);
                    }
                }
            }
        }
    }
}

