/*
 * Decompiled with CFR 0.152.
 */
package clinical.web;

import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.DAOFactory;
import clinical.web.ISQLDialect;
import clinical.web.common.UserInfo;
import clinical.web.common.query.OracleSQLDialect;
import clinical.web.common.query.PostgresSQLDialect;
import clinical.web.common.security.DBConfig;
import clinical.web.exception.DBPoolServiceException;
import clinical.web.services.AppConfigService;
import clinical.web.services.DBPoolService;
import clinical.web.services.SimpleSecurityService;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class ConnectionSupportMixin {
    protected Properties props;
    protected DBPoolService dbPoolService;
    protected UserInfo ui;
    protected String dbID;
    protected String dbType;
    protected boolean skipQueryProcessorCache = false;
    protected String[] dbIDs;
    protected ISQLDialect sqlDialect;
    protected String usersFile;
    protected InputStream is;
    protected boolean doPrepareTableCache = true;

    public ConnectionSupportMixin(String propsFile, boolean skipQueryProcessorCache) throws IOException {
        this.skipQueryProcessorCache = skipQueryProcessorCache;
        this.props = GenUtils.loadProperties(propsFile);
    }

    public ConnectionSupportMixin(String usersXmlFile) throws IOException {
        this.is = ConnectionSupportMixin.class.getClassLoader().getResourceAsStream(usersXmlFile);
    }

    public void startup() throws Exception {
        System.out.println("---- startup --------");
        String adminUser = null;
        String adminPwd = null;
        System.out.println("Creating cache manager");
        CacheManager.create();
        SimpleSecurityService secService = null;
        if (this.props != null) {
            String driverClass = this.props.getProperty("fbirn.driver_class");
            Class.forName(driverClass);
            this.usersFile = this.props.getProperty("fbirn.users_file");
            adminUser = this.props.getProperty("fbirn.admin_user");
            adminPwd = this.props.getProperty("fbirn.admin_pwd");
            this.dbID = this.props.getProperty("fbirn.dbid");
            secService = SimpleSecurityService.getInstance(this.usersFile);
        } else if (this.is != null) {
            secService = SimpleSecurityService.getInstance(this.is);
            this.dbID = secService.getDefaultDBID();
            DBConfig dbConfig = secService.getDBConfig(this.dbID);
            adminUser = "admin";
            adminPwd = dbConfig.findUser("admin").getPwd();
        }
        this.dbIDs = secService.getAllDBIDs();
        String defaultDBID = secService.getDefaultDBID();
        this.dbType = secService.getDBConfig(defaultDBID).getDbType();
        if (this.dbType.equals("oracle")) {
            this.sqlDialect = new OracleSQLDialect();
        } else if (this.dbType.equals("postgres")) {
            this.sqlDialect = new PostgresSQLDialect();
        } else {
            throw new RuntimeException("Not a supported database dialect:" + this.dbType);
        }
        System.out.println("getting pool service...");
        this.dbPoolService = DBPoolService.getInstance(secService, secService.getDBConfigMap());
        System.out.println("got pool service...");
        DAOFactory.bootstrap();
        Map<String, String> dbID2SiteIDMap = Collections.synchronizedMap(new HashMap(17));
        DBPoolService poolService = null;
        Iterator<DBConfig> iterator = secService.getDBConfigMap().values().iterator();
        while (iterator.hasNext()) {
            DBConfig element;
            DBConfig dbConfig = element = iterator.next();
            poolService = DBPoolService.getInstance(dbConfig.getId());
            poolService.startup();
            if (dbConfig.getId().equals(defaultDBID)) {
                AppConfigService.getInstance(poolService, defaultDBID);
            }
            dbID2SiteIDMap.put(dbConfig.getId(), dbConfig.getSiteID());
        }
        Cache cache = CacheManager.getInstance().getCache("remote");
        Element el = new Element((Object)"dbid2siteid.map", dbID2SiteIDMap);
        el.setEternal(true);
        cache.put(el);
        Iterator<DBConfig> iterator2 = secService.getDBConfigMap().values().iterator();
        while (iterator2.hasNext()) {
            DBConfig element;
            DBConfig dbConfig = element = iterator2.next();
            poolService = DBPoolService.getInstance(dbConfig.getId());
            if (!this.isDoPrepareTableCache()) continue;
            secService.prepareTableCache(dbConfig.getId());
        }
        this.ui = secService.authenticate(adminUser, adminPwd, this.dbID);
        System.out.println("------------ end startup -----------------");
    }

    public void shutdown() throws Exception {
        if (this.dbPoolService != null) {
            try {
                this.dbPoolService.shutdown();
                this.dbPoolService = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FileUtils.close(this.is);
    }

    public DBPoolService getDbPoolService() {
        return this.dbPoolService;
    }

    public String getDbID() {
        return this.dbID;
    }

    public String[] getDbIDs() {
        return this.dbIDs;
    }

    public UserInfo getUi() {
        return this.ui;
    }

    public String getProperty(String propName) {
        return this.props.getProperty(propName);
    }

    public Connection getConnection() throws DBPoolServiceException {
        return this.dbPoolService.getConnection(this.ui.getName());
    }

    public void releaseConnection(Connection con) throws DBPoolServiceException {
        this.dbPoolService.releaseConnection(this.ui.getName(), con);
    }

    public ISQLDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public String getUsersFile() {
        return this.usersFile;
    }

    public boolean isDoPrepareTableCache() {
        return this.doPrepareTableCache;
    }

    public void setDoPrepareTableCache(boolean doPrepareTableCache) {
        this.doPrepareTableCache = doPrepareTableCache;
    }

    public String getDbType() {
        return this.dbType;
    }
}

