/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.util.CloseUtils;
import org.dcm4che2.util.StringUtils;
import org.dcm4che2.util.TagUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXWriter
implements DicomInputHandler {
    private static final int CBUF_LENGTH = 512;
    private final char[] cbuf = new char[512];
    private ContentHandler ch;
    private LexicalHandler lh;
    private File baseDir;
    private int baseOff;
    private File file;
    private int[] exclude;
    private boolean seenFirst = false;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public SAXWriter(ContentHandler ch, LexicalHandler lh) {
        this.ch = ch;
        this.lh = lh;
    }

    public final File getBaseDir() {
        return this.baseDir;
    }

    public final void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        this.baseOff = 0;
        if (baseDir != null) {
            String path = baseDir.getPath();
            this.baseOff = path.length();
            if (!path.endsWith(File.separator)) {
                ++this.baseOff;
            }
        }
    }

    public final int[] getExclude() {
        return this.exclude != null ? (int[])this.exclude.clone() : null;
    }

    public final void setExclude(int[] exclude) {
        if (exclude != null) {
            this.exclude = (int[])exclude.clone();
            Arrays.sort(exclude);
        } else {
            this.exclude = null;
        }
    }

    public void write(DicomObject attrs) throws SAXException, IOException {
        this.ch.startDocument();
        this.file = this.baseDir;
        this.writeContent(attrs, attrs.isRoot() ? "dicom" : "item");
        this.ch.endDocument();
    }

    private void writeContent(DicomObject attrs, String qName) throws SAXException, IOException {
        AttributesImpl atts = new AttributesImpl();
        if (!attrs.isRoot()) {
            atts.addAttribute("", "", "off", "", Long.toString(attrs.getItemOffset()));
        }
        this.ch.startElement("", "", qName, new AttributesImpl());
        Iterator<DicomElement> it = attrs.iterator();
        while (it.hasNext()) {
            this.writeElement(attrs, it.next());
        }
        this.ch.endElement("", "", qName);
    }

    private void writeElement(DicomObject attrs, DicomElement a) throws SAXException, IOException {
        VR vr = a.vr();
        int tag = a.tag();
        if (this.file != null) {
            this.file = new File(this.file, StringUtils.intToHex(tag));
        }
        String fpath = this.fpath(tag, vr, a.length());
        this.startAttributeElement(tag, vr, a.length(), fpath, attrs);
        if (a.hasItems()) {
            int n = a.countItems();
            for (int i = 0; i < n; ++i) {
                this.writeItem(a, i);
            }
        } else if (fpath != null) {
            this.writeToFile(a.getBytes());
        } else {
            vr.formatXMLValue(a.getBytes(), a.bigEndian(), attrs.getSpecificCharacterSet(), this.cbuf, this.ch);
        }
        this.endAttributeElement();
        if (this.file != null) {
            this.file = this.file.getParentFile();
        }
    }

    private void writeItem(DicomElement a, int index) throws SAXException, IOException {
        if (this.file != null) {
            this.file = new File(this.file, Integer.toString(index + 1));
        }
        if (a.vr() == VR.SQ) {
            this.writeContent(a.getDicomObject(index), "item");
        } else {
            byte[] data = a.getFragment(index);
            this.writeFragment(a.vr(), data, a.bigEndian(), this.fpath(a.tag(), a.vr(), data.length));
        }
        if (this.file != null) {
            this.file = this.file.getParentFile();
        }
    }

    private void writeFragment(VR vr, byte[] bytes, boolean bigEndian, String fpath) throws SAXException, IOException {
        this.startItemElement(-1L, bytes.length + 1 & 0xFFFFFFFE, fpath);
        if (fpath != null) {
            this.writeToFile(bytes);
        } else {
            vr.formatXMLValue(bytes, bigEndian, null, this.cbuf, this.ch);
        }
        this.endItemElement();
    }

    public boolean readValue(DicomInputStream in) throws IOException {
        try {
            switch (in.tag()) {
                case -73728: {
                    boolean isRoot;
                    boolean bl = isRoot = !this.seenFirst;
                    if (isRoot) {
                        this.seenFirst = true;
                        this.file = this.baseDir;
                        this.ch.startDocument();
                    }
                    this.transcodeItem(in);
                    if (isRoot) {
                        this.ch.endDocument();
                    }
                    break;
                }
                case -73715: {
                    in.readValue(in);
                    if (in.level() == 0) {
                        this.ch.endElement("", "", "dicom");
                        this.ch.endDocument();
                    }
                    break;
                }
                case -73507: {
                    in.readValue(in);
                    break;
                }
                default: {
                    if (!this.seenFirst) {
                        this.seenFirst = true;
                        this.file = this.baseDir;
                        this.ch.startDocument();
                        this.ch.startElement("", "", "dicom", new AttributesImpl());
                    }
                    this.transcodeAttribute(in);
                    break;
                }
            }
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
        return true;
    }

    private void transcodeItem(DicomInputStream in) throws SAXException, IOException {
        DicomElement sq = in.sq();
        int itemLen = in.valueLength();
        VR sqvr = sq.vr();
        int index = sq.countItems();
        if (this.file != null) {
            this.file = new File(this.file, Integer.toString(index + 1));
        }
        String fpath = this.fpath(sq.tag(), sqvr, itemLen);
        this.startItemElement(in.tagPosition(), itemLen, fpath);
        in.readValue(in);
        if (sqvr != VR.SQ) {
            byte[] data = sq.getFragment(index);
            if (fpath != null) {
                this.writeToFile(data);
            } else {
                boolean bigEndian = in.getTransferSyntax().bigEndian();
                sqvr.formatXMLValue(data, bigEndian, null, this.cbuf, this.ch);
            }
            sq.setFragment(index, EMPTY_BYTES);
        }
        this.endItemElement();
        if (this.file != null) {
            this.file = this.file.getParentFile();
        }
    }

    private void endItemElement() throws SAXException {
        this.ch.endElement("", "", "item");
    }

    private void startItemElement(long off, int itemLen, String fpath) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "off", "", Long.toString(off));
        atts.addAttribute("", "", "len", "", Integer.toString(itemLen));
        if (fpath != null) {
            atts.addAttribute("", "", "src", "", fpath);
        }
        this.ch.startElement("", "", "item", atts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(byte[] data) throws IOException {
        if (this.file == null) {
            return;
        }
        this.file.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(this.file);
        try {
            out.write(data);
        }
        finally {
            CloseUtils.safeClose(out);
        }
    }

    private void transcodeAttribute(DicomInputStream in) throws SAXException, IOException {
        int tag = in.tag();
        VR vr = in.vr();
        int vallen = in.valueLength();
        DicomObject attrs = in.getDicomObject();
        String tagHex = StringUtils.intToHex(tag);
        if (this.file != null) {
            this.file = new File(this.file, tagHex);
        }
        String fpath = this.fpath(tag, vr, vallen);
        this.startAttributeElement(tag, vr, vallen, fpath, attrs);
        if (vallen == -1 || vr == VR.SQ) {
            in.readValue(in);
            attrs.remove(tag);
        } else {
            byte[] val = in.readBytes(vallen);
            boolean bigEndian = in.getTransferSyntax().bigEndian();
            if (fpath != null) {
                this.writeToFile(val);
            } else {
                vr.formatXMLValue(val, bigEndian, attrs.getSpecificCharacterSet(), this.cbuf, this.ch);
            }
            if (tag == 524293 || tag == 131088 || TagUtils.isPrivateCreatorDataElement(tag)) {
                attrs.putBytes(tag, vr, val, bigEndian);
            }
            if (tag == 131072) {
                in.setEndOfFileMetaInfoPosition(in.getStreamPosition() + (long)vr.toInt(val, bigEndian));
            }
        }
        if (this.file != null) {
            this.file = this.file.getParentFile();
        }
        this.endAttributeElement();
    }

    private void endAttributeElement() throws SAXException {
        this.ch.endElement("", "", "attr");
    }

    private void startAttributeElement(int tag, VR vr, int vallen, String fpath, DicomObject attrs) throws SAXException {
        if (this.lh != null) {
            String name = attrs.nameOf(tag);
            this.lh.comment(name.toCharArray(), 0, name.length());
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "tag", "", StringUtils.intToHex(tag));
        atts.addAttribute("", "", "vr", "", vr.toString());
        atts.addAttribute("", "", "len", "", Integer.toString(vallen));
        if (fpath != null) {
            atts.addAttribute("", "", "src", "", fpath);
        }
        this.ch.startElement("", "", "attr", atts);
    }

    private String fpath(int tag, VR vr, int vallen) {
        return !this.exclude(tag, vr, vallen) ? null : (this.file == null ? "" : this.file.getPath().substring(this.baseOff).replace(File.separatorChar, '/'));
    }

    private boolean exclude(int tag, VR vr, int vallen) {
        return this.exclude != null && vallen > 0 && vr != VR.SQ && Arrays.binarySearch(this.exclude, tag) >= 0;
    }
}

