/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloseUtils {
    private static Logger LOG = LoggerFactory.getLogger(CloseUtils.class);

    public static void safeClose(Closeable object) {
        try {
            if (object != null) {
                object.close();
            }
        }
        catch (IOException e) {
            CloseUtils.log(object, e);
        }
    }

    public static void safeClose(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException e) {
            CloseUtils.log(socket, e);
        }
    }

    public static void safeClose(ServerSocket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException e) {
            CloseUtils.log(socket, e);
        }
    }

    public static void safeClose(ImageInputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            CloseUtils.log(is, e);
        }
    }

    private static void log(Object object, Exception e) {
        LOG.warn("error closing " + object.getClass().getName() + ": " + object.toString(), (Throwable)e);
    }
}

