package cbfbirn

import groovy.transform.ToString;
import groovy.xml.MarkupBuilder;

import java.io.File;
import java.text.SimpleDateFormat

import com.pixelmed.web.SeriesListRequestHandler;

class DubowitzUploadInputBuilder {
	def local2SubjectIDMap = [:]

	static class SubjectInfo {
		def localId
		def subjectId
		def gender
		def birthDate
		def condition
		def location
		def scanner = 'GE MEDICAL SYSTEMS SIGNA HDx fmri3te'

		def cviMap = [:]

		@Override
		public String toString() {
			String s = "SubjectInfo::[localId:$localId subjectId:$subjectId gender:$gender " +
					"birthDate:$birthDate condition:$condition location:$location\n" +
					"scanner:$scanner\nviList:\n"

			cviMap.each {
				s += "\t" + it.value.toString() + "\n"
			}
			s += "]";
			return s;
		}
	}

	static class CondVisits {
		def condition
		def localId
		def visitDate
		SubjectInfo parent
		def viList = []


		def boolean isEmpty() {
			return visitDate == null || localId == null
		}

		@Override
		public String toString() {
			String s = "CondVisits::[condition:$condition localId:$localId visitDate:$visitDate \nviList\n";
			viList.each { vi ->
				s += "\t" + vi.toString() + "\n"
			}
			s += "]";
			return s;
		}
	}

	static class VisitInfo {
		def mainCondition
		def subCondition
		def minconLoc
		def csfLoc
		def cbfLoc
		def anatDicomDirLoc
		def fieldMapDirLoc
		def visitDirLoc

		@Override
		public String toString() {
			return "VisitInfo::[mainCondition:$mainCondition subCondition:$subCondition " +
			"minconLoc: $minconLoc csfLoc:$csfLoc cbfLoc:$cbfLoc " +
			"anatDicomDirLoc:$anatDicomDirLoc fieldMapDirLoc:$fieldMapDirLoc " +
			"visitDirLoc:$visitDirLoc]"
		}
	}

	def loadCSV(File inCSVFile) {
		def siList = []
		def lines = []
		inCSVFile.text.eachLine { line, lineNo ->
			if (lineNo > 2 ) lines << line
		}
		def lineIdx = 0;
		def curMainCond = null
		def visitDateList = []
		def localIdList = []
		for (line in lines) {
			def toks = line.split(/,/);
			if (toks.length == 0)  continue;

			if (toks[0].length() > 0) {
				def tok1 = stripQuotes(toks[0]);
				print "$tok1\n"
				if (tok1 != 'Main Condition:') {
					curMainCond = tok1
					def i = 3
					while (i < toks.length) {
						def tok = stripQuotes(toks[i])
						if (tok.length() > 0) {
							visitDateList[ i - 3] = toDate(tok)
							localIdList[ i - 3] = tok
							if (curMainCond == 'LowO2RawCO2') {
								siList[i - 3].localId = tok
							}
						} else {
							visitDateList[ i - 3] = null
							localIdList[ i - 3] = null
						}
						i++
					}
					siList.each { si -> si.cviMap[curMainCond] = new CondVisits(condition:curMainCond, parent:si); }
				}
			}
			if (toks.length > 3) {
				if (toks[2].length() > 0) {
					def tok = stripQuotes(toks[2])
					print "$tok\n"
					if (tok == 'Age:') {
						def i = 3
						while (i < toks.length) {
							def age = toks[i].toInteger()
							// FIXME year changes
							// def birthYear = 2012 - age;
							def birthYear = 2013 - age;

							def birthDate = "01/01/" + birthYear;
							SubjectInfo si = new SubjectInfo(birthDate : birthDate);
							siList << si
							i++
						}
					} else if (tok == 'Gender:') {
						def i = 3
						while (i < toks.length) {
							SubjectInfo si = siList[i - 3]
							si.gender = stripQuotes(toks[i])
							i++
						}
					}
				} else {
					String sc = stripQuotes(toks[1])
					if (curMainCond != null && (sc.startsWith("Base") || sc.startsWith("Chng") )) {
						def i = 3
						while (i < toks.length) {
							SubjectInfo si = siList[i - 3]
							si.cviMap[curMainCond].visitDate = visitDateList[i - 3]
							si.cviMap[curMainCond].localId = localIdList[i - 3];
							//si.visitDate = visitDateList[i - 3]
							//si.localId = localIdList[i - 3]
							def loc = stripQuotes(toks[i]);
							VisitInfo vi = new VisitInfo(mainCondition : curMainCond, subCondition:sc, cbfLoc: loc)
							si.cviMap[curMainCond].viList << vi;
							// si.viList << vi
							i++
						}
					} else if (curMainCond != null) {
						def i = 3
						while (i < toks.length) {
							SubjectInfo si = siList[i - 3]

							def loc = stripQuotes(toks[i]);
							def viList = si.cviMap[curMainCond].viList
							for(VisitInfo vi in viList) {
								if (sc.startsWith('CSF')) {
									vi.csfLoc = loc;
								} else if (sc.startsWith('MinCon')) {
									vi.minconLoc = loc
								} else if (sc.startsWith('Fspgr')) {
									vi.anatDicomDirLoc = loc
								} else if (sc.startsWith('Field')) {
									vi.fieldMapDirLoc = loc
								}
							}
							i++
						}
					}
				}
			}
		}
		return siList
	}

	def prepRawDataDirs(File inRoot, File outRoot, siList, boolean skipCopy = false) {
		assert local2SubjectIDMap.size() > 0
		def map = [:]

		siList.each { si ->
			si.subjectId = local2SubjectIDMap[si.localId]
			si.cviMap.each {
				CondVisits cvi = it.value
				if (! cvi.isEmpty()) {
					map[cvi.localId] = cvi;
				}
			}
		}
		def sdList = []
		inRoot.eachDir {
			def sd = it.name
			if (map.containsKey(sd)) {
				sdList << it
			}
		}

		sdList.each { sd ->
			def sdName = sd.name
			def seriesList = []
			sd.eachFile {
				if (it.directory) {
					it.eachDir { d ->  seriesList << d }
				} else {
					seriesList << it
				}
			}
			seriesList.each { println it}
			def seriesMap = [:]
			seriesList.each {
				seriesMap[it.name ] = it
			}
			println "-" * 80
			CondVisits cvi = map[sdName]
			assert cvi != null

			for(VisitInfo vi : cvi.viList) {
				String vdName = sdName + '_' + vi.mainCondition + '_' +  vi.subCondition
				File destSubjectPath = new File(outRoot, vdName);
				destSubjectPath.mkdirs();
				vi.visitDirLoc = destSubjectPath

				String lastPart =  getLastPart(vi.fieldMapDirLoc)
				def srcDir = seriesMap[lastPart]
				File fmDir = new File(destSubjectPath, lastPart);
				File srcFmDir = new File(sd, vi.fieldMapDirLoc)
				println "fmDir:$fmDir"
				if (!skipCopy) {
					copyDir(srcDir, fmDir)
				}

				lastPart = getLastPart(vi.anatDicomDirLoc)
				srcDir = seriesMap[lastPart]
				File anatDir = new File(destSubjectPath, lastPart);
				File srcAnatDir = new File(sd, vi.anatDicomDirLoc)
				println "anatDir:$srcAnatDir"
				if (!skipCopy) {
					copyDir(srcAnatDir, anatDir)
				}
				def srcPFile = seriesMap[vi.cbfLoc];
				File destPFile = new File(destSubjectPath, vi.cbfLoc)
				println "cp $srcPFile $destPFile"
				if (!skipCopy) {
					copyFile(srcPFile, destPFile)
				}

				srcPFile = seriesMap[vi.csfLoc];
				destPFile = new File(destSubjectPath, vi.csfLoc)
				println "cp $srcPFile $destPFile"
				if (!skipCopy) {
					copyFile(srcPFile, destPFile)
				}

				srcPFile = seriesMap[vi.minconLoc];
				destPFile = new File(destSubjectPath, vi.minconLoc)
				println "cp $srcPFile $destPFile"
				if (!skipCopy) {
					copyFile(srcPFile, destPFile)
				}
			}
		}

		siList.each { println it }
	}




	def String getLastPart(String dirFrag) {
		def idx = dirFrag.indexOf('/');
		return dirFrag.substring(idx + 1)
	}

	def loadLocalId2SubjectIDMap(File cvsLookupFile) {
		cvsLookupFile.text.eachLine { line ->
			def toks = line.split(/,/)
			assert toks.size() == 2
			local2SubjectIDMap[toks[0]] = toks[1]
		}
	}

	static void copyDir(File src, File dest) {
		dest.mkdir();
		def srcFiles = []
		src.eachFile { if (it.isFile()) srcFiles << it }
		srcFiles.each { srcFile ->
			copyFile(srcFile, new File(dest, srcFile.name ));
		}
	}

	static void copyFile(File src, File dest) {
		new AntBuilder().copy(file:"$src.canonicalPath",tofile:"$dest.canonicalPath",overwrite:'true')
	}


	def writeXml(siList, File outFile) {
		assert local2SubjectIDMap.size() > 0
		def writer = new StringWriter()
		def xml = new MarkupBuilder(writer)
		xml.cbfImport() {
			for(si in siList) {
				def subjectID = local2SubjectIDMap[si.localId]
				def location = 'NA';
				for(cvi in si.cviMap.values()) {
					if (!cvi.isEmpty()) {
						for(vi in cvi.viList) {
							ds(subjectID:subjectID,  diagnosis:'Control', expName:'Dubowitz_R21_GasChange',
							visitDate:cvi.visitDate, birthDate:si.birthDate, gender: si.gender,
							scannerInfo: si.scanner, location: vi.visitDirLoc) {
								'as'(name:'Gas Conditions') {
									score(name:'mainCondition', value:vi.mainCondition)
									score(name:'subCondition', value:vi.subCondition)
								}
							}
						}
					}
				}
			}
		}
		println writer.toString()
		if (outFile != null) {
			writeFile(outFile, writer.toString())
		}
	}

	def static writeFile(File outFile, String content) {
		outFile.withWriter { out ->
			out.write(content); out.append("\n")
		}
		println "wrote file:$outFile"
	}

	static String toDate(String oddDateFormat) {
		def m = oddDateFormat =~ /\w+(\d\d\d\d)(\d\d)(\d\d)/
		return m[0][2] + "/" + m[0][3] + "/" + m[0][1]
	}

	static String stripQuotes(String csvVal) {
		if (csvVal.indexOf('"') == -1) return csvVal
		def m = csvVal =~ /"([^"]+)"/
		return m[0][1]
	}

	static void upload1() {
		File imageDataRoot = new File('/data/dshin/121203_dubowitz_r21')
		File rawDataUploadRoot = new File('/data/burak/dubowitz_r21')
		DubowitzUploadInputBuilder builder = new DubowitzUploadInputBuilder()

		def siList = builder.loadCSV(new File('/home/bozyurt/dev/java/clinical/scripts/dubowitz_project/GasChange_CBFBirn_Organization.csv'))

		builder.loadLocalId2SubjectIDMap(new File('/home/bozyurt/dev/java/clinical/scripts/dubowitz_project/birnid_map.csv'));

		builder.prepRawDataDirs(imageDataRoot, rawDataUploadRoot, siList)

		builder.writeXml(siList, new File('/home/bozyurt/dev/java/clinical/scripts/dubowitz_project/dubowitz_data_import.xml'))
	}

	static void upload2() {
		File imageDataRoot = new File('/data/burak/dubowitz_in')
		File rawDataUploadRoot = new File('/data/burak/dubowitz_out')
		DubowitzUploadInputBuilder builder = new DubowitzUploadInputBuilder()

		def siList = builder.loadCSV(new File('/home/bozyurt/GasChange_CBFBirn_Organization.csv'))
		
		siList = siList.grep{ it.localId == 'mindy20130305poic'}
		
		siList.each { println it }

		builder.loadLocalId2SubjectIDMap(new File('/home/bozyurt/dev/java/clinical/scripts/dubowitz_project/birnid_map.csv'));

		builder.prepRawDataDirs(imageDataRoot, rawDataUploadRoot, siList, true)
		builder.writeXml(siList, new File('/home/bozyurt/dev/java/clinical/scripts/dubowitz_project/dubowitz_data_import2.xml'))
	}
	
	static void upload3() {
		File imageDataRoot = new File('/data/burak/dubowitz_in2')
		File rawDataUploadRoot = new File('/data/burak/dubowitz_out2')
		DubowitzUploadInputBuilder builder = new DubowitzUploadInputBuilder()

		def siList = builder.loadCSV(new File('/home/bozyurt/GasChange_CBFBirn_Organization.csv'))
		
		siList = siList.grep{ it.localId == 'aaron20130401poic'}
		
		siList.each { println it }

		builder.loadLocalId2SubjectIDMap(new File('/home/bozyurt/dev/java/clinical/scripts/dubowitz_project/birnid_map.csv'));

		builder.prepRawDataDirs(imageDataRoot, rawDataUploadRoot, siList, false)
	    builder.writeXml(siList, new File('/home/bozyurt/dev/java/clinical/scripts/dubowitz_project/dubowitz_data_import3.xml'))
	}

	static void upload4() {
		File imageDataRoot = new File('/data/burak/dubowitz_in3')
		File rawDataUploadRoot = new File('/data/burak/dubowitz_out3')
		DubowitzUploadInputBuilder builder = new DubowitzUploadInputBuilder()

		def siList = builder.loadCSV(new File('/home/bozyurt/GasChange_cbfbirn.csv'))
		
		siList = siList.grep{ it.localId == 'david20121128poic'}
		
		siList.each { si ->
			def badCVIList = []
			si.cviMap.each { k,v ->
				if (v.visitDate == null) { badCVIList << k}
			}
			badCVIList.each { si.cviMap.remove(it) }
		}
		
		siList.each { println it }

		builder.loadLocalId2SubjectIDMap(new File('/home/bozyurt/dev/java/clinical/scripts/dubowitz_project/birnid_map.csv'));

	   builder.prepRawDataDirs(imageDataRoot, rawDataUploadRoot, siList, true)
	   builder.writeXml(siList, new File('/home/bozyurt/dev/java/clinical/scripts/dubowitz_project/dubowitz_data_import4.xml'))
	}


	static void main(args) {
		upload4();
	}
}
