package fbirn

class AssessmentChecker {
	def File imgDataRoot
	def File asDataRoot
	def expName
	
	def checkIfAllSubjectsHaveAssessments() {
		def asDataFiles = []
		asDataRoot.eachFile { f -> 
			if (f.file && f.name =~ /^as_data_$expName/) asDataFiles << f
		}
		def subjectMap = prepSubjectMap();
		def asSubjectMap = [:]
		for(xmlFile in asDataFiles) {
			def xml = new XmlSlurper().parse(xmlFile)
			xml.subjects[0].subjExp.each { se ->
				String sid = se.'@subjectid'
				asSubjectMap[sid] = sid
			}
		}
		println "subjects with image data " + subjectMap.size()
		//subjectMap.keySet().sort().each { println it }
		println "subjects with as data " + asSubjectMap.size()
		println '-' * 40
		//asSubjectMap.keySet().sort().each { println it }
		
		def missing = []
		def common = []
		for(sid in subjectMap.keySet()) {
			if (asSubjectMap[sid] == null) {
				missing << sid
			} else {
			   common << sid
			}
		}
		
		println "Subjects without assessment data"
		println '-' * 40
		missing.each { println it }
		
		println "Subjects with assessment data"
		println '-' * 40
		common.each { println it }
	}
	
	
	def prepSubjectMap() {
		def subjectMap = [:]
		imgDataRoot.eachFile { 
			if (it.directory && it.name =~ /\d{12}/) {
			    String sid = it.name
				subjectMap[sid] = sid
			}
		}
		return subjectMap
	}
	
	
	static void main(args) {
		def imgDataRoot = "/data/bozyurt/cbfbirn/upload/FBIRNSubject2007TW__0051"
		def asDataRoot = "/home/bozyurt/dev/java/clinical/scripts/results"
		
		AssessmentChecker ac = new AssessmentChecker(imgDataRoot:new File(imgDataRoot), asDataRoot:new File(asDataRoot), expName:'FBIRNSubject2007TW__0051')
		ac.checkIfAllSubjectsHaveAssessments()
	}
}
