package fbirn

import fbirn.db.AssessmentscoreDAO;
import fbirn.db.DBUtils;
import fbirn.util.GenUtils;
import fbirn.db.AssessmentDAO;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.ToString;
import groovy.sql.Sql;


class AssessmentUploader {
	def db
	def dbu
	
	@ToString(includeNames = true)
	@EqualsAndHashCode
	static class Assessment {
		def name
		def description
		def assessmentID
		def scores = [];
	}
	
	@ToString(includeNames = true)
	static class Score {
		def scorename
		def scoresequence
		def scoretype
		def scorelevel
		def nullable
		def assessmentontology
		def assessmentconcept
		def securityclassification
		def minanswers
		def maxanswers
		def isrequired
		def isexcluded
		def isnew
		def ismodified
		def description	
	}
	
	def loadAsMetaData(asMetaXmlFile) {
		def assessments = []
		def xml = new XmlSlurper().parse(asMetaXmlFile)
		xml.assessments[0].assessment.each { asEl ->
			Assessment assessment = new Assessment(name: asEl.'@name', 
				description:asEl.description.text(), assessmentID: asEl.'@assessmentid' )
			assessments << assessment
			asEl.scores[0].score.each { sc -> 
				Score s = new Score(scorename: sc.'@scorename', scoresequence: sc.'@scoresequence',
					scoretype: sc.'@scoretype', scorelevel : sc.'@scorelevel',
					nullable : sc.'@nullable', assessmentontology : sc.'@assessmentontology',
					assessmentconcept: sc.'@assessmentconcept', 
					securityclassification: sc.'@securityclassification',minanswers: sc.'@minanswers',
					maxanswers: sc.'@maxanswers', isrequired: sc.'@isrequired',
					isexcluded: sc.'@isexcluded', isnew: sc.'@isnew',
					ismodified: sc.'@ismodified', description: sc.description.text())
				assessment.scores << s
			}
		}
		assessments.each { println it }
	}
	
	def initializeDb() {
		def props = GenUtils.loadProperties("cbfbirn_test.properties");
		assert props
		def dbUrl = props.getProperty("db.url")
		println "dbURL:$dbUrl"
		db = Sql.newInstance(dbUrl,
				props.getProperty('db.user'),props.getProperty('db.pwd'),
				'org.postgresql.Driver')
		dbu = DBUtils.getDatabaseUser(db)
	}
	
	private def prepADAO() {
		def asDAO = new AssessmentDAO(db : db)
		asDAO.setOwner(dbu)
		return asDAO;
	}
	
	private def prepScoreDAO() {
		def dao = new AssessmentscoreDAO(db : db)
		dao.setOwner(dbu)
		return dao
	}

	
	static void main(args) {
		AssessmentUploader au = new AssessmentUploader()
		// au.loadAsMetaData('/home/bozyurt/dev/java/clinical/scripts/results/as_meta_fBIRNPhaseIII__0090_ucsd.xml')
	   au.initializeDb()	
	}
}
