#!/bin/sh
if [ "$CLINICAL_HOME" == "" ]
then
  CLINICAL_HOME=$HOME/dev/java/clinical
fi
if [ ! -d "$CLINICAL_HOME" ]
then
  echo ""
  echo "Cannot continue"
  echo "Please set the environment var CLINICAL_HOME to a valid directory:$CLINICAL_HOME"
  exit 1;
fi
if [ ! -d "$GROOVY_HOME" ]
then
  echo ""
  echo "Cannot continue"
  echo "Please set the environment var GROOVY_HOME to a valid directory:$GROOVY_HOME"
  exit 1;
fi


SCRIPT_HOME=$CLINICAL_HOME/scripts/cbfbirn
CP=$SCRIPT_HOME/bin
for lib in $GROOVY_HOME/lib/*.jar
do
    CP=${CP}:$lib
done

#CP=$CP:$GROOVY_HOME/embeddable/groovy-all-1.8.1.jar
CP=$CP:$CLINICAL_HOME/lib/postgresql-8.3-603.jdbc3.jar
CP=$CP:$SCRIPT_HOME/conf:.

#echo $CP

java -Xmx400M -cp $CP fbirn.ExpSubjectExtractor $*

