package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Executedtransformflow;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ExecutedtransformflowDAO implements
		clinical.server.dao.ExecutedtransformflowDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ExecutedtransformflowDAO() {}

	public void insert(Connection con, Executedtransformflow bean)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_EXECUTEDTRANSFORMFLOW ");
			buf
					.append(" (EXECUTEDTRANSFORMATIONID,ANALYSISID,COMPONENTID,PRIOREXECUTEDTRANSFORMID,STARTEXECUTEDTRANSFORMID) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 5; ++i) {
				buf.append('?');
				if (i < 4)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean
					.getExecutedtransformationid(), Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getAnalysisid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getComponentid(),
					Types.NUMERIC);
			ps.setObject(4, (java.math.BigDecimal) bean
					.getPriorexecutedtransformid(), Types.NUMERIC);
			ps.setObject(5, (java.math.BigDecimal) bean
					.getStartexecutedtransformid(), Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Executedtransformflow bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("EXECUTEDTRANSFORMATIONID");
		buf.append(',');
		buf.append("ANALYSISID");
		buf.append(',');
		buf.append("COMPONENTID");
		buf.append(',');
		buf.append("PRIOREXECUTEDTRANSFORMID");
		buf.append(',');
		buf.append("STARTEXECUTEDTRANSFORMID");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Executedtransformflow bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getExecutedtransformationid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("EXECUTEDTRANSFORMATIONID=?");
			qi.values.add(bean.getExecutedtransformationid());
			valueSet = true;
		}
		if (bean.getAnalysisid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ANALYSISID=?");
			qi.values.add(bean.getAnalysisid());
			valueSet = true;
		}
		if (bean.getComponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COMPONENTID=?");
			qi.values.add(bean.getComponentid());
			valueSet = true;
		}
		if (bean.getPriorexecutedtransformid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PRIOREXECUTEDTRANSFORMID=?");
			qi.values.add(bean.getPriorexecutedtransformid());
			valueSet = true;
		}
		if (bean.getStartexecutedtransformid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("STARTEXECUTEDTRANSFORMID=?");
			qi.values.add(bean.getStartexecutedtransformid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Executedtransformflow bean,
			Executedtransformflow criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_EXECUTEDTRANSFORMFLOW SET ");

		if (bean.getExecutedtransformationid() != null
				|| bean.isNull("executedtransformationid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("EXECUTEDTRANSFORMATIONID=? ");
			uqi.setValues.add(bean.getExecutedtransformationid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("executedtransformationid"), uqi);
			valueSet = true;
		}
		if (bean.getAnalysisid() != null || bean.isNull("analysisid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ANALYSISID=? ");
			uqi.setValues.add(bean.getAnalysisid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("analysisid"), uqi);
			valueSet = true;
		}
		if (bean.getComponentid() != null || bean.isNull("componentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COMPONENTID=? ");
			uqi.setValues.add(bean.getComponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("componentid"), uqi);
			valueSet = true;
		}
		if (bean.getPriorexecutedtransformid() != null
				|| bean.isNull("priorexecutedtransformid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PRIOREXECUTEDTRANSFORMID=? ");
			uqi.setValues.add(bean.getPriorexecutedtransformid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("priorexecutedtransformid"), uqi);
			valueSet = true;
		}
		if (bean.getStartexecutedtransformid() != null
				|| bean.isNull("startexecutedtransformid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("STARTEXECUTEDTRANSFORMID=? ");
			uqi.setValues.add(bean.getStartexecutedtransformid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("startexecutedtransformid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Executedtransformflow createObject(ResultSet rs) throws SQLException {
		Executedtransformflow obj = new Executedtransformflow();
		obj.setExecutedtransformationid((java.math.BigDecimal) rs.getObject(1));
		obj.setAnalysisid((java.math.BigDecimal) rs.getObject(2));
		obj.setComponentid((java.math.BigDecimal) rs.getObject(3));
		obj.setPriorexecutedtransformid((java.math.BigDecimal) rs.getObject(4));
		obj.setStartexecutedtransformid((java.math.BigDecimal) rs.getObject(5));
		return obj;
	}

	public List<Executedtransformflow> find(Connection con,
			Executedtransformflow criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Executedtransformflow> results = new LinkedList<Executedtransformflow>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_EXECUTEDTRANSFORMFLOW ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Executedtransformflow item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Executedtransformflow bean,
			Executedtransformflow criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Executedtransformflow criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_EXECUTEDTRANSFORMFLOW ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
