package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Humansubject;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class HumansubjectDAO implements clinical.server.dao.HumansubjectDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public HumansubjectDAO() {
	}

	public void insert(Connection con, Humansubject bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_humansubject VALUES ");
			buf.append('(');
			for (int i = 0; i < 15; ++i) {
				buf.append('?');
				if (i < 14)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getSubjectid(), Types.VARCHAR);

			ps.setObject(2, bean.getTableid(), Types.NUMERIC);

			ps.setObject(3, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(4, bean.getOwner(), Types.NUMERIC);

			ps.setObject(5,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(6, bean.getModuser(), Types.NUMERIC);

			ps.setObject(7, bean.getExtensionname(), Types.VARCHAR);

			ps.setObject(8, bean.getNcAnimalspeciesUniqueid(), Types.NUMERIC);

			ps.setObject(9, bean.getLocalid(), Types.VARCHAR);

			ps.setObject(10, bean.getName(), Types.VARCHAR);

			ps.setObject(11,
					bean.getBirthdate() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getBirthdate()
									.getTime()));

			ps.setObject(12, bean.getSiteid(), Types.NUMERIC);

			ps.setObject(13, bean.getIsremote());

			ps.setObject(14, bean.getGender(), Types.VARCHAR);

			ps.setObject(15, bean.getCreator(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Humansubject bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("subjectid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("uniqueid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("extensionname");
		buf.append(',');
		buf.append("nc_animalspecies_uniqueid");
		buf.append(',');
		buf.append("localid");
		buf.append(',');
		buf.append("name");
		buf.append(',');
		buf.append("birthdate");
		buf.append(',');
		buf.append("siteid");
		buf.append(',');
		buf.append("isremote");
		buf.append(',');
		buf.append("gender");
		buf.append(',');
		buf.append("creator");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Humansubject bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("subjectid=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getExtensionname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("extensionname=?");
			qi.values.add(bean.getExtensionname());
			valueSet = true;
		}
		if (bean.getNcAnimalspeciesUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("nc_animalspecies_uniqueid=?");
			qi.values.add(bean.getNcAnimalspeciesUniqueid());
			valueSet = true;
		}
		if (bean.getLocalid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("localid=?");
			qi.values.add(bean.getLocalid());
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("name=?");
			qi.values.add(bean.getName());
			valueSet = true;
		}
		if (bean.getBirthdate() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("birthdate=?");
			qi.values.add(new java.sql.Date(bean.getBirthdate().getTime()));
			valueSet = true;
		}
		if (bean.getSiteid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("siteid=?");
			qi.values.add(bean.getSiteid());
			valueSet = true;
		}
		if (bean.getIsremote() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("isremote=?");
			qi.values.add(bean.getIsremote());
			valueSet = true;
		}
		if (bean.getGender() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("gender=?");
			qi.values.add(bean.getGender());
			valueSet = true;
		}
		if (bean.getCreator() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("creator=?");
			qi.values.add(bean.getCreator());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Humansubject bean,
			Humansubject criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_humansubject SET ");
		if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("subjectid=? ");
			uqi.setValues.add(bean.getSubjectid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("subjectid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getExtensionname() != null || bean.isNull("extensionname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("extensionname=? ");
			uqi.setValues.add(bean.getExtensionname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("extensionname"), uqi);
			valueSet = true;
		}
		if (bean.getNcAnimalspeciesUniqueid() != null
				|| bean.isNull("ncAnimalspeciesUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("nc_animalspecies_uniqueid=? ");
			uqi.setValues.add(bean.getNcAnimalspeciesUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncAnimalspeciesUniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getLocalid() != null || bean.isNull("localid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("localid=? ");
			uqi.setValues.add(bean.getLocalid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("localid"), uqi);
			valueSet = true;
		}
		if (bean.getName() != null || bean.isNull("name")) {
			if (valueSet)
				buf.append(", ");
			buf.append("name=? ");
			uqi.setValues.add(bean.getName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("name"), uqi);
			valueSet = true;
		}
		if (bean.getBirthdate() != null || bean.isNull("birthdate")) {
			if (valueSet)
				buf.append(", ");
			buf.append("birthdate=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getBirthdate()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("birthdate"), uqi);
			valueSet = true;
		}
		if (bean.getSiteid() != null || bean.isNull("siteid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("siteid=? ");
			uqi.setValues.add(bean.getSiteid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("siteid"), uqi);
			valueSet = true;
		}
		if (bean.getIsremote() != null || bean.isNull("isremote")) {
			if (valueSet)
				buf.append(", ");
			buf.append("isremote=? ");
			uqi.setValues.add(bean.getIsremote());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("isremote"), uqi);
			valueSet = true;
		}
		if (bean.getGender() != null || bean.isNull("gender")) {
			if (valueSet)
				buf.append(", ");
			buf.append("gender=? ");
			uqi.setValues.add(bean.getGender());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("gender"), uqi);
			valueSet = true;
		}
		if (bean.getCreator() != null || bean.isNull("creator")) {
			if (valueSet)
				buf.append(", ");
			buf.append("creator=? ");
			uqi.setValues.add(bean.getCreator());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("creator"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Humansubject createObject(ResultSet rs) throws SQLException {
		Humansubject obj = new Humansubject();
		obj.setSubjectid((String) rs.getObject(1));
		obj.setTableid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setUniqueid((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setOwner((rs.getObject(4) != null) ? new java.math.BigDecimal(rs
				.getObject(4).toString()) : null);
		obj.setModtime((rs.getObject(5) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(5)).getTime()) : null);
		obj.setModuser((rs.getObject(6) != null) ? new java.math.BigDecimal(rs
				.getObject(6).toString()) : null);
		obj.setExtensionname((String) rs.getObject(7));
		obj
				.setNcAnimalspeciesUniqueid((rs.getObject(8) != null) ? new java.math.BigDecimal(
						rs.getObject(8).toString())
						: null);
		obj.setLocalid((String) rs.getObject(9));
		obj.setName((String) rs.getObject(10));
		obj.setBirthdate((rs.getObject(11) != null) ? new java.util.Date(
				((java.sql.Date) rs.getObject(11)).getTime()) : null);
		obj.setSiteid((rs.getObject(12) != null) ? new java.math.BigDecimal(rs
				.getObject(12).toString()) : null);
		obj.setIsremote((Boolean) rs.getObject(13));
		obj.setGender((String) rs.getObject(14));
		obj.setCreator((String) rs.getObject(15));
		return obj;
	}

	public List<Humansubject> find(Connection con, Humansubject criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Humansubject> results = new LinkedList<Humansubject>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_humansubject ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Humansubject item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Humansubject bean, Humansubject criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Humansubject criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_humansubject ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
