package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Site;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class SiteDAO implements clinical.server.dao.SiteDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public SiteDAO() {}

	public void insert(Connection con, Site bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_SITE ");
			buf
					.append(" (UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,SITEID,SITENAME,ISPRIMARY,DATABASEADDRESS,DATABASENAME,DATABASEVENDOR,DATABASEVERSION,DATABASEPORT,CONTACTFIRSTNAME,CONTACTLASTNAME,CONTACTEMAIL,CONTACTPHONE) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 17; ++i) {
				buf.append('?');
				if (i < 16)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(4, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(5, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(6, (String) bean.getSiteid(), Types.VARCHAR);
			ps.setObject(7, (String) bean.getSitename(), Types.VARCHAR);
			ps.setObject(8, (java.math.BigDecimal) bean.getIsprimary(),
					Types.NUMERIC);
			ps.setObject(9, (String) bean.getDatabaseaddress(), Types.VARCHAR);
			ps.setObject(10, (String) bean.getDatabasename(), Types.VARCHAR);
			ps.setObject(11, (String) bean.getDatabasevendor(), Types.VARCHAR);
			ps.setObject(12, (String) bean.getDatabaseversion(), Types.VARCHAR);
			ps.setObject(13, (java.math.BigDecimal) bean.getDatabaseport(),
					Types.NUMERIC);
			ps.setObject(14, (String) bean.getContactfirstname(), Types.VARCHAR);
			ps.setObject(15, (String) bean.getContactlastname(), Types.VARCHAR);
			ps.setObject(16, (String) bean.getContactemail(), Types.VARCHAR);
			ps.setObject(17, (String) bean.getContactphone(), Types.VARCHAR);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Site bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("SITEID");
		buf.append(',');
		buf.append("SITENAME");
		buf.append(',');
		buf.append("ISPRIMARY");
		buf.append(',');
		buf.append("DATABASEADDRESS");
		buf.append(',');
		buf.append("DATABASENAME");
		buf.append(',');
		buf.append("DATABASEVENDOR");
		buf.append(',');
		buf.append("DATABASEVERSION");
		buf.append(',');
		buf.append("DATABASEPORT");
		buf.append(',');
		buf.append("CONTACTFIRSTNAME");
		buf.append(',');
		buf.append("CONTACTLASTNAME");
		buf.append(',');
		buf.append("CONTACTEMAIL");
		buf.append(',');
		buf.append("CONTACTPHONE");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Site bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getSiteid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SITEID=?");
			qi.values.add(bean.getSiteid());
			valueSet = true;
		}
		if (bean.getSitename() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SITENAME=?");
			qi.values.add(bean.getSitename());
			valueSet = true;
		}
		if (bean.getIsprimary() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISPRIMARY=?");
			qi.values.add(bean.getIsprimary());
			valueSet = true;
		}
		if (bean.getDatabaseaddress() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DATABASEADDRESS=?");
			qi.values.add(bean.getDatabaseaddress());
			valueSet = true;
		}
		if (bean.getDatabasename() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DATABASENAME=?");
			qi.values.add(bean.getDatabasename());
			valueSet = true;
		}
		if (bean.getDatabasevendor() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DATABASEVENDOR=?");
			qi.values.add(bean.getDatabasevendor());
			valueSet = true;
		}
		if (bean.getDatabaseversion() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DATABASEVERSION=?");
			qi.values.add(bean.getDatabaseversion());
			valueSet = true;
		}
		if (bean.getDatabaseport() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DATABASEPORT=?");
			qi.values.add(bean.getDatabaseport());
			valueSet = true;
		}
		if (bean.getContactfirstname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CONTACTFIRSTNAME=?");
			qi.values.add(bean.getContactfirstname());
			valueSet = true;
		}
		if (bean.getContactlastname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CONTACTLASTNAME=?");
			qi.values.add(bean.getContactlastname());
			valueSet = true;
		}
		if (bean.getContactemail() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CONTACTEMAIL=?");
			qi.values.add(bean.getContactemail());
			valueSet = true;
		}
		if (bean.getContactphone() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CONTACTPHONE=?");
			qi.values.add(bean.getContactphone());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Site bean, Site criteria)
			throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_SITE SET ");

		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getSiteid() != null || bean.isNull("siteid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SITEID=? ");
			uqi.setValues.add(bean.getSiteid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("siteid"), uqi);
			valueSet = true;
		}
		if (bean.getSitename() != null || bean.isNull("sitename")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SITENAME=? ");
			uqi.setValues.add(bean.getSitename());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("sitename"), uqi);
			valueSet = true;
		}
		if (bean.getIsprimary() != null || bean.isNull("isprimary")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISPRIMARY=? ");
			uqi.setValues.add(bean.getIsprimary());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isprimary"), uqi);
			valueSet = true;
		}
		if (bean.getDatabaseaddress() != null || bean.isNull("databaseaddress")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DATABASEADDRESS=? ");
			uqi.setValues.add(bean.getDatabaseaddress());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("databaseaddress"), uqi);
			valueSet = true;
		}
		if (bean.getDatabasename() != null || bean.isNull("databasename")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DATABASENAME=? ");
			uqi.setValues.add(bean.getDatabasename());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("databasename"), uqi);
			valueSet = true;
		}
		if (bean.getDatabasevendor() != null || bean.isNull("databasevendor")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DATABASEVENDOR=? ");
			uqi.setValues.add(bean.getDatabasevendor());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("databasevendor"), uqi);
			valueSet = true;
		}
		if (bean.getDatabaseversion() != null || bean.isNull("databaseversion")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DATABASEVERSION=? ");
			uqi.setValues.add(bean.getDatabaseversion());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("databaseversion"), uqi);
			valueSet = true;
		}
		if (bean.getDatabaseport() != null || bean.isNull("databaseport")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DATABASEPORT=? ");
			uqi.setValues.add(bean.getDatabaseport());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("databaseport"), uqi);
			valueSet = true;
		}
		if (bean.getContactfirstname() != null || bean.isNull("contactfirstname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CONTACTFIRSTNAME=? ");
			uqi.setValues.add(bean.getContactfirstname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("contactfirstname"), uqi);
			valueSet = true;
		}
		if (bean.getContactlastname() != null || bean.isNull("contactlastname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CONTACTLASTNAME=? ");
			uqi.setValues.add(bean.getContactlastname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("contactlastname"), uqi);
			valueSet = true;
		}
		if (bean.getContactemail() != null || bean.isNull("contactemail")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CONTACTEMAIL=? ");
			uqi.setValues.add(bean.getContactemail());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("contactemail"), uqi);
			valueSet = true;
		}
		if (bean.getContactphone() != null || bean.isNull("contactphone")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CONTACTPHONE=? ");
			uqi.setValues.add(bean.getContactphone());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("contactphone"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Site createObject(ResultSet rs) throws SQLException {
		Site obj = new Site();
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(1));
		obj.setTableid((java.math.BigDecimal) rs.getObject(2));
		obj.setOwner((java.math.BigDecimal) rs.getObject(3));
		if (rs.getTimestamp(4) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(4).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(5));
		obj.setSiteid((String) rs.getObject(6));
		obj.setSitename((String) rs.getObject(7));
		obj.setIsprimary((java.math.BigDecimal) rs.getObject(8));
		obj.setDatabaseaddress((String) rs.getObject(9));
		obj.setDatabasename((String) rs.getObject(10));
		obj.setDatabasevendor((String) rs.getObject(11));
		obj.setDatabaseversion((String) rs.getObject(12));
		obj.setDatabaseport((java.math.BigDecimal) rs.getObject(13));
		obj.setContactfirstname((String) rs.getObject(14));
		obj.setContactlastname((String) rs.getObject(15));
		obj.setContactemail((String) rs.getObject(16));
		obj.setContactphone((String) rs.getObject(17));
		return obj;
	}

	public List<Site> find(Connection con, Site criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Site> results = new LinkedList<Site>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_SITE ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Site item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Site bean, Site criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Site criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_SITE ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
