package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Token;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class TokenDAO implements clinical.server.dao.TokenDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public TokenDAO() {}

	public void insert(Connection con, Token bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_TOKEN ");
			buf.append(" (TOKEN,GROUPID,TIMECREATED,SERVED,EXPIRED) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 5; ++i) {
				buf.append('?');
				if (i < 4)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (String) bean.getToken(), Types.CHAR);
			ps.setObject(2, (java.math.BigDecimal) bean.getGroupid(),
					Types.NUMERIC);
			ps.setTimestamp(3, bean.getTimecreated() == null ? null
					: new java.sql.Timestamp(bean.getTimecreated().getTime()));
			ps.setObject(4, boolean2Number((Boolean) bean.getServed()),
					Types.NUMERIC);
			ps.setObject(5, boolean2Number((Boolean) bean.getExpired()),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Token bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("TOKEN");
		buf.append(',');
		buf.append("GROUPID");
		buf.append(',');
		buf.append("TIMECREATED");
		buf.append(',');
		buf.append("SERVED");
		buf.append(',');
		buf.append("EXPIRED");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Token bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getToken() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TOKEN=?");
			qi.values.add(bean.getToken());
			valueSet = true;
		}
		if (bean.getGroupid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("GROUPID=?");
			qi.values.add(bean.getGroupid());
			valueSet = true;
		}
		if (bean.getTimecreated() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TIMECREATED=?");
			qi.values.add(new java.sql.Timestamp(bean.getTimecreated().getTime()));
			valueSet = true;
		}
		if (bean.getServed() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SERVED=?");
			qi.values.add(boolean2Number((Boolean) bean.getServed()));
			valueSet = true;
		}
		if (bean.getExpired() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("EXPIRED=?");
			qi.values.add(boolean2Number((Boolean) bean.getExpired()));
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Token bean, Token criteria)
			throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_TOKEN SET ");

		if (bean.getToken() != null || bean.isNull("token")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TOKEN=? ");
			uqi.setValues.add(bean.getToken());
			uqi.sqlTypes.add(new Integer(Types.CHAR));
			prepareNullSetListValue(bean.isNull("token"), uqi);
			valueSet = true;
		}
		if (bean.getGroupid() != null || bean.isNull("groupid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("GROUPID=? ");
			uqi.setValues.add(bean.getGroupid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("groupid"), uqi);
			valueSet = true;
		}
		if (bean.getTimecreated() != null || bean.isNull("timecreated")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TIMECREATED=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getTimecreated()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("timecreated"), uqi);
			valueSet = true;
		}
		if (bean.getServed() != null || bean.isNull("served")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SERVED=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getServed()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("served"), uqi);
			valueSet = true;
		}
		if (bean.getExpired() != null || bean.isNull("expired")) {
			if (valueSet)
				buf.append(", ");
			buf.append("EXPIRED=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getExpired()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("expired"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true) : new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Token createObject(ResultSet rs) throws SQLException {
		Token obj = new Token();
		obj.setToken((String) rs.getObject(1));
		obj.setGroupid((java.math.BigDecimal) rs.getObject(2));
		if (rs.getTimestamp(3) != null) {
			obj.setTimecreated(new java.util.Date(rs.getTimestamp(3).getTime()));
		}
		obj.setServed(convert2Boolean(rs.getObject(4)));
		obj.setExpired(convert2Boolean(rs.getObject(5)));
		return obj;
	}

	public List<Token> find(Connection con, Token criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Token> results = new LinkedList<Token>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_TOKEN ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Token item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Token bean, Token criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Token criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_TOKEN ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
