package clinical.test;

import java.io.IOException;
import java.sql.*;

import junit.framework.TestSuite;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: DBPoolTest.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class DBPoolTest extends MyTestCase {

  public DBPoolTest(String testName, String propsFile) throws IOException {
    super(testName, propsFile);
  }



  public void testConnect() throws Exception {
    Connection con = null;
    Statement st = null;
    try {
      con = getDbPoolService().getConnection( getUi().getName());
      st = con.createStatement();
      st.executeQuery("SELECT 1 FROM DUAL");

    } finally {
      if (st != null) try { st.close(); } catch(Exception x) {}
      if (con != null)
    	  getDbPoolService().releaseConnection(getUi().getName(), con);
    }
  }
    public static TestSuite suite() throws IOException {
       TestSuite suite = new TestSuite();
       suite.addTest( new DBPoolTest("testConnect", "test.properties") );
       return suite;
     }

     public static void main(String[] args) throws IOException {
       junit.textui.TestRunner.run( suite() );
     }


}