package clinical.tools.dbadmin;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class RDAdminView extends JPanel implements PropertyChangeListener {
	private static final long serialVersionUID = 1L;
	AdminController ac;
	ListPanel lp;
	RDAdminPanel rdAdminPanel;
	DOAdminPanel doAdminPanel;
	JPanel adminPanel;
	List<String> colNames;
	Frame owner;

	public RDAdminView(AdminController ac, Frame owner) {
		this.ac = ac;
		this.owner = owner;
		setLayout(new BorderLayout(5, 5));
		colNames = new ArrayList<String>(10);
		colNames.add("dataid");
		colNames.add("objecttypeid");
		colNames.add("objectsize");

		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>(0);
		lp = new ListPanel(colNames, list);
		adminPanel = new JPanel(new BorderLayout(5, 5));
		JTabbedPane tabPane = new JTabbedPane();
		rdAdminPanel = new RDAdminPanel(ac, owner);
		rdAdminPanel.addPropertyChangeListener(this);

		lp.addPropertyChangeListener(rdAdminPanel);

		doAdminPanel = new DOAdminPanel(ac, owner);
		doAdminPanel.addPropertyChangeListener(this);
		JSplitPane sp = new JSplitPane(JSplitPane.VERTICAL_SPLIT, doAdminPanel,
				lp);
		sp.setOneTouchExpandable(true);
		sp.setDividerLocation(300);

		tabPane.addTab("Object Type Registration for ImageViewer", rdAdminPanel);
		tabPane.addTab("Object Type Registration for download", sp);

		add(tabPane, BorderLayout.CENTER);
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals("updateDO")) {
			System.out.println("received update property change event!");
			lp.updateModel(colNames, doAdminPanel.getAddedDORows());
		} else if (evt.getPropertyName().equals("updateRO")) {
			System.out.println("received update property change event!");
			lp.updateModel(colNames, rdAdminPanel.getAddedDORows());
		}
	}

}
