package clinical.tools.dbadmin;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jdom.Element;

import clinical.server.vo.Subjexperiment;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.web.ConnectionSupportMixin;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.services.SecurityService;
import clinical.web.vo.Visit;

public class UploadedDataSetsAdmin extends AbstractAdmin {
	// Set<CBFDataSeriesRecord>

	public UploadedDataSetsAdmin(String usersXmlFile) throws Exception {
		csm = new ConnectionSupportMixin(usersXmlFile);
		csm.startup();

		SecurityService ss = SecurityService.getInstance(
				csm.getDbPoolService(), csm.getDbID(), csm.getDbType());
		ss.startup();
	}

	public List<CBFDataSeriesRecord> loadDataImportXml(String dataImportXmlFile)
			throws Exception {
		List<CBFDataSeriesRecord> importRecList = new ArrayList<CBFDataSeriesRecord>();
		Element rootEl = FileUtils.loadXML(dataImportXmlFile);
		List<?> children = rootEl.getChildren("ds");
		for (Object o : children) {
			Element el = (Element) o;
			importRecList.add(CBFDataSeriesRecord.fromXml(el));
		}
		return importRecList;
	}

	Set<String> getUniqueExpNames(List<CBFDataSeriesRecord> cbfRecList) {
		Set<String> expNames = new HashSet<String>();
		for (CBFDataSeriesRecord rec : cbfRecList) {
			expNames.add(rec.getExperimentName());
		}
		return expNames;
	}

	public void getAllVisitsForExperiments(List<CBFDataSeriesRecord> recList)
			throws Exception {
		Set<String> expNames = getUniqueExpNames(recList);
		Map<String, CBFDataSeriesRecord> recMap = new LinkedHashMap<String, CBFDataSeriesRecord>();
		for (CBFDataSeriesRecord rec : recList) {
			String key = UploadedDataSetsAdmin.prepKey(rec.getExperimentName(),
					rec.getSubjectID(), rec.getVisitDate());
			CBFDataSeriesRecord aRec = recMap.get(key);
			Assertion.assertTrue(aRec == null);
			recMap.put(key, rec);
		}
		Set<String> seenKeySet = new HashSet<String>();
		Connection con = null;
		try {
			con = csm.getConnection();
			ISubjectVisitManagement svm = ServiceFactory
					.getSubjectVisitManagement(csm.getDbID());

			for (String expName : expNames) {
				List<Subjexperiment> seList = svm.getSubjectsForExperiment(
						csm.getUi(), expName);
				for (Subjexperiment se : seList) {
					List<Visit> visits = svm.getAllVisitsForSubject(
							csm.getUi(), se.getSubjectid());
					for (Visit v : visits) {
						System.out.println("subjectID:" + se.getSubjectid()
								+ " exp:" + expName + " visitDate:"
								+ v.getTimeStamp());
						String key = prepKey(expName, v.getSubjectID(),
								v.getTimeStamp());
						if (recMap.containsKey(key)) {
							seenKeySet.add(key);
						}
					}
				}
			}
			System.out.println("seenKeySet.size():" + seenKeySet.size());
			Element rootEl = new Element("completed");

			for (CBFDataSeriesRecord rec : recList) {
				String key = UploadedDataSetsAdmin.prepKey(
						rec.getExperimentName(), rec.getSubjectID(),
						rec.getVisitDate());
				if (seenKeySet.contains(key)) {

					rootEl.addContent(rec.toXml());
				}
			}

			File xmlFile = new File("/tmp/phase3_completed.xml");

			System.out.println("saving " + xmlFile);
			FileUtils.saveXML(rootEl, xmlFile.getAbsolutePath());

		} finally {
			csm.releaseConnection(con);
		}
	}

	public static String prepKey(String expName, String subjectID,
			String visitDate) {
		StringBuilder sb = new StringBuilder(100);
		sb.append(subjectID).append(':').append(expName).append(':')
				.append(visitDate);
		return sb.toString();
	}

	public static class CBFDataSeriesRecord {
		File locationDir;
		String subjectID;
		String experimentName;
		String visitDate;
		String scannerInfo;
		String birthDate;
		String gender;
		String experimentCondition; /* Diagnosis */

		public File getLocationDir() {
			return locationDir;
		}

		public void setLocationDir(File locationDir) {
			this.locationDir = locationDir;
		}

		public String getSubjectID() {
			return subjectID;
		}

		public void setSubjectID(String subjectID) {
			this.subjectID = subjectID;
		}

		public String getExperimentName() {
			return experimentName;
		}

		public void setExperimentName(String experimentName) {
			this.experimentName = experimentName;
		}

		public String getVisitDate() {
			return visitDate;
		}

		public void setVisitDate(String visitDate) {
			this.visitDate = visitDate;
		}

		public String getScannerInfo() {
			return scannerInfo;
		}

		public void setScannerInfo(String scannerInfo) {
			this.scannerInfo = scannerInfo;
		}

		public String getBirthDate() {
			return birthDate;
		}

		public void setBirthDate(String birthDate) {
			this.birthDate = birthDate;
		}

		public String getGender() {
			return gender;
		}

		public void setGender(String gender) {
			this.gender = gender;
		}

		public String getExperimentCondition() {
			return experimentCondition;
		}

		public void setExperimentCondition(String experimentCondition) {
			this.experimentCondition = experimentCondition;
		}

		public Element toXml() {
			Element el = new Element("ds");
			el.setAttribute("subjectID", subjectID);
			el.setAttribute("diagnosis", experimentCondition);
			el.setAttribute("expName", experimentName);
			el.setAttribute("visitDate", visitDate);
			el.setAttribute("birthDate", birthDate);
			el.setAttribute("gender", gender);
			el.setAttribute("scannerInfo", scannerInfo);
			el.setAttribute("location", locationDir.getAbsolutePath());
			return el;
		}

		public static CBFDataSeriesRecord fromXml(Element el) {
			CBFDataSeriesRecord r = new CBFDataSeriesRecord();
			r.subjectID = el.getAttributeValue("subjectID");
			r.experimentCondition = el.getAttributeValue("diagnosis");
			r.experimentName = el.getAttributeValue("expName");
			r.visitDate = el.getAttributeValue("visitDate");
			r.birthDate = el.getAttributeValue("birthDate");
			r.gender = el.getAttributeValue("gender");
			r.scannerInfo = el.getAttributeValue("scannerInfo");
			r.locationDir = new File(el.getAttributeValue("location"));
			return r;
		}

		public String toString() {
			StringBuilder sb = new StringBuilder(128);
			sb.append("[subjectID:").append(subjectID);
			sb.append(",expName:").append(experimentName);
			sb.append(",visitDate:").append(visitDate);
			sb.append(",scanner:").append(scannerInfo);
			sb.append(",birthDate:").append(birthDate);
			sb.append(",gender:").append(gender);
			sb.append(",diagnosis:").append(experimentCondition);
			sb.append("\n location:").append(locationDir);
			sb.append(']');
			return sb.toString();
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime
					* result
					+ ((experimentName == null) ? 0 : experimentName.hashCode());
			result = prime * result
					+ ((locationDir == null) ? 0 : locationDir.hashCode());
			result = prime * result
					+ ((subjectID == null) ? 0 : subjectID.hashCode());
			result = prime * result
					+ ((visitDate == null) ? 0 : visitDate.hashCode());
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			CBFDataSeriesRecord other = (CBFDataSeriesRecord) obj;
			if (experimentName == null) {
				if (other.experimentName != null)
					return false;
			} else if (!experimentName.equals(other.experimentName))
				return false;
			if (locationDir == null) {
				if (other.locationDir != null)
					return false;
			} else if (!locationDir.equals(other.locationDir))
				return false;
			if (subjectID == null) {
				if (other.subjectID != null)
					return false;
			} else if (!subjectID.equals(other.subjectID))
				return false;
			if (visitDate == null) {
				if (other.visitDate != null)
					return false;
			} else if (!visitDate.equals(other.visitDate))
				return false;
			return true;
		}
	}

	public static void main(String[] args) throws Exception {
		UploadedDataSetsAdmin admin = null;
		try {
			admin = new UploadedDataSetsAdmin("users.xml");

			List<CBFDataSeriesRecord> list = admin
					.loadDataImportXml("/home/bozyurt/dev/java/clinical/scripts/fbirn_import/phase3_import.xml");
			admin.getAllVisitsForExperiments(list);
		} finally {
			if (admin != null) {
				admin.shutdown();
			}
		}
	}
}
