package clinical.utils;

import java.util.Date;
import java.util.Properties;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */

public class NoPwdEmailSender implements IEmailSender{
	protected String from;
	protected Session session;
	private Log log = LogFactory.getLog(NoPwdEmailSender.class);

	public NoPwdEmailSender(String host, String fromUser, boolean debug) {
		this.from = fromUser;
		Properties props = new Properties();
		props.put("mail.debug", debug ? "true" : "false");
		props.put("mail.smtp.host", host);
		this.session = Session.getInstance(props);
		log.info("====> using NoPwdEmailSender");
	}
	
	public void sendMessage(String to, String subject, String content)
			throws MessagingException {
		log.info("SENDING message from " + from + " to " + to);
        System.out.println("SENDING message from " + from + " to " + to);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom(new InternetAddress(from));
        InternetAddress[] address = {new InternetAddress(to)};
        msg.setRecipients(Message.RecipientType.TO, address);
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        msg.setText(content);
        
        Transport.send(msg);
	}

}
