package clinical.web;


/**
 * @author I. Burak Ozyurt
 * @version $Id: IAppConfigService.java 384 2011-06-23 00:15:36Z bozyurt $
 */

public interface IAppConfigService {

	/**
	 * returns the value of an application configuration parameter
	 * @param name
	 * @return
	 */
	public String getParamValue(String name);
	
	/**
	 * for multivalued parameters
	 * @param name
	 * @return
	 */
	public String[] getParamValues(String name); 
	
	/**
	 * 
	 * @param name
	 * @param value
	 * @throws Exception
	 */
	public void updateParameter(String name, String value) throws Exception;
	
	public void reload() throws Exception;
}
