package clinical.web.actions;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jdom.Element;

import clinical.utils.FileUtils;
import clinical.web.IHelpService;
import clinical.web.ServiceFactory;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: HelpMessageAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class HelpMessageAction extends BaseAction {
	private Log log = LogFactory.getLog(HelpMessageAction.class);

	public HelpMessageAction() {
		super();
	}

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception
	{
		log.info("in HelpMessageAction");
		getUserInfo(request);
		String context = request.getParameter("context");
		
		response.setContentType("text/xml");
		IHelpService helpService = ServiceFactory.getHelpService();
		List<Element> msgList = helpService.getHelpMessages(context);
		Element rootElem = new Element("help-contents");
		for (Element msgElem : msgList) {
			rootElem.addContent(msgElem);
		}
		
		FileUtils.saveXML(rootElem, response.getOutputStream());
		
		return null;
	}

}
