package clinical.web.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.web.ServiceFactory;
import clinical.web.common.AssessmentMapping;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.query.Operator;
import clinical.web.common.query.ParallelQueryResult;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.exception.BaseException;
import clinical.web.helpers.SubCorticalVarInfo;
import clinical.web.services.SecurityService;
import clinical.web.vo.SubjectAsScoreValueSummary;
import clinical.web.vo.SubjectDerivedDataValueSummary;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: MultiSiteQueryHelper.java,v 1.11 2007/04/12 19:39:27 bozyurt
 *          Exp $
 */
public class MultiSiteQueryHelper {
   private static Log log = LogFactory.getLog(MultiSiteQueryHelper.class);

   public MultiSiteQueryHelper() {}

   protected static boolean isEnded(MultiSiteQueryWorker mqw) {
      return (mqw.getStatus() == MultiSiteQueryWorker.FINISHED || mqw
            .getStatus() == MultiSiteQueryWorker.ERROR);
   }

   protected static boolean endedWithError(MultiSiteQueryWorker mqw) {
      return (mqw.getStatus() == MultiSiteQueryWorker.ERROR);
   }

   protected static WorkerThreadInfo prepareAsQueryWorker(UserInfo ui,
         String dbID, String firstDBID,
         Map<Integer, List<AssessmentMapping>> siteAsMap, Operator asRoot,
         List<AssessmentSelectionInfo> asList, List<Integer> experimentIDs) {
      // TODO check if the change database ID in the last argument has any
      // side effects

      // MultiSiteQueryWorker worker = new MultiSiteQueryWorker(dbID,
      // MultiSiteQueryWorker.ASSESSMENT_QUERY, firstDBID);

      MultiSiteQueryWorker worker = new MultiSiteQueryWorker(dbID,
            MultiSiteQueryWorker.ASSESSMENT_QUERY, dbID);

      worker.addArgument(ui);
      worker.addArgument(dbID);
      worker.addArgument(firstDBID);
      worker.addArgument(siteAsMap);
      worker.addArgument(asRoot);
      worker.addArgument(asList);
      if (experimentIDs != null) {
         worker.addArgument(experimentIDs);
      }
      Thread thread = new Thread(worker);
      thread.setDaemon(true);
      thread.setPriority(Thread.NORM_PRIORITY - 1);
      return new WorkerThreadInfo(worker, thread);
   }

   protected static WorkerThreadInfo prepareSubcorticalQueryWorker(UserInfo ui,
         String dbID, List<SubCorticalVarInfo> derivedDataInfos,
         Operator derivedDataQueryOpRoot) {
      MultiSiteQueryWorker worker = new MultiSiteQueryWorker(dbID,
            MultiSiteQueryWorker.SUBCORTICAL_QUERY, dbID);

      worker.addArgument(ui);
      worker.addArgument(dbID);
      worker.addArgument(derivedDataInfos);
      worker.addArgument(derivedDataQueryOpRoot);
      Thread thread = new Thread(worker);
      thread.setDaemon(true);
      thread.setPriority(Thread.NORM_PRIORITY - 1);
      return new WorkerThreadInfo(worker, thread);
   }

   public static ParallelQueryResult doForkAndJoin(UserInfo ui, String dbID,
         Operator asRoot, List<AssessmentSelectionInfo> asList,
         Map<Integer, List<AssessmentMapping>> siteAsMap,
         List<Integer> experimentIDs) throws Exception {
      return doForkAndJoin(ui, dbID, asRoot, asList, siteAsMap, null, null,
            false, experimentIDs);
   }

   public static ParallelQueryResult doForkAndJoin(UserInfo ui, String dbID,
         Operator asRoot, List<AssessmentSelectionInfo> asList,
         Map<Integer, List<AssessmentMapping>> siteAsMap,
         List<SubCorticalVarInfo> derivedDataInfos,
         Operator derivedDataQueryOpRoot, List<Integer> experimentIDs)
         throws Exception {
      return doForkAndJoin(ui, dbID, asRoot, asList, siteAsMap,
            derivedDataInfos, derivedDataQueryOpRoot, false, experimentIDs);
   }

   @SuppressWarnings("unchecked")
   public static ParallelQueryResult doForkAndJoin(UserInfo ui, String dbID,
         Operator asRoot, List<AssessmentSelectionInfo> asList,
         Map<Integer, List<AssessmentMapping>> siteAsMap,
         List<SubCorticalVarInfo> derivedDataInfos,
         Operator derivedDataQueryOpRoot, boolean runSerial,
         List<Integer> experimentIDs) throws Exception {
      boolean doDerivedDataQuery = derivedDataInfos != null;

      ISecurityService isec = ServiceFactory.getSecurityService();
      IAuthenticationService authService = ServiceFactory
            .getAuthenticationService();
      String[] allDBIDs = isec.getAllDBIDs();
      List<String> allBirnDBIDs = new ArrayList<String>();
      for (int i = 0; i < allDBIDs.length; i++) {
         allBirnDBIDs.add(allDBIDs[i]);
      }

      int numThreads = (doDerivedDataQuery) ? 2 * allBirnDBIDs.size()
            : allBirnDBIDs.size();
      WorkerThreadInfo[] wtInfos = new WorkerThreadInfo[numThreads];

      int idx = 0;
      for (Iterator<String> iter = allBirnDBIDs.iterator(); iter.hasNext();) {
         String aDBID = iter.next();
         UserInfo ui2 = authService.getDefaultUser(aDBID, ui);
         wtInfos[idx] = prepareAsQueryWorker(ui2, aDBID, dbID, siteAsMap,
               asRoot, asList, experimentIDs);
         if (runSerial) {
            wtInfos[idx].getWorker().run();
         } else {
            wtInfos[idx].getThread().start();
         }
         ++idx;
      }

      if (doDerivedDataQuery) {
         for (Iterator<String> iter = allBirnDBIDs.iterator(); iter.hasNext();) {
            String aDBID = iter.next();
            UserInfo ui2 = authService.getDefaultUser(aDBID, ui);
            wtInfos[idx] = prepareSubcorticalQueryWorker(ui2, aDBID,
                  derivedDataInfos, derivedDataQueryOpRoot);
            if (runSerial) {
               wtInfos[idx].getWorker().run();
            } else {
               wtInfos[idx].getThread().start();
            }
            ++idx;
         }
      }

      for (int i = 0; i < wtInfos.length; i++) {
         try {
            wtInfos[i].getThread().join();
         } catch (InterruptedException ie) {
            log.error("", ie);
         }
      }

      // now consolidate the results from the parallel queries

      // first check for errors
      List<WorkerThreadInfo> successfulAsQueryWorkers = new LinkedList<WorkerThreadInfo>();
      List<WorkerThreadInfo> successfulSubCortQueryWorkers = new LinkedList<WorkerThreadInfo>();
      BaseException be = new BaseException();
      for (int i = 0; i < allBirnDBIDs.size(); i++) {
         if (endedWithError(wtInfos[i].getWorker())) {
            be.addException(wtInfos[i].getWorker().getException());
            log.error("", wtInfos[i].getWorker().getException());
         } else {
            successfulAsQueryWorkers.add(wtInfos[i]);
         }
      }

      if (successfulAsQueryWorkers.isEmpty()) {
         throw be;
      }

      if (doDerivedDataQuery) {
         BaseException be2 = new BaseException();
         for (int i = allBirnDBIDs.size(); i < 2 * allBirnDBIDs.size(); i++) {
            if (endedWithError(wtInfos[i].getWorker())) {
               be2.addException(wtInfos[i].getWorker().getException());
               log.error("", wtInfos[i].getWorker().getException());
            } else {
               successfulSubCortQueryWorkers.add(wtInfos[i]);
            }
         }

         if (successfulSubCortQueryWorkers.isEmpty()) {
            throw be2;
         }
      }

      log.info("parallel queries are finished.");
      List<SubjectAsScoreValueSummary> summaryList = new LinkedList<SubjectAsScoreValueSummary>();
      List<SubjectDerivedDataValueSummary> filteredDerivedDataSummaryList = new LinkedList<SubjectDerivedDataValueSummary>();
      for (Iterator<WorkerThreadInfo> iter = successfulAsQueryWorkers
            .iterator(); iter.hasNext();) {
         WorkerThreadInfo wti = iter.next();
         // adds site id to the clinical query results
         List<SubjectAsScoreValueSummary> list = addSiteIdToData(
               (List<SubjectAsScoreValueSummary>) wti.getWorker().getResult(),
               wti.getWorker().getID());

         summaryList.addAll(list);
         wti = null;
      }
      if (doDerivedDataQuery) {
         List<SubjectDerivedDataValueSummary> derivedDataSummaryList = new LinkedList<SubjectDerivedDataValueSummary>();
         for (Iterator<WorkerThreadInfo> iter = successfulSubCortQueryWorkers
               .iterator(); iter.hasNext();) {
            WorkerThreadInfo wti = iter.next();
            derivedDataSummaryList.addAll((Collection<? extends SubjectDerivedDataValueSummary>) wti.getWorker()
                  .getResult());
            wti = null;
         }
         List<String> uniqueSubjectIds = getUniqueSubjectIds(summaryList);
         Map<String, String> sidMap = new HashMap<String, String>();
         for (Iterator<String> iter = uniqueSubjectIds.iterator(); iter
               .hasNext();) {
            String subjectID = iter.next();
            sidMap.put(subjectID, subjectID);
         }

         for (SubjectDerivedDataValueSummary sddvs : derivedDataSummaryList) {
            if (sidMap.get(sddvs.getSubjectID()) != null) {
               filteredDerivedDataSummaryList.add(sddvs);
            }
         }
         derivedDataSummaryList = null;
      }

      return new ParallelQueryResult(summaryList,
            filteredDerivedDataSummaryList);
   }

   protected static List<SubjectAsScoreValueSummary> addSiteIdToData(
         List<SubjectAsScoreValueSummary> summaryList, String dbID)
         throws BaseException {
      SecurityService ss = (SecurityService) ServiceFactory
            .getSecurityService();
      String siteID = ss.getSiteID(dbID);

      // String siteID = GenUtils.extractSiteID(dbID);

      for (SubjectAsScoreValueSummary savs : summaryList) {
         savs.setSiteID(siteID);
      }
      return summaryList;
   }

   public static List<String> getUniqueSubjectIds(
         List<SubjectAsScoreValueSummary> summaryList) {
      List<String> sids = null;
      Map<String, String> sidMap = new TreeMap<String, String>();
      for (SubjectAsScoreValueSummary sasv : summaryList) {
         if (sidMap.get(sasv.getSubjectID()) == null) {
            sidMap.put(sasv.getSubjectID(), sasv.getSubjectID());
         }
      }
      sids = new ArrayList<String>(sidMap.size());
      for (Iterator<String> iter = sidMap.values().iterator(); iter.hasNext();) {
         String sid = iter.next();
         sids.add(sid);
      }
      return sids;
   }

   public static class WorkerThreadInfo {
      MultiSiteQueryWorker worker;
      Thread thread;

      public WorkerThreadInfo(MultiSiteQueryWorker worker, Thread thread) {
         this.worker = worker;
         this.thread = thread;
      }

      public MultiSiteQueryWorker getWorker() {
         return this.worker;
      }

      public Thread getThread() {
         return this.thread;
      }
   }
}
