package clinical.web.actions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.exolab.castor.xml.ValidationException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.cache.CacheUtils;
import clinical.server.vo.Experiment;
import clinical.server.vo.JobFilter;
import clinical.utils.Assertion;
import clinical.utils.DateTimeUtils;
import clinical.utils.FileUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ICBFProcReportQueryService;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.common.UserInfo;
import clinical.web.common.security.User;
import clinical.web.common.vo.CBFProcessReportRec;
import clinical.web.common.vo.CBFProcessReportRecListWrapper;
import clinical.web.common.vo.Factor;
import clinical.web.forms.PostprocessCBFJobForm;
import clinical.web.forms.PostprocessCBFJobForm.WizardPageState;
import clinical.web.helpers.CBFROIGroupAnalysisHelper;
import clinical.web.scheduler.IJob;
import clinical.web.scheduler.JobScheduler;
import clinical.web.scheduler.JobScheduler.JobSubmissionType;
import clinical.web.services.AppConfigService;
import clinical.web.services.ICBFROIGroupAnalysisService;
import clinical.web.services.ICBFSearchService;
import clinical.web.services.ICBFStandardSpaceGroupAnalysisService;
import clinical.web.services.IGroupCBFReportQueryService;
import clinical.web.services.IJobFilterManagementService;
import clinical.web.vo.CBFQueryMetaData;
import clinical.web.vo.CBFROIJobAssociation;
import clinical.web.vo.CBFROIJobAssociation.JobVisitInfo;
import clinical.web.vo.FactorRepeatedMeasureInfo;
import clinical.web.vo.GroupAnalysisCBFJobInfo;
import clinical.web.workflow.cbf.group.BaselineGroupAnalysisJob;
import clinical.web.workflow.cbf.group.GroupAnalysisContext;
import clinical.web.workflow.cbf.group.GroupAnalysisJob;
import clinical.web.workflow.cbf.group.GroupROIAnalysisContext;
import clinical.web.workflow.cbf.group.GroupROIAnalysisJob;
import clinical.web.workflow.common.JSONUtils;
import clinical.web.workflow.common.WFGenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class PostProcessCBFJobAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(23);
	private Log log = LogFactory.getLog(PostProcessCBFJobAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.postprocess.cbfjob.view", "viewMain");
		map.put("action.postprocess.cbfjob.collectrois", "collectROIs");
		map.put("action.postprocess.cbfjob.submitjob", "submitJob");
		map.put("action.postprocess.cbfjob.filter", "filterResults");
		map.put("action.postprocess.cbfjob.scorevals", "getDistinctScoreValues");
		map.put("action.postprocess.cbfjob.provvals",
				"getDistinctProvParamValues");
		map.put("action.postprocess.cbfjob.submit.ssjob",
				"submitStandardSpaceGroupAnalysisJob");
		map.put("action.postprocess.cbfjob.submit.bljob",
				"submitBaselineGroupAnalysisJob");
		map.put("action.postprocess.cbfjob.scf", "showCollectFactors");
		map.put("action.postprocess.cbfjob.savejf", "saveJobFilter");
		map.put("action.postprocess.cbfjob.getjfs", "getJobFilters");

		map.put("action.postprocess.cbfjob.snscf",
				"showNativeSpaceCollectFactors");
		map.put("action.postprocess.cbfjob.back", "goBack");
		return map;
	}

	public ActionForward goBack(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("goBack");
		try {
			getUserInfo(request);
			PostprocessCBFJobForm ppForm = (PostprocessCBFJobForm) form;

			WizardPageState curPage = ppForm.getCurPage();
			if (curPage == WizardPageState.ASSOCIATE
					|| curPage == WizardPageState.COLLECT_FACTOR) {
				return mapping.findForward(Constants.SUCCESS);
			} else if (curPage == WizardPageState.COLLECT_NS_FACTOR) {
				return mapping.findForward(Constants.ASSOCIATE);
			} else {
				return mapping.findForward(Constants.SUCCESS);
			}
		} catch (Exception x) {
			log.error("viewMain", x);
			return super.processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("view");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			PostprocessCBFJobForm ppForm = (PostprocessCBFJobForm) form;

			ppForm.setSelectedJobsItems(null);

			ISubjectVisitManagement isvm = ServiceFactory
					.getSubjectVisitManagement(dbID);
			List<Experiment> allVisibleExperiments = isvm
					.getAllVisibleExperiments(ui);

			ICBFProcReportQueryService icrqs = ServiceFactory
					.getCBFProcReportQueryService(dbID);

			CBFProcessReportRecListWrapper resultSet = icrqs
					.getCBFProcessRecords(ui, allVisibleExperiments);

			ppForm.setWrapper(resultSet);
			if (resultSet.getRecords().isEmpty()) {
				ppForm.setHasData(false);
			} else {
				ppForm.setHasData(true);
			}

			JSONObject jobsJS = prepareJobSelectionDropdownData(resultSet);

			ppForm.setJobListJSON(jobsJS.toString());

			// query panel
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			ICBFSearchService ss = ServiceFactory.getCBFSearchService(dbID);
			CBFQueryMetaData metaData = ss.getMetadataQuery(ui, primarySiteID,
					PrivilegeLabel.UPDATE);

			JSONObject js = metaData.toJSON();
			ppForm.setQueryMetaDataJSON(js.toString());

			ppForm.setCurPage(WizardPageState.VIEW);
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return super.processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward showNativeSpaceCollectFactors(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> showNativeSpaceCollectFactors");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			PostprocessCBFJobForm ppForm = (PostprocessCBFJobForm) form;

			String gaName = request.getParameter("gaName");
			if (gaName != null) {
				ppForm.setGaName(gaName);
			}

			String userJobRoiAssocJSON = ppForm.getUserJobRoiAssocJSON();

			List<CBFROIJobAssociation> finalAssocList = CBFROIGroupAnalysisHelper
					.prepFromAssociationResults(userJobRoiAssocJSON,
							ppForm.getRoiJobAssocList());
			ppForm.setFinalRoiJobAssocList(finalAssocList);

			List<JobVisitInfo> jviList = prepJobVisitInfoList(finalAssocList);

			IGroupCBFReportQueryService grqs = ServiceFactory
					.getGroupCBFReportQueryService(dbID);

			List<FactorRepeatedMeasureInfo> eligibleFactors = grqs
					.getEligibleFactors(ui, jviList);
			System.out.println("Eligible Factors:");
			for (FactorRepeatedMeasureInfo frmi : eligibleFactors) {
				System.out.println(frmi.getFactor());
			}

			ppForm.setFrmiList(eligibleFactors);

			ppForm.setCurPage(WizardPageState.COLLECT_NS_FACTOR);
			return mapping.findForward(Constants.GA_SEL_FACTORS);
		} catch (Exception x) {
			log.error("showNativeSpaceCollectFactors", x);
			return super.processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward showCollectFactors(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> showCollectFactors");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			PostprocessCBFJobForm ppForm = (PostprocessCBFJobForm) form;

			String[] selectedJobsItems = request
					.getParameterValues("selectedJobs"); // "jobSelector"

			if (selectedJobsItems == null || selectedJobsItems.length == 0) {
				throw new ValidationException("No CBF job is selected!");
			}

			ppForm.setSelectedJobsItems(selectedJobsItems);

			String gaName = request.getParameter("gaName");
			if (gaName != null) {
				ppForm.setGaName(gaName);
			}

			List<CBFProcessReportRec> cbfRecList = prepareSelectedProcessReportRecs(
					ppForm.getWrapper(), selectedJobsItems);
			ppForm.setSelectedCbfRecList(cbfRecList);

			ICBFStandardSpaceGroupAnalysisService ssgaService = ServiceFactory
					.getCBFStandardSpaceGroupAnalysisService(dbID);

			List<GroupAnalysisCBFJobInfo> gajiList = ssgaService
					.toGroupAnalysisJobInfoList(ui, cbfRecList);

			IGroupCBFReportQueryService grqs = ServiceFactory
					.getGroupCBFReportQueryService(dbID);

			List<JobVisitInfo> jviList = getAllJobVisitInfos(gajiList);
			List<FactorRepeatedMeasureInfo> eligibleFactors = grqs
					.getEligibleFactors(ui, jviList);
			System.out.println("Eligible Factors:");
			for (FactorRepeatedMeasureInfo frmi : eligibleFactors) {
				System.out.println(frmi.getFactor());
			}

			ppForm.setFrmiList(eligibleFactors);

			String jobType = request.getParameter("gatSelector");
			ppForm.setJobType(jobType);

			ppForm.setCurPage(WizardPageState.COLLECT_FACTOR);
			return mapping.findForward(Constants.GA_SEL_FACTORS);
		} catch (Exception x) {
			log.error("showCollectFactors", x);
			return super.processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward submitBaselineGroupAnalysisJob(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> submitBaselineGroupAnalysisJob");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			PostprocessCBFJobForm ppForm = (PostprocessCBFJobForm) form;

			String[] selectedJobsItems = ppForm.getSelectedJobsItems();

			if (selectedJobsItems == null || selectedJobsItems.length == 0) {
				throw new ValidationException("No CBF job is selected!");
			}
			boolean repeatedMeasure = false;

			Set<String> selectedFactorKeySet = getSelectedFactorKeySet(request);
			List<Factor> selectedFactors = new ArrayList<Factor>(ppForm
					.getFrmiList().size());

			for (FactorRepeatedMeasureInfo frmi : ppForm.getFrmiList()) {
				if (selectedFactorKeySet.contains(frmi.getFactor().getKey())) {
					repeatedMeasure |= frmi.isARepeatedMeasureFactor();
					selectedFactors.add(frmi.getFactor());
				}
			}

			List<CBFProcessReportRec> cbfRecList = prepareSelectedProcessReportRecs(
					ppForm.getWrapper(), selectedJobsItems);
			ppForm.setSelectedCbfRecList(cbfRecList);

			String id = String.valueOf(System.currentTimeMillis());
			String description = "CBF baseline group analysis";

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			String cacheRoot = configService
					.getParamValue("download.cacheroot");
			if (cacheRoot == null || cacheRoot.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid cache root directory needs to be supplied "
								+ "during system setup with property download.cacheroot:! ");
			}

			String matlabDir = configService
					.getParamValue("cbfbirn.matlab.dir");
			if (matlabDir == null || matlabDir.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid MATLAB source directory for CBF processing "
								+ "needs to be supplied "
								+ "during system setup with property cbfbirn.matlab.dir:! ");
			}

			String afniActivationMapScript = configService
					.getParamValue("cbfbirn.afni.act.script");
			if (afniActivationMapScript == null
					|| afniActivationMapScript.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid AFNI activation map script path for group analysis "
								+ "needs to be supplied "
								+ "during system setup with property cbfbirn.afni.act.script:! ");
			}
			// the work directory for processing
			String workDir = "baseline_" + id;
			File cacheDir = new File(cacheRoot, workDir);
			cacheDir.mkdirs();

			String templateDir = super.servlet.getServletContext().getRealPath(
					Constants.TEMPLATE_DIR);

			ICBFStandardSpaceGroupAnalysisService ssgaService = ServiceFactory
					.getCBFStandardSpaceGroupAnalysisService(dbID);

			List<GroupAnalysisCBFJobInfo> gajiList = ssgaService
					.toGroupAnalysisJobInfoList(ui, cbfRecList);

			GroupAnalysisContext context = new GroupAnalysisContext(dbID,
					cacheDir.getAbsolutePath(), ppForm.getQueryInfoJSON(), id,
					gajiList, selectedFactors, repeatedMeasure,
					ppForm.getGaName(), afniActivationMapScript,
					ppForm.isDoQWarp());

			User user = WFGenUtils.getUserWithEmail(ui, dbID);
			System.out.println("PostProcessCBFJobAction:: emailTo:"
					+ user.getEmail());
			context.setEmailTo(user.getEmail());
			context.setMatlabDir(matlabDir);
			context.setTemplateDir(templateDir);

			IJob job = new BaselineGroupAnalysisJob(id, ui, description,
					context);

			// schedule job
			JobScheduler scheduler = JobScheduler.getInstance();
			scheduler.addJob(job, JobSubmissionType.INDIVIDUAL);

			ppForm.setSubmittedJobId(id);
			return mapping.findForward(Constants.BLGA_SUBMITTED);

		} catch (Exception x) {
			log.error("submitBaselineGroupAnalysisJob", x);
			return processExceptions(request, response, mapping, form, x);
		}

	}

	private Set<String> getSelectedFactorKeySet(HttpServletRequest request)
			throws ValidationException {
		String[] selectedFactorKeys = request.getParameterValues("selFactors");

		if (selectedFactorKeys == null || selectedFactorKeys.length == 0) {
			throw new ValidationException("No factor was selected!");
		}

		Set<String> selectedFactorKeySet = new HashSet<String>();
		for (String key : selectedFactorKeys) {
			selectedFactorKeySet.add(key);
		}
		selectedFactorKeys = null;
		return selectedFactorKeySet;
	}

	public ActionForward submitStandardSpaceGroupAnalysisJob(
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> submitStandardSpaceGroupAnalysisJob");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			PostprocessCBFJobForm ppForm = (PostprocessCBFJobForm) form;

			String[] selectedJobsItems = ppForm.getSelectedJobsItems();

			if (selectedJobsItems == null || selectedJobsItems.length == 0) {
				throw new ValidationException("No CBF job is selected!");
			}

			boolean repeatedMeasure = false;
			List<Factor> selectedFactors;

			Set<String> selectedFactorKeySet = getSelectedFactorKeySet(request);
			selectedFactors = new ArrayList<Factor>(ppForm.getFrmiList().size());

			for (FactorRepeatedMeasureInfo frmi : ppForm.getFrmiList()) {
				if (selectedFactorKeySet.contains(frmi.getFactor().getKey())) {
					repeatedMeasure |= frmi.isARepeatedMeasureFactor();
					selectedFactors.add(frmi.getFactor());
				}
			}

			List<CBFProcessReportRec> cbfRecList = prepareSelectedProcessReportRecs(
					ppForm.getWrapper(), selectedJobsItems);
			ppForm.setSelectedCbfRecList(cbfRecList);

			String id = String.valueOf(System.currentTimeMillis());
			String description = "CBF standard space group analysis";

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			String cacheRoot = configService
					.getParamValue("download.cacheroot");
			if (cacheRoot == null || cacheRoot.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid cache root directory needs to be supplied "
								+ "during system setup with property download.cacheroot:! ");
			}

			String matlabDir = configService
					.getParamValue("cbfbirn.matlab.dir");
			if (matlabDir == null || matlabDir.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid MATLAB source directory for CBF processing "
								+ "needs to be supplied "
								+ "during system setup with property cbfbirn.matlab.dir:! ");
			}

			String afniActivationMapScript = configService
					.getParamValue("cbfbirn.afni.act.script");
			if (afniActivationMapScript == null
					|| afniActivationMapScript.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid AFNI activation map script path for group analysis "
								+ "needs to be supplied "
								+ "during system setup with property cbfbirn.afni.act.script:! ");
			}

			// the directory where the actual matlab processing will be done
			String workDir = "standard_" + id;
			File cacheDir = new File(cacheRoot, workDir);
			cacheDir.mkdirs();

			String templateDir = super.servlet.getServletContext().getRealPath(
					Constants.TEMPLATE_DIR);

			ICBFStandardSpaceGroupAnalysisService ssgaService = ServiceFactory
					.getCBFStandardSpaceGroupAnalysisService(dbID);

			List<GroupAnalysisCBFJobInfo> gajiList = ssgaService
					.toGroupAnalysisJobInfoList(ui, cbfRecList);

			GroupAnalysisContext context = new GroupAnalysisContext(dbID,
					cacheDir.getAbsolutePath(), ppForm.getQueryInfoJSON(), id,
					gajiList, selectedFactors, repeatedMeasure,
					ppForm.getGaName(), afniActivationMapScript,
					ppForm.isDoQWarp());

			User user = WFGenUtils.getUserWithEmail(ui, dbID);
			System.out.println("PostProcessCBFJobAction:: emailTo:"
					+ user.getEmail());
			context.setEmailTo(user.getEmail());
			context.setMatlabDir(matlabDir);
			context.setTemplateDir(templateDir);

			IJob job = new GroupAnalysisJob(id, ui, description, context,
					context.getEmailTo());

			// schedule job
			JobScheduler scheduler = JobScheduler.getInstance();
			scheduler.addJob(job, JobSubmissionType.INDIVIDUAL);

			ppForm.setSubmittedJobId(id);
			return mapping.findForward(Constants.SSGA_SUBMITTED);

		} catch (Exception x) {
			log.error("submitNormalizedSpaceGroupAnalysisJob", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward collectROIs(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> collectROIs");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			PostprocessCBFJobForm ppForm = (PostprocessCBFJobForm) form;
			boolean isMultipart = ServletFileUpload.isMultipartContent(request);
			if (!isMultipart) {
				throw new ValidationException(
						"No ROI mask tar file is provided!");
			}
			// System.out.println("isMultipart:" + isMultipart);

			IAppConfigService cs = AppConfigService.getInstance();
			String cacheRoot = cs.getParamValue("download.cacheroot");
			if (cacheRoot == null || !new File(cacheRoot).isDirectory()) {
				throw new Exception(
						"Not a valid 'download.cacheroot' directory:"
								+ cacheRoot);
			}
			File workDir = new File(cacheRoot, "upload_4ga");
			if (!workDir.exists() || !workDir.isDirectory()) {
				boolean ok = workDir.mkdir();
				if (!ok) {
					throw new Exception("Cannot create directory:" + workDir);
				}
			}

			String[] selectedJobsItems = request
					.getParameterValues("selectedJobs"); // jobSelector");
			for (String sel : selectedJobsItems) {
				log.info(" >> " + sel);
			}
			if (selectedJobsItems == null || selectedJobsItems.length == 0) {
				throw new ValidationException("No CBF job is selected!");
			}
			ppForm.setSelectedJobsItems(selectedJobsItems);

			List<CBFProcessReportRec> cbfRecList = prepareSelectedProcessReportRecs(
					ppForm.getWrapper(), selectedJobsItems);
			ppForm.setSelectedCbfRecList(cbfRecList);

			if (ppForm.getTarball() == null) {
				throw new ValidationException(
						"A tar file containing ROI mask BRIKs needs to be uploaded!");
			}

			log.info("uploaded file name:" + ppForm.getTarball().getFileName());
			log.info("uploaded file size:" + ppForm.getTarball().getFileSize());

			String filename = ppForm.getTarball().getFileName();
			if (!filename.endsWith(".tar") && !filename.endsWith(".tar.gz")
					&& !filename.endsWith(".tgz")) {
				ppForm.setTarball(null);
				if (filename.trim().length() == 0) {
					throw new ValidationException(
							"A tar file containing ROI mask BRIKs needs to be uploaded!");
				} else {
					throw new ValidationException(
							"Not a valid (gzipped) tar file:" + filename);
				}
			}

			// make the filename unique
			String suffix = FileUtils.getFullFileSuffix(filename);
			String basename = FileUtils.getBasenameNoSuffix(filename);
			filename = basename + "_"
					+ String.valueOf(System.currentTimeMillis()) + suffix;
			log.info("writing uploaded file to: " + filename);
			BufferedInputStream in = null;
			BufferedOutputStream out = null;
			String localPath;
			try {
				in = new BufferedInputStream(ppForm.getTarball()
						.getInputStream(), 4096);
				localPath = new File(workDir, filename).getAbsolutePath();
				out = new BufferedOutputStream(new FileOutputStream(localPath),
						4096);
				int bytesRead;
				byte[] buf = new byte[4096];
				while ((bytesRead = in.read(buf)) != -1) {
					out.write(buf, 0, bytesRead);
				}
			} finally {
				FileUtils.close(in);
				FileUtils.close(out);
				ppForm.setTarball(null);
			}

			// TODO ROI Mask type input collection

			ICBFROIGroupAnalysisService crgaService = ServiceFactory
					.getCBFROIGroupAnalysisService(dbID);

			List<CBFROIJobAssociation> roiJobAssocList = crgaService
					.handleROIMasksTarBall(ui, workDir.getAbsolutePath(),
							filename, cbfRecList);
			ppForm.setRoiJobAssocList(roiJobAssocList);

			JSONArray roiArr = CBFROIGroupAnalysisHelper
					.toROIList(roiJobAssocList);
			JSONArray jobsArr = CBFROIGroupAnalysisHelper.toJobList(cbfRecList);
			JSONObject json = new JSONObject();
			json.put("roiList", roiArr);
			json.put("jobList", jobsArr);
			log.info("json:" + json.toString(2));
			ppForm.setJobROIAssocJSON(json.toString());

			String jobType = request.getParameter("gatSelector");
			ppForm.setJobType(jobType);

			ppForm.setCurPage(WizardPageState.VIEW);
			return mapping.findForward(Constants.ASSOCIATE);

		} catch (Exception x) {
			log.error("collectROIs", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward getDistinctScoreValues(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> getDistinctScoreValues");
		try {
			UserInfo ui = getUserInfo(request);
			String asID = request.getParameter("asID");
			Assertion.assertNotNull(asID);
			String scoreName = request.getParameter("scoreName");
			Assertion.assertNotNull(scoreName);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			ICBFSearchService ss = ServiceFactory.getCBFSearchService(dbID);
			JSONObject json = ss.getDistinctScoreValues(ui, asID, scoreName);
			response.setContentType("application/json");
			log.info("jsonStr:" + json.toString());
			response.getOutputStream().println(json.toString());
		} catch (Exception x) {
			log.error("getDistinctScoreValues", x);
			response.setContentType("application/json");
			response.getOutputStream().println((new JSONObject()).toString());
		}
		return null;
	}

	public ActionForward getDistinctProvParamValues(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> getDistinctProvParamValues");
		try {
			UserInfo ui = getUserInfo(request);
			String provName = request.getParameter("provName");
			Assertion.assertNotNull(provName);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			ICBFSearchService ss = ServiceFactory.getCBFSearchService(dbID);
			JSONObject json = ss.getDistinctProvParamValues(ui, provName);
			response.setContentType("application/json");
			log.info("jsonStr:" + json.toString());
			response.getOutputStream().println(json.toString());
		} catch (Exception x) {
			log.error("getDistinctProvParamValues", x);
			response.setContentType("application/json");
			response.getOutputStream().println((new JSONObject()).toString());
		}
		return null;
	}

	public ActionForward filterResults(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> filterResults");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			PostprocessCBFJobForm ppForm = (PostprocessCBFJobForm) form;

			CBFProcessReportRecListWrapper wrapper = ppForm.getWrapper();
			ICBFSearchService ss = ServiceFactory.getCBFSearchService(dbID);

			String queryInfoJSON = ppForm.getQueryInfoJSON();
			// log.info("queryInfoJSON=" + queryInfoJSON);

			JSONObject json = new JSONObject(queryInfoJSON);

			List<CBFProcessReportRec> filteredResults;
			if (hasOnlyExperimentSelection(json)) {
				JSONArray expIdsJsArr = json.getJSONArray("selExpIds");
				filteredResults = ss.filterRecsByExperiment(ui, expIdsJsArr,
						wrapper);
			} else {
				filteredResults = ss.filterRecsByFilterQuery(ui, json, wrapper);
			}

			JSONArray jsArr = new JSONArray();
			for (CBFProcessReportRec rec : filteredResults) {
				String key = buildKey(rec);
				jsArr.put(key);
			}
			response.setContentType("application/json");
			log.info("jsonStr:" + jsArr.toString());
			response.getOutputStream().println(jsArr.toString());
		} catch (Exception x) {
			log.error("filterResults", x);
			response.setContentType("application/json");
			JSONArray jsArr = new JSONArray();
			response.getOutputStream().println(jsArr.toString());
		}
		return null;
	}

	public ActionForward submitJob(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> submitJob");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			PostprocessCBFJobForm ppForm = (PostprocessCBFJobForm) form;

			List<CBFROIJobAssociation> finalAssocList = ppForm
					.getFinalRoiJobAssocList();

			boolean repeatedMeasure = false;

			Set<String> selectedFactorKeySet = getSelectedFactorKeySet(request);
			List<Factor> selectedFactors = new ArrayList<Factor>(ppForm
					.getFrmiList().size());

			for (FactorRepeatedMeasureInfo frmi : ppForm.getFrmiList()) {
				if (selectedFactorKeySet.contains(frmi.getFactor().getKey())) {
					repeatedMeasure |= frmi.isARepeatedMeasureFactor();
					selectedFactors.add(frmi.getFactor());
				}
			}

			String id = String.valueOf(System.currentTimeMillis());
			String description = "CBF ROI analysis processing";

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			String cacheRoot = configService
					.getParamValue("download.cacheroot");
			if (cacheRoot == null || cacheRoot.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid cache root directory needs to be supplied "
								+ "during system setup with property download.cacheroot:! ");
			}

			String matlabDir = configService
					.getParamValue("cbfbirn.matlab.dir");
			if (matlabDir == null || matlabDir.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid MATLAB source directory for CBF processing "
								+ "needs to be supplied "
								+ "during system setup with property cbfbirn.matlab.dir:! ");
			}

			// the directory where the actual matlab processing will be done
			String workDir = "roi_" + id;
			File cacheDir = new File(cacheRoot, workDir);
			cacheDir.mkdirs();

			String templateDir = super.servlet.getServletContext().getRealPath(
					Constants.TEMPLATE_DIR);

			ICBFROIGroupAnalysisService crgaService = ServiceFactory
					.getCBFROIGroupAnalysisService(dbID);

			finalAssocList = crgaService
					.populateAssociationsWithJobProvDetails(ui, finalAssocList);

			GroupROIAnalysisContext ctx = new GroupROIAnalysisContext(dbID,
					cacheDir.getAbsolutePath(), finalAssocList,
					ppForm.getQueryInfoJSON(), id, selectedFactors,
					repeatedMeasure, ppForm.getGaName());

			User user = WFGenUtils.getUserWithEmail(ui, dbID);

			System.out.println("PostProcessCBFJobAction:: emailTo:"
					+ user.getEmail());
			ctx.setTemplateDir(templateDir);
			ctx.setMatlabDir(matlabDir);
			ctx.setEmailTo(user.getEmail());

			IJob job = new GroupROIAnalysisJob(id, ui, description, ctx,
					ctx.getEmailTo());

			// schedule job
			JobScheduler scheduler = JobScheduler.getInstance();
			scheduler.addJob(job, JobSubmissionType.INDIVIDUAL);

			ppForm.setSubmittedJobId(id);
			return mapping.findForward(Constants.SUBMITTED);
		} catch (Exception x) {
			log.error("submitJob", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward getJobFilters(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> getJobFilters");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			IJobFilterManagementService jfms = ServiceFactory
					.getJobFilterManagementService(dbID);

			List<JobFilter> filters = jfms.getFilters(ui);
			JSONArray jsArr = new JSONArray();
			for (JobFilter jf : filters) {
				JSONObject js = new JSONObject();
				JSONUtils.addStringField(js, "name", jf.getName(), "");
				JSONUtils.addStringField(js, "desc", jf.getDescription(), "");
				js.put("filter", jf.getFilterExpr());
				jsArr.put(js);
			}
			response.setContentType("application/json");
			log.info("filters:" + jsArr.toString());
			response.getOutputStream().println(jsArr.toString());
		} catch (Exception x) {
			log.error("getJobFilters", x);
			response.setContentType("application/json");
			response.getOutputStream().println((new JSONArray()).toString());
		}
		return null;
	}

	public ActionForward saveJobFilter(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> getJobFilters");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			String filterName = request.getParameter("filterName");
			String filterDesc = request.getParameter("filterDesc");
			String filterExpr = request.getParameter("filterExpr");
			Assertion.assertNotNull(filterExpr);

			JobFilter jf = new JobFilter();
			jf.setUserName(ui.getName());
			jf.setFilterExpr(filterExpr);
			if (filterName != null && filterName.trim().length() > 0) {
				jf.setName(filterName.trim());
			}
			if (filterDesc != null && filterDesc.trim().length() > 0) {
				jf.setDescription(filterDesc);
			}

			IJobFilterManagementService jfms = ServiceFactory
					.getJobFilterManagementService(dbID);
			jfms.saveFilter(ui, jf);

		} catch (Exception x) {
			log.error("saveFilter", x);
			response.setContentType("application/json");
			throw x;
		}
		return null;
	}

	private boolean hasOnlyExperimentSelection(JSONObject searchFilterJSON)
			throws JSONException {
		boolean hasQuery = false;
		boolean hasExps = false;
		if (searchFilterJSON.has("selExpIds")) {
			JSONArray jsonArray = searchFilterJSON.getJSONArray("selExpIds");
			hasExps = jsonArray.length() > 0;
		}
		if (!hasExps) {
			return false;
		}
		if (searchFilterJSON.has("asQPIList")) {
			hasQuery |= searchFilterJSON.getJSONArray("asQPIList").length() > 0;
		}
		if (!hasQuery && searchFilterJSON.has("jobProvQPIList")) {
			hasQuery |= searchFilterJSON.getJSONArray("jobProvQPIList")
					.length() > 0;
		}

		if (!hasQuery && searchFilterJSON.has("jobResultQPIList")) {
			hasQuery |= searchFilterJSON.getJSONArray("jobResultQPIList")
					.length() > 0;
		}

		return !hasQuery && hasExps;
	}

	private List<JobVisitInfo> prepJobVisitInfoList(
			List<CBFROIJobAssociation> finalRoiJobAssocList) {
		List<JobVisitInfo> jviList = new ArrayList<CBFROIJobAssociation.JobVisitInfo>(
				finalRoiJobAssocList.size());
		for (CBFROIJobAssociation crja : finalRoiJobAssocList) {
			for (JobVisitInfo jvi : crja.getCandidates()) {
				jviList.add(jvi);
			}
		}
		return jviList;
	}

	@SuppressWarnings("unused")
	private String buildJobItemKey(JobVisitInfo jvi) {
		StringBuilder sb = new StringBuilder(128);
		sb.append(jvi.getJobID()).append(':').append(jvi.getSubjectID());
		sb.append(':').append(jvi.getVisitID()).append(':');
		sb.append(jvi.getExpName().replaceAll("\\s+", "_"));
		return sb.toString();
	}

	private JSONObject prepareJobSelectionDropdownData(
			CBFProcessReportRecListWrapper resultSet) throws JSONException {
		JSONObject js = new JSONObject();
		JSONArray recArr = new JSONArray();
		js.put("jobs", recArr);
		for (CBFProcessReportRec record : resultSet.getRecords()) {
			String key = buildKey(record);
			String label = buildLabel(record);
			JSONObject recJS = new JSONObject();
			recJS.put("key", key);
			recJS.put("label", label);
			recArr.put(recJS);
		}
		return js;
	}

	private List<CBFProcessReportRec> prepareSelectedProcessReportRecs(
			CBFProcessReportRecListWrapper resultSet, String[] selectedJobsItems) {
		List<CBFProcessReportRec> list = new ArrayList<CBFProcessReportRec>(
				selectedJobsItems.length);
		Map<String, CBFProcessReportRec> map = new HashMap<String, CBFProcessReportRec>();
		for (CBFProcessReportRec record : resultSet.getRecords()) {
			String key = buildKey(record);
			map.put(key, record);
		}
		for (String key : selectedJobsItems) {
			CBFProcessReportRec cbfRec = map.get(key);
			Assertion.assertNotNull(cbfRec);
			list.add(cbfRec);
		}
		return list;

	}

	private String buildKey(CBFProcessReportRec record) {
		StringBuilder sb = new StringBuilder(128);
		sb.append(record.getJobID()).append(':').append(record.getSubjectID());
		sb.append(':').append(record.getVisitId()).append(':');
		sb.append(record.getProjectName());
		return sb.toString();
	}

	private String buildLabel(CBFProcessReportRec record) {
		StringBuilder sb = new StringBuilder(128);
		sb.append("Job:").append(record.getJobID()).append(" - [")
				.append(record.getTag()).append(']');
		sb.append(" - ").append(record.getSubjectID());
		String fvd = DateTimeUtils.formatDate(record.getVisitDate());
		sb.append(" ").append(fvd).append(" (").append(record.getVisitId());
		sb.append(") - ").append(record.getProjectName());
		return sb.toString();
	}

	private List<JobVisitInfo> getAllJobVisitInfos(
			List<GroupAnalysisCBFJobInfo> jiList) {
		List<JobVisitInfo> jviList = new ArrayList<JobVisitInfo>(jiList.size());
		for (GroupAnalysisCBFJobInfo gaji : jiList) {
			jviList.add(gaji.getJvi());
		}
		return jviList;
	}
}
