package clinical.web.actions;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Rawdata;
import clinical.utils.Assertion;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ImageHandler;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.forms.SubjectVisitForm;
import clinical.web.services.SecurityService;
import clinical.web.vo.Visit;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SRBBrowseAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class SRBBrowseAction extends BaseAction {

	public SRBBrowseAction() {
	}

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IDBPoolService pool = null;
		Connection con = null;
		try {
			UserInfo userInfo = getUserInfo(request);
			IAuthenticationService authService = ServiceFactory
					.getAuthenticationService();

			HttpSession session = request.getSession(false);
			UserInfo ui = null;
			SubjectVisitForm svForm = (SubjectVisitForm) form;

			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			pool = ServiceFactory.getPoolService(dbID);
			String siteID = svForm.getSiteID();
			SecurityService ss = (SecurityService) ServiceFactory
					.getSecurityService();
			String theDBID = ss.findDBForSiteID(siteID);

			// String theDBID = GenUtils.extractDBIDFromBIRNID(svForm
			// .getSubjectID(), dbID);

			Assertion.assertNotNull(theDBID);
			if (theDBID != dbID) {
				ui = authService.getDefaultUser(theDBID, userInfo);
			} else {
				ui = userInfo;
			}

			// get the corresponding database connection
			pool = ServiceFactory.getPoolService(theDBID);

			con = pool.getConnection(ui.getName());

			ImageHandler imgHandler = ServiceFactory.getImageHandlerService();

			Visit vi = (Visit) svForm.getScanVisits().get(0);

			BigDecimal scanVisitID = new BigDecimal("" + vi.getComponentID());
			BigDecimal scanExpID = new BigDecimal("" + vi.getExperimentID());

			/** @todo needs segment level granularity for raw data browsing */
			List<Rawdata> rawDatas = imgHandler.getRawDataForSubject(dbID, con,
					svForm.getSubjectID(), scanVisitID, scanExpID, null);
			Rawdata rd = (Rawdata) rawDatas.get(0);

			// Properties appProps = (Properties) session.getServletContext()
			// .getAttribute(Constants.APP_PROPERTIES_KEY);

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();
			String portalURL = configService
					.getParamValue(Constants.PORTAL_URL);
			String portalBrowserAdr = configService
					.getParamValue(Constants.PORTAL_BROWSER_ADDRESS);
			StringBuffer buf = new StringBuffer(128); // portalURL +
			// portalBrowserAdr;
			buf.append(portalURL).append(portalBrowserAdr)
					.append("?browseloc=");
			buf.append(java.net.URLEncoder.encode(rd.getDatauri(), "UTF-8"));

			svForm.setSrbBrowserURL(buf.toString());

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}

	}

}
