package clinical.web.common;

/**
 * An interface to check if a user is allowed to carry a particular action on
 * the system.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: IAuthorizationService.java 565 2012-03-15 00:13:42Z bozyurt $
 */

public interface IAuthorizationService {

	/**
	 * Checks if a user is allowed to carry an action. An action can be taught
	 * as a privilege.
	 * 
	 * @param userInfo
	 *            a <code>UserInfo</code> object holding non-sensitive user
	 *            information
	 * @param dbID
	 * @param privName
	 * @param experimentID
	 * @return true if the user is allowed to carry the action
	 */
	public boolean isAuthorized(UserInfo userInfo, String dbID,
			PrivilegeLabel privName, Integer experimentID);

	public enum PrivilegeLabel {
		ADMIN("admin"), CREATE_PROJECT("create-project"), CREATE_USER(
				"create-user"), CREATE_SUBJECT("create-subject"), READ("read"), UPDATE(
				"update"), DELETE("delete");

		private PrivilegeLabel(String label) {
			this.label = label;
		}

		private String label;

		public String getLabel() {
			return label;
		}

		@Override
		public String toString() {
			return label;
		}
		
		public static PrivilegeLabel findByLabel(String label) {
			// System.out.println("PrivilegeLabel:: label:" + label);
			for (PrivilegeLabel p : PrivilegeLabel.values()) {
				if (p.getLabel().equals(label)) {
					return p;
				}
			}
			return null;
		}
	}
}