package clinical.web.common.query;

import java.util.Collection;
import java.util.Date;

import org.apache.struts.util.LabelValueBean;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.utils.Assertion;
import clinical.web.vo.JobProvenanceInfo.JobProvenanceParamType;
import clinical.web.vo.JobProvenanceInfo.JobProvenanceParamInfo;
import clinical.web.vo.RangeInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class JobProvQueryPartInfo extends AbstractQueryPartInfo {
	private static final long serialVersionUID = 1L;
	private JobProvenanceParamInfo paramInfo;
	private JobProvenanceParamType paramType;
	private RangeInfo rangeInfo;
	private String connector;
	public final static String NONE = "NONE";
	public final static String AND = "AND";
	public final static String OR = "OR";

	public JobProvQueryPartInfo() {
	}

	public JobProvQueryPartInfo(JobProvenanceParamInfo paramInfo,
			JobProvenanceParamType paramType) {
		super();
		this.paramInfo = paramInfo;
		this.paramType = paramType;
		prepareLogicalOps();
	}

	public JobProvQueryPartInfo(JobProvQueryPartInfo other) {
		super(other);
		this.paramInfo = other.paramInfo;
		this.paramType = other.paramType;
		this.rangeInfo = other.rangeInfo;
		this.connector = other.connector;
	}

	public RangeInfo getRangeInfo() {
		return rangeInfo;
	}

	public void setRangeInfo(RangeInfo rangeInfo) {
		this.rangeInfo = rangeInfo;
	}

	public String getConnector() {
		return connector;
	}

	public String getFormattedRange() {
		return RangeInfo.getFormattedRange(rangeInfo);
	}

	@Override
	public Collection<LabelValueBean> getRhsEnums() {
		return rhsEnums;
	}

	/**
	 * converts this single variable query part to the corresponding
	 * {@link SearchPredicate} representation ignoring any logical connectives
	 * with other query parts
	 * 
	 * @return
	 */
	public SearchPredicate toSearchPredicate() {
		SearchPredicate.Range range = null;
		SearchPredicate sp = null;
		SearchPredicate.DateRange dateRange = null;
		int logOp = getOperator();
		int spType = QueryUtils.getSearchPredicateType(getParamType());
		if (getLowBound() != null && getLowBound().length() > 0
				&& getUppBound() != null && getUppBound().length() > 0) {
			Object v = QueryUtils.convertToType(getLowBound(), spType);
			if (v instanceof Date) {
				Date lowBound = (Date) v;
				Date uppBound = (Date) QueryUtils.convertToType(
						getUppBound(), spType);
				dateRange = new SearchPredicate.DateRange(lowBound,
						uppBound);
			} else {
				Number lowBound = (Number) QueryUtils.convertToType(
						getLowBound(), spType);
				Number uppBound = (Number) QueryUtils.convertToType(
						getUppBound(), spType);

				range = new SearchPredicate.Range(lowBound, uppBound);
			}
		}
		Object value = null;
		if (range == null && dateRange == null) {
			if (getRhs().trim().equals("*")) {
				value = getRhs().trim();
			} else {
				value = QueryUtils.convertToType(getRhs(), spType);
			}
		}
		Object attribute = getParamInfo();
		if (range != null) {
			sp = new SearchPredicate(attribute, range, logOp, spType);
		} else if (dateRange != null) {
			sp = new SearchPredicate(attribute, dateRange, logOp, spType);
		} else {
			sp = new SearchPredicate(attribute, value, logOp, spType);
		}
		return sp;
	}

	public JSONObject toJSON(JSONObject js) throws JSONException {
		js = super.toJSON(js);
		js.put("connector", connector);
		if (paramInfo != null) {
			js.put("prov", paramInfo.toJSON());
		}
		if (paramType != null) {
			js.put("provType", paramType.toString());
		}
		return js;
	}

	public static JobProvQueryPartInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		JSONObject provJS = js.getJSONObject("prov");
		JobProvenanceParamInfo jppi = JobProvenanceParamInfo
				.initializeFormJSON(provJS);
		String provType = js.getString("provType");
		JobProvenanceParamType paramType = JobProvenanceParamType.valueOf(provType);
		Assertion.assertNotNull(paramType);
		JobProvQueryPartInfo qpi = new JobProvQueryPartInfo(jppi, paramType);
		qpi.operator = js.getInt("operator");
		if (js.has("lowBound") && js.has("uppBound")) {
			qpi.lowBound = js.getString("lowBound");
			qpi.uppBound = js.getString("uppBound");
		}
		if (js.has("rhs"))
			qpi.rhs = js.getString("rhs");

		qpi.connector = js.getString("connector");
		if (js.has("partIdx")) {
			qpi.setPartIdx(js.getInt("partIdx"));
		}
		return qpi;
	}

	private void prepareLogicalOps() {
		if (paramType == JobProvenanceParamType.INT
				|| paramType == JobProvenanceParamType.REAL) {
			prepareNumericLogicalOps();
		} else if (paramType == JobProvenanceParamType.STRING
				|| paramType == JobProvenanceParamType.BOOL) {
			prepareVarcharLogicalOps();
		} else if (paramType == JobProvenanceParamType.DATE) {
			prepareDateLogicalOps();
		} else {
			throw new RuntimeException(paramType.toString()
					+ " is not a supported type!");
		}
	}

	public JobProvenanceParamInfo getParamInfo() {
		return paramInfo;
	}

	public JobProvenanceParamType getParamType() {
		return paramType;
	}

	@Override
	public String toString() {
		return "JobProvQueryPartInfo [paramInfo=" + paramInfo + ", paramType="
				+ paramType + ", rangeInfo=" + rangeInfo + ", connector="
				+ connector + ", logicalOps=" + logicalOps + ", operator="
				+ operator + ", rhs=" + rhs + ", lowBound=" + lowBound
				+ ", uppBound=" + uppBound + ", useBetween=" + useBetween
				+ ", hasEnums=" + hasEnums + ", rhsEnums=" + rhsEnums
				+ ", rhsIdx=" + rhsIdx + ", scoreCodeMap=" + scoreCodeMap
				+ ", partIdx=" + partIdx + "]";
	}

	public void setConnector(String connector) {
		this.connector = connector;
	}

}
