package clinical.web.common.security;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Role.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class Role {
	private String name;
	private String description;
	private List<ProjectPrivilege> projectPrivs = new ArrayList<ProjectPrivilege>();
	private List<Privilege> privileges = new ArrayList<Privilege>(1);

	public Role(String name, String description) {
		super();
		this.name = name;
		this.description = description;
	}
	
	public void addProjectPrivilege(ProjectPrivilege pp) {
		projectPrivs.add(pp);
	}
	
	public void addPrivilege(Privilege priv) {
		privileges.add(priv);
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public List<ProjectPrivilege> getProjectPrivs() {
		return projectPrivs;
	}

	public List<Privilege> getPrivileges() {
		return privileges;
	}


}
