package clinical.web.common.vo;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.utils.CSVParser;
import clinical.utils.DateTimeUtils;
import clinical.utils.FileUtils;
import clinical.web.vo.CBFROIJobAssociation.JobVisitInfo;
import clinical.web.workflow.common.JSONUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class GroupCBFReportRec {
	private final String jobID;
	private Integer jobUniqueID;
	private final String analysisType;
	private final String filterQuery;
	private final Date jobDate;
	private final List<AugmentedJobVisitInfo> ajviList;
	private final List<GAResult> gaResults;
	private final ROISummary roiSummary;
	private final String name;

	public GroupCBFReportRec(String jobID, Integer jobUniqueID,
			String analysisType, String filterQuery, Date jobDate,
			List<AugmentedJobVisitInfo> ajviList, List<GAResult> gaResults,
			ROISummary roiSummary, String name) {
		this.jobID = jobID;
		this.jobUniqueID = jobUniqueID;
		this.analysisType = analysisType;
		this.filterQuery = filterQuery;
		this.jobDate = jobDate;
		this.ajviList = ajviList;
		this.gaResults = gaResults;
		this.roiSummary = roiSummary;
		this.name = name;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("jobID", jobID);
		js.put("juid", jobUniqueID);
		js.put("analysisType", analysisType);
		js.put("filterQuery", filterQuery);
		if (jobDate != null) {
			js.put("jobDate", DateTimeUtils.formatDate(jobDate));
		} else {
			js.put("jobDate", "NA");
		}
		JSONArray jsArr = new JSONArray();
		js.put("ajviList", jsArr);
		for (AugmentedJobVisitInfo ajvi : ajviList) {
			jsArr.put(ajvi.toJSON());
		}

		jsArr = new JSONArray();
		js.put("gaResults", jsArr);
		if (gaResults != null) {
			for (GAResult gar : gaResults) {
				jsArr.put(gar.toJSON());
			}
		}
		if (roiSummary != null) {
			js.put("roiSummary", roiSummary.toJSON());
		} else {
			js.put("roiSummary", new JSONObject());
		}
		
		JSONUtils.addStringField(js, "name", name, "");
		return js;
	}

	public String getJobID() {
		return jobID;
	}

	public Integer getJobUniqueID() {
		return jobUniqueID;
	}

	public String getAnalysisType() {
		return analysisType;
	}

	public String getFilterQuery() {
		return filterQuery;
	}

	public List<AugmentedJobVisitInfo> getAjviList() {
		return ajviList;
	}

	public List<GAResult> getGaResults() {
		return gaResults;
	}

	public Date getJobDate() {
		return jobDate;
	}

	public static class ROISummary {
		private List<List<String>> rows;

		public ROISummary(String csvFile) throws IOException {
			CSVParser parser = new CSVParser();
			parser.extractData(csvFile);
			this.rows = parser.getRows();
		}

		public JSONObject toJSON() throws JSONException {
			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("header", jsArr);
			List<String> headerRow = rows.get(0);
			for (String header : headerRow) {
				jsArr.put(header);
			}
			jsArr = new JSONArray();
			js.put("rows", jsArr);
			for (int i = 1; i < rows.size(); i++) {
				List<String> row = rows.get(i);
				jsArr.put(toJSON(row));
			}
			return js;
		}

		private JSONObject toJSON(List<String> row) throws JSONException {
			JSONObject js = new JSONObject();
			JSONArray jsArr = new JSONArray();
			js.put("r", jsArr);
			for (String el : row) {
				jsArr.put(el);
			}
			return js;
		}

	}// ;

	public static class GAResult {
		protected String name;
		protected String type;
		protected String path;
		protected String content;

		public GAResult(String name, String type, String path) {
			super();
			this.name = name;
			this.type = type;
			this.path = path;
		}

		public String getName() {
			return name;
		}

		public String getType() {
			return type;
		}

		public String getPath() {
			return path;
		}

		public static GAResult newImageResult(String name, String path) {
			return new GAResult(name, "img", path);
		}

		public static GAResult newTextFileResult(String name, String path) {
			return new GAResult(name, "tf", path);
		}

		public JSONObject toJSON() throws JSONException {
			JSONObject js = new JSONObject();
			js.put("name", name);
			js.put("type", type);
			js.put("path", path);
			try {
				String cnt = getContent();
				if (cnt != null) {
					js.put("context", cnt);
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
			return js;
		}

		public void setPath(String path) {
			this.path = path;
		}

		public String getContent() throws IOException {
			if (!type.equals("tf")) {
				return null;
			}
			if (content == null) {
				List<String> lines = FileUtils.readLines(path);
				int size = 0;
				for (String line : lines) {
					size += line.length();
				}
				StringBuilder sb = new StringBuilder(size + lines.size());
				for (Iterator<String> it = lines.iterator(); it.hasNext();) {
					String line = it.next();
					sb.append(line);
					if (it.hasNext())
						sb.append("\n");
				}
				this.content = sb.toString();
			}
			return content;
		}
	}// ;

	public static class AugmentedJobVisitInfo {
		private final JobVisitInfo jvi;
		private final String gender;
		private final String age;
		private final String condition;

		public AugmentedJobVisitInfo(JobVisitInfo jvi, String gender,
				String age, String condition) {
			super();
			this.jvi = jvi;
			this.gender = gender;
			this.age = age;
			this.condition = condition;
		}

		public JobVisitInfo getJvi() {
			return jvi;
		}

		public String getGender() {
			return gender;
		}

		public String getAge() {
			return age;
		}

		public String getCondition() {
			return condition;
		}

		public JSONObject toJSON() throws JSONException {
			JSONObject js = new JSONObject();
			JSONUtils.addStringField(js, "gender", gender, "");
			JSONUtils.addStringField(js, "age", age, "");
			JSONUtils.addStringField(js, "condition", condition, "");
			js.put("jvi", jvi.toJSON());
			return js;
		}

	}// ;

	public ROISummary getRoiSummary() {
		return roiSummary;
	}

	public String getName() {
		return name;
	}

}
